/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.AllocatableValue;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.sparc.SPARCIndexedAddressValue;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public class SPARCIndexedAddressNode
extends AddressNode
implements LIRLowerable {
    public static final NodeClass<SPARCIndexedAddressNode> TYPE = NodeClass.create(SPARCIndexedAddressNode.class);
    @Node.Input
    private ValueNode base;
    @Node.Input
    private ValueNode index;

    public SPARCIndexedAddressNode(ValueNode base, ValueNode index) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.base = base;
        this.index = index;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        SPARCLIRGenerator tool = (SPARCLIRGenerator)gen.getLIRGeneratorTool();
        AllocatableValue baseValue = tool.asAllocatable(gen.operand(this.base));
        AllocatableValue indexValue = tool.asAllocatable(gen.operand(this.index));
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        AllocatableValue indexReference = LIRKind.derivedBaseFromValue(indexValue);
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, indexReference);
        gen.setResult(this, new SPARCIndexedAddressValue(kind, baseValue, indexValue));
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        this.updateUsages(this.base, base);
        this.base = base;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    public void setIndex(ValueNode index) {
        this.updateUsages(this.index, index);
        this.index = index;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return Long.MAX_VALUE;
    }
}

