/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.phases.Phase;

public class SPARCIntegerCompareCanonicalizationPhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        for (Node n : graph.getNodes()) {
            if (!(n instanceof CompareNode)) continue;
            CompareNode enode = (CompareNode)n;
            SPARCIntegerCompareCanonicalizationPhase.min32(enode, enode.getX());
            SPARCIntegerCompareCanonicalizationPhase.min32(enode, enode.getY());
        }
    }

    private static void min32(CompareNode enode, ValueNode v) {
        int bits;
        Stamp s = v.stamp(NodeView.DEFAULT);
        if (s instanceof IntegerStamp && (bits = ((IntegerStamp)s).getBits()) != 32 && bits != 64) {
            ValueNode replacement;
            bits = bits <= 32 ? 32 : 64;
            if (v instanceof ConstantNode) {
                PrimitiveConstant newConst;
                if (bits == 32) {
                    newConst = JavaConstant.forInt((int)v.asJavaConstant().asInt());
                } else if (bits == 64) {
                    newConst = JavaConstant.forLong((long)v.asJavaConstant().asLong());
                } else {
                    throw GraalError.shouldNotReachHere();
                }
                long mask = CodeUtil.mask((int)bits);
                replacement = v.graph().addOrUnique(new ConstantNode((Constant)newConst, (Stamp)IntegerStamp.stampForMask(bits, newConst.asLong() & mask, newConst.asLong() & mask)));
            } else {
                replacement = v.graph().addOrUnique(new SignExtendNode(v, bits));
            }
            v.replaceAtUsages(replacement, x -> x == enode);
        }
    }
}

