/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class LogStream {
    public static final LogStream SINK = new LogStream();
    private static final PrintStream SINK_PS = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    });
    private final PrintStream ps;
    private final StringBuilder lineBuffer;
    private int indentationLevel;
    private char indentation = (char)32;
    private boolean indentationDisabled;
    public static final String LINE_SEPARATOR = System.lineSeparator();

    private LogStream() {
        this.ps = null;
        this.lineBuffer = null;
    }

    public final PrintStream out() {
        if (this.ps == null) {
            return SINK_PS;
        }
        return this.ps;
    }

    public LogStream(OutputStream os) {
        this.ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        this.lineBuffer = new StringBuilder(100);
    }

    public LogStream(LogStream log) {
        this.ps = log.ps;
        this.lineBuffer = new StringBuilder(100);
    }

    private void indent() {
        if (this.ps != null && !this.indentationDisabled && this.indentationLevel != 0) {
            while (this.lineBuffer.length() < this.indentationLevel) {
                this.lineBuffer.append(this.indentation);
            }
        }
    }

    private LogStream flushLine(boolean withNewline) {
        if (this.ps != null) {
            if (withNewline) {
                this.lineBuffer.append(LINE_SEPARATOR);
            }
            this.ps.print(this.lineBuffer.toString());
            this.ps.flush();
            this.lineBuffer.setLength(0);
        }
        return this;
    }

    public void flush() {
        if (this.ps != null) {
            if (this.lineBuffer.length() != 0) {
                this.flushLine(false);
            }
            this.ps.flush();
        }
    }

    public int position() {
        return this.lineBuffer == null ? 0 : this.lineBuffer.length();
    }

    public int indentationLevel() {
        return this.indentationLevel;
    }

    public void adjustIndentation(int delta) {
        this.indentationLevel = delta < 0 ? Math.max(0, this.indentationLevel + delta) : (this.indentationLevel += delta);
    }

    public char indentation() {
        return this.indentation;
    }

    public void disableIndentation() {
        this.indentationDisabled = true;
    }

    public void enableIndentation() {
        this.indentationDisabled = false;
    }

    public void setIndentation(char c) {
        this.indentation = c;
    }

    public LogStream fillTo(int position, char filler) {
        if (this.ps != null) {
            this.indent();
            while (this.lineBuffer.length() < position) {
                this.lineBuffer.append(filler);
            }
        }
        return this;
    }

    public LogStream print(boolean b) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(b);
        }
        return this;
    }

    public LogStream println(boolean b) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(b);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(char c) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(c);
            if (c == '\n' && this.lineBuffer.indexOf(LINE_SEPARATOR, this.lineBuffer.length() - LINE_SEPARATOR.length()) != -1) {
                this.flushLine(false);
            }
        }
        return this;
    }

    public LogStream println(char c) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(c);
            this.flushLine(true);
        }
        return this;
    }

    public LogStream print(int i) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(i);
        }
        return this;
    }

    public LogStream println(int i) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(i);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(float f) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(f);
        }
        return this;
    }

    public LogStream println(float f) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(f);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(long l) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(l);
        }
        return this;
    }

    public LogStream println(long l) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(l);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(double d) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(d);
        }
        return this;
    }

    public LogStream println(double d) {
        if (this.ps != null) {
            this.indent();
            this.lineBuffer.append(d);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(String s) {
        if (this.ps != null) {
            if (s == null) {
                this.indent();
                this.lineBuffer.append(s);
                return this;
            }
            int index = 0;
            int next = s.indexOf(LINE_SEPARATOR, index);
            while (index < s.length()) {
                this.indent();
                if (next > index || next == 0) {
                    this.lineBuffer.append(s.substring(index, next));
                    this.flushLine(true);
                    index = next + LINE_SEPARATOR.length();
                    next = s.indexOf(LINE_SEPARATOR, index);
                    continue;
                }
                this.lineBuffer.append(s.substring(index));
                break;
            }
        }
        return this;
    }

    public LogStream println(String s) {
        if (this.ps != null) {
            this.print(s);
            this.flushLine(true);
        }
        return this;
    }

    public LogStream printf(String format, Object ... args) {
        if (this.ps != null) {
            this.print(String.format(format, args));
        }
        return this;
    }

    public LogStream println() {
        if (this.ps != null) {
            this.indent();
            this.flushLine(true);
        }
        return this;
    }
}

