/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.util.Arrays;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Signature;

public class MethodFilter {
    private final Pattern clazz;
    private final Pattern methodName;
    private final Pattern[] signature;

    public static MethodFilter[] parse(String commaSeparatedPatterns) {
        String[] filters = commaSeparatedPatterns.split(",");
        MethodFilter[] methodFilters = new MethodFilter[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            methodFilters[i] = new MethodFilter(filters[i]);
        }
        return methodFilters;
    }

    public static boolean matches(MethodFilter[] filters, JavaMethod method) {
        for (MethodFilter filter : filters) {
            if (!filter.matches(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesClassName(MethodFilter[] filters, String className) {
        for (MethodFilter filter : filters) {
            if (!filter.matchesClassName(className)) continue;
            return true;
        }
        return false;
    }

    public MethodFilter(String sourcePattern) {
        String pattern = sourcePattern.trim();
        int pos = pattern.indexOf(40);
        if (pos != -1) {
            if (pattern.charAt(pattern.length() - 1) != ')') {
                throw new IllegalArgumentException("missing ')' at end of method filter pattern: " + pattern);
            }
            String[] signatureClasses = pattern.substring(pos + 1, pattern.length() - 1).split(";", -1);
            this.signature = new Pattern[signatureClasses.length];
            for (int i = 0; i < signatureClasses.length; ++i) {
                this.signature[i] = MethodFilter.createClassGlobPattern(signatureClasses[i].trim());
            }
            pattern = pattern.substring(0, pos);
        } else {
            this.signature = null;
        }
        pos = pattern.lastIndexOf(46);
        if (pos != -1) {
            this.clazz = MethodFilter.createClassGlobPattern(pattern.substring(0, pos));
            this.methodName = Pattern.compile(MethodFilter.createGlobString(pattern.substring(pos + 1)));
        } else {
            this.clazz = null;
            this.methodName = Pattern.compile(MethodFilter.createGlobString(pattern));
        }
    }

    public static String createGlobString(String pattern) {
        return Pattern.quote(pattern).replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
    }

    private static Pattern createClassGlobPattern(String pattern) {
        if (pattern.length() == 0) {
            return null;
        }
        if (pattern.contains(".")) {
            return Pattern.compile(MethodFilter.createGlobString(pattern));
        }
        return Pattern.compile("([^\\.\\$]*[\\.\\$])*" + MethodFilter.createGlobString(pattern));
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    public boolean matchesClassName(String className) {
        return this.clazz == null || this.clazz.matcher(className).matches();
    }

    public boolean matches(JavaMethod o) {
        if (this.methodName != null && !this.methodName.matcher(o.getName()).matches()) {
            return false;
        }
        if (this.clazz != null && !this.clazz.matcher(o.getDeclaringClass().toJavaName()).matches()) {
            return false;
        }
        return this.matchesSignature(o.getSignature());
    }

    private boolean matchesSignature(Signature sig) {
        if (this.signature == null) {
            return true;
        }
        if (sig.getParameterCount(false) != this.signature.length) {
            return false;
        }
        for (int i = 0; i < this.signature.length; ++i) {
            JavaType type = sig.getParameterType(i, null);
            String javaName = type.toJavaName();
            if (this.signature[i] == null || this.signature[i].matcher(javaName).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String javaClassName, String name, Signature sig) {
        assert (sig != null || this.signature == null);
        if (this.methodName != null && !this.methodName.matcher(name).matches()) {
            return false;
        }
        if (this.clazz != null && !this.clazz.matcher(javaClassName).matches()) {
            return false;
        }
        return this.matchesSignature(sig);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("MethodFilter[");
        String sep = "";
        if (this.clazz != null) {
            buf.append(sep).append("clazz=").append(this.clazz);
            sep = ", ";
        }
        if (this.methodName != null) {
            buf.append(sep).append("methodName=").append(this.methodName);
            sep = ", ";
        }
        if (this.signature != null) {
            buf.append(sep).append("signature=").append(Arrays.toString(this.signature));
            sep = ", ";
        }
        return buf.append("]").toString();
    }
}

