/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class PathUtilities {
    private static final int MAX_FILE_NAME_LENGTH = 242;
    private static final String ELLIPSIS = "...";

    public static String sanitizeFileName(String name) {
        try {
            Path path = Paths.get(name, new String[0]);
            if (path.getNameCount() == 0) {
                return name;
            }
        }
        catch (InvalidPathException path) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != File.separatorChar && c != ' ' && !Character.isISOControl(c)) {
                try {
                    Paths.get(String.valueOf(c), new String[0]);
                    buf.append(c);
                    continue;
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
            buf.append('_');
        }
        return buf.toString();
    }

    static Path createUnique(OptionValues options, OptionKey<String> baseNameOption, String id, String label, String ext, boolean createMissingDirectory) throws IOException {
        String prefix;
        String uniqueTag = "";
        int dumpCounter = 1;
        if (id == null) {
            prefix = baseNameOption.getValue(options);
            int slash = prefix.lastIndexOf(File.separatorChar);
            prefix = prefix.substring(slash + 1);
        } else {
            prefix = id;
        }
        while (true) {
            String fileName;
            int fileNameLengthWithoutLabel;
            int labelLengthLimit;
            if ((labelLengthLimit = 242 - (fileNameLengthWithoutLabel = uniqueTag.length() + ext.length() + prefix.length() + "[]".length())) < ELLIPSIS.length()) {
                String suffix = uniqueTag + ext;
                int idLengthLimit = Math.min(242 - suffix.length(), prefix.length());
                fileName = PathUtilities.sanitizeFileName(prefix.substring(0, idLengthLimit) + suffix);
            } else if (label == null) {
                fileName = PathUtilities.sanitizeFileName(prefix + uniqueTag + ext);
            } else {
                String adjustedLabel = label;
                if (label.length() > labelLengthLimit) {
                    adjustedLabel = label.substring(0, labelLengthLimit - ELLIPSIS.length()) + ELLIPSIS;
                }
                fileName = PathUtilities.sanitizeFileName(prefix + '[' + adjustedLabel + ']' + uniqueTag + ext);
            }
            Path dumpDir = DebugOptions.getDumpDirectory(options);
            Path result = Paths.get(dumpDir.toString(), fileName);
            try {
                if (createMissingDirectory) {
                    return Files.createDirectory(result, new FileAttribute[0]);
                }
                try {
                    return Files.createFile(result, new FileAttribute[0]);
                }
                catch (AccessDeniedException e) {
                    throw Files.isDirectory(result, LinkOption.NOFOLLOW_LINKS) ? new FileAlreadyExistsException(e.getFile()) : e;
                }
            }
            catch (FileAlreadyExistsException e) {
                uniqueTag = "_" + dumpCounter++;
                continue;
            }
            break;
        }
    }
}

