/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.VerificationError;

class NodeIdAccessor {
    final Graph graph;
    final int epoch;

    NodeIdAccessor(Graph graph) {
        this.graph = graph;
        this.epoch = graph.compressions;
    }

    Graph getGraph() {
        return this.graph;
    }

    boolean verifyIdsAreStable() {
        int compressions = this.graph.compressions - this.epoch;
        if (compressions != 0) {
            throw new VerificationError("accessing node id in %s across %d graph compression%s", this.graph, compressions, compressions == 1 ? "" : "s");
        }
        return true;
    }

    int getNodeId(Node node) {
        assert (this.verifyIdsAreStable());
        return node.id();
    }
}

