/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Arrays;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.GraalServiceThread;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

class CompilationWatchDog
implements Runnable,
AutoCloseable {
    private static final int SPIN_TIMEOUT_MS = 1000;
    private WatchDogState state = WatchDogState.SLEEPING;
    private final Thread compilerThread;
    private final long startDelayMilliseconds;
    private final long stackTraceIntervalMilliseconds;
    private final int nonFatalIdenticalCompilationSnapshots;
    private volatile ResolvedJavaMethod currentMethod;
    private volatile int currentId;
    private ResolvedJavaMethod lastWatched;
    private long elapsed;
    private int traceIntervals;
    private int numberOfIdenticalStackTraces;
    private StackTraceElement[] lastStackTrace;
    private static final boolean DEBUG = Boolean.parseBoolean((String)Services.getSavedProperties().get("debug.graal.CompilationWatchDog"));
    private static final ThreadLocal<CompilationWatchDog> WATCH_DOGS = new ThreadLocal();

    CompilationWatchDog(Thread compilerThread, long startDelayMilliseconds, long stackTraceIntervalMilliseconds, int nonFatalIdenticalCompilationSnapshots) {
        this.compilerThread = compilerThread;
        this.startDelayMilliseconds = startDelayMilliseconds;
        this.stackTraceIntervalMilliseconds = stackTraceIntervalMilliseconds;
        this.nonFatalIdenticalCompilationSnapshots = nonFatalIdenticalCompilationSnapshots;
    }

    public void startCompilation(ResolvedJavaMethod method, int id) {
        this.trace("start %s", HotSpotGraalCompiler.fmt(method));
        this.currentMethod = method;
        this.currentId = id;
    }

    public void stopCompilation() {
        this.trace(" stop %s", HotSpotGraalCompiler.fmt(this.currentMethod));
        this.currentMethod = null;
    }

    private void reset() {
        this.elapsed = 0L;
        this.traceIntervals = 0;
        this.numberOfIdenticalStackTraces = 0;
        this.lastWatched = null;
        this.lastStackTrace = null;
        this.state = WatchDogState.SLEEPING;
    }

    private void tick(WatchDogState newState) {
        this.state = newState;
    }

    private boolean recordStackTrace(StackTraceElement[] newStackTrace) {
        if (this.lastStackTrace == null) {
            this.lastStackTrace = newStackTrace;
            return true;
        }
        if (!Arrays.equals(this.lastStackTrace, newStackTrace)) {
            this.lastStackTrace = newStackTrace;
            return false;
        }
        return true;
    }

    private void trace(String format, Object ... args) {
        if (DEBUG) {
            TTY.println(this + ": " + String.format(format, args));
        }
    }

    private static long ms(double seconds) {
        return (long)seconds * 1000L;
    }

    private static double secs(long ms) {
        return (double)ms / 1000.0;
    }

    public String toString() {
        return "WatchDog[" + this.compilerThread.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.trace("Started%n", this);
            while (true) {
                ResolvedJavaMethod currentlyCompiling;
                if ((currentlyCompiling = this.currentMethod) == null) {
                    this.reset();
                } else {
                    switch (this.state) {
                        case SLEEPING: {
                            this.lastWatched = currentlyCompiling;
                            this.elapsed = 0L;
                            this.tick(WatchDogState.WATCHING_WITHOUT_STACK_INSPECTION);
                            break;
                        }
                        case WATCHING_WITHOUT_STACK_INSPECTION: {
                            if (currentlyCompiling.equals(this.lastWatched)) {
                                if (this.elapsed >= this.startDelayMilliseconds) {
                                    this.tick(WatchDogState.WATCHING_WITH_STACK_INSPECTION);
                                    this.trace("changes mode to watching with stack traces", new Object[0]);
                                } else {
                                    this.trace("watching without stack traces [%.2f seconds]", CompilationWatchDog.secs(this.elapsed));
                                }
                                this.elapsed += 1000L;
                                break;
                            }
                            this.reset();
                            break;
                        }
                        case WATCHING_WITH_STACK_INSPECTION: {
                            if (currentlyCompiling.equals(this.lastWatched)) {
                                if (this.elapsed >= this.startDelayMilliseconds + (long)this.traceIntervals * this.stackTraceIntervalMilliseconds) {
                                    Class<CompilationWatchDog> clazz;
                                    this.trace("took a stack trace", new Object[0]);
                                    boolean newStackTrace = this.recordStackTrace(this.compilerThread.getStackTrace());
                                    if (!newStackTrace) {
                                        this.trace("%d identical stack traces in a row", this.numberOfIdenticalStackTraces);
                                        this.numberOfIdenticalStackTraces = 0;
                                    }
                                    ++this.numberOfIdenticalStackTraces;
                                    if (this.numberOfIdenticalStackTraces > this.nonFatalIdenticalCompilationSnapshots) {
                                        clazz = CompilationWatchDog.class;
                                        // MONITORENTER : org.graalvm.compiler.hotspot.CompilationWatchDog.class
                                        TTY.printf("======================= WATCH DOG THREAD =======================%n%s took %d identical stack traces, which indicates a stuck compilation (id=%d) of %s%n%sExiting VM%n", this, this.numberOfIdenticalStackTraces, this.currentId, HotSpotGraalCompiler.fmt(this.currentMethod), HotSpotGraalCompiler.fmt(this.lastStackTrace));
                                        HotSpotGraalServices.exit(-1);
                                        // MONITOREXIT : clazz
                                    } else if (newStackTrace) {
                                        clazz = CompilationWatchDog.class;
                                        // MONITORENTER : org.graalvm.compiler.hotspot.CompilationWatchDog.class
                                        TTY.printf("======================= WATCH DOG THREAD =======================%n%s detected long running compilation (id=%d) of %s [%.2f seconds]%n%s", this, this.currentId, HotSpotGraalCompiler.fmt(this.currentMethod), CompilationWatchDog.secs(this.elapsed), HotSpotGraalCompiler.fmt(this.lastStackTrace));
                                        // MONITOREXIT : clazz
                                    }
                                    ++this.traceIntervals;
                                } else {
                                    this.trace("watching with stack traces [%.2f seconds]", CompilationWatchDog.secs(this.elapsed));
                                }
                                this.elapsed += 1000L;
                                break;
                            }
                            this.reset();
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (VirtualMachineError currentlyCompiling) {
            return;
        }
        catch (Throwable t) {
            throw new InternalError(String.format("%s encountered an exception%n%s%n", this, HotSpotGraalCompiler.fmt(t)), t);
        }
    }

    static CompilationWatchDog watch(ResolvedJavaMethod method, int id, OptionValues options) {
        long startDelayMilliseconds = CompilationWatchDog.ms(Options.CompilationWatchDogStartDelay.getValue(options));
        if ((double)startDelayMilliseconds > 0.0) {
            CompilationWatchDog watchDog = WATCH_DOGS.get();
            if (watchDog == null) {
                Thread currentThread = Thread.currentThread();
                long stackTraceIntervalMilliseconds = CompilationWatchDog.ms(Options.CompilationWatchDogStackTraceInterval.getValue(options));
                int nonFatalIdenticalCompilationSnapshots = Options.NonFatalIdenticalCompilationSnapshots.getValue(options);
                watchDog = new CompilationWatchDog(currentThread, startDelayMilliseconds, stackTraceIntervalMilliseconds, nonFatalIdenticalCompilationSnapshots);
                WATCH_DOGS.set(watchDog);
                GraalServiceThread thread = new GraalServiceThread(watchDog);
                thread.setName(thread.getId() + " " + watchDog.toString());
                thread.setPriority(10);
                thread.setDaemon(true);
                thread.start();
            }
            watchDog.startCompilation(method, id);
            return watchDog;
        }
        return null;
    }

    @Override
    public void close() {
        this.stopCompilation();
    }

    private static enum WatchDogState {
        SLEEPING,
        WATCHING_WITHOUT_STACK_INSPECTION,
        WATCHING_WITH_STACK_INSPECTION;

    }

    public static class Options {
        @Option(help={"Delay in seconds before watch dog monitoring a compilation (0 disables monitoring)."}, type=OptionType.Debug)
        public static final OptionKey<Double> CompilationWatchDogStartDelay = new OptionKey<Double>(0.0);
        @Option(help={"Interval in seconds between a watch dog reporting stack traces for long running compilations."}, type=OptionType.Debug)
        public static final OptionKey<Double> CompilationWatchDogStackTraceInterval = new OptionKey<Double>(60.0);
        @Option(help={"Number of contiguous identical compiler thread stack traces allowed before the VM exits on the basis of a stuck compilation."}, type=OptionType.Debug)
        public static final OptionKey<Integer> NonFatalIdenticalCompilationSnapshots = new OptionKey<Integer>(20);
    }
}

