/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;

public class GraalHotSpotVMConfig
extends GraalHotSpotVMConfigBase {
    private final CompressEncoding oopEncoding;
    private final CompressEncoding klassEncoding;
    private final String markWord;
    public final boolean cAssertions;
    public final int codeEntryAlignment;
    public final boolean enableContended;
    public final boolean restrictContended;
    public final int contendedPaddingWidth;
    public final int fieldsAllocationStyle;
    public final boolean compactFields;
    public final boolean verifyOops;
    public final boolean ciTime;
    public final boolean ciTimeEach;
    public final boolean dontCompileHugeMethods;
    public final int hugeMethodLimit;
    public final boolean printInlining;
    public final boolean inline;
    public final boolean inlineNotify;
    public final boolean useFastLocking;
    public final boolean forceUnreachable;
    public final int codeSegmentSize;
    public final boolean foldStableValues;
    public final int maxVectorSize;
    public final boolean verifyBeforeGC;
    public final boolean verifyAfterGC;
    public final boolean useTLAB;
    public final boolean useBiasedLocking;
    public final boolean usePopCountInstruction;
    public final boolean useAESIntrinsics;
    public final boolean useAESCTRIntrinsics;
    public final boolean useCRC32Intrinsics;
    public final boolean useCRC32CIntrinsics;
    public final boolean threadLocalHandshakes;
    private final boolean useMultiplyToLenIntrinsic;
    private final boolean useSHA1Intrinsics;
    private final boolean useSHA256Intrinsics;
    private final boolean useSHA512Intrinsics;
    private final boolean useGHASHIntrinsics;
    private final boolean useBase64Intrinsics;
    private final boolean useMontgomeryMultiplyIntrinsic;
    private final boolean useMontgomerySquareIntrinsic;
    private final boolean useMulAddIntrinsic;
    private final boolean useSquareToLenIntrinsic;
    public final boolean useVectorizedMismatchIntrinsic;
    public final boolean useFMAIntrinsics;
    public final boolean useG1GC;
    public final boolean useCMSGC;
    public final int allocatePrefetchStyle;
    public final int allocatePrefetchInstr;
    public final int allocatePrefetchLines;
    public final int allocateInstancePrefetchLines;
    public final int allocatePrefetchStepSize;
    public final int allocatePrefetchDistance;
    private final long universeCollectedHeap;
    private final int collectedHeapTotalCollectionsOffset;
    public final boolean useDeferredInitBarriers;
    public final boolean useCompressedOops;
    public final boolean useCompressedClassPointers;
    public final long narrowOopBase;
    public final int narrowOopShift;
    public final int objectAlignment;
    public final int narrowKlassSize;
    public final long narrowKlassBase;
    public final int narrowKlassShift;
    public final int logKlassAlignment;
    public final int stackShadowPages;
    public final int stackReservedPages;
    public final boolean useStackBanging;
    public final int stackBias;
    public final int vmPageSize;
    public final int markOffset;
    public final int hubOffset;
    public final int prototypeMarkWordOffset;
    public final int subklassOffset;
    public final int nextSiblingOffset;
    public final int superCheckOffsetOffset;
    public final int secondarySuperCacheOffset;
    public final int secondarySupersOffset;
    public final boolean classMirrorIsHandle;
    public final int classMirrorOffset;
    public final int klassSuperKlassOffset;
    public final int klassModifierFlagsOffset;
    public final int klassAccessFlagsOffset;
    public final int klassLayoutHelperOffset;
    public final int klassLayoutHelperNeutralValue;
    public final int layoutHelperLog2ElementSizeShift;
    public final int layoutHelperLog2ElementSizeMask;
    public final int layoutHelperElementTypeShift;
    public final int layoutHelperElementTypeMask;
    public final int layoutHelperHeaderSizeShift;
    public final int layoutHelperHeaderSizeMask;
    public final int layoutHelperArrayTagShift;
    public final int layoutHelperArrayTagTypeValue;
    public final int layoutHelperArrayTagObjectValue;
    public final int vtableEntrySize;
    public final int vtableEntryMethodOffset;
    public final int instanceKlassInitStateOffset;
    public final int instanceKlassInitThreadOffset;
    public final int instanceKlassConstantsOffset;
    public final int instanceKlassFieldsOffset;
    public final int klassVtableStartOffset;
    public final int klassVtableLengthOffset;
    public final int instanceKlassStateLinked;
    public final int instanceKlassStateBeingInitialized;
    public final int instanceKlassStateFullyInitialized;
    public final int arrayOopDescSize;
    public final int arrayU1LengthOffset;
    public final int arrayU1DataOffset;
    public final int arrayU2DataOffset;
    public final int metaspaceArrayLengthOffset;
    public final int metaspaceArrayBaseOffset;
    public final int arrayClassElementOffset;
    public final int fieldInfoAccessFlagsOffset;
    public final int fieldInfoNameIndexOffset;
    public final int fieldInfoSignatureIndexOffset;
    public final int fieldInfoInitvalIndexOffset;
    public final int fieldInfoLowPackedOffset;
    public final int fieldInfoHighPackedOffset;
    public final int fieldInfoFieldSlots;
    public final int fieldInfoTagSize;
    public final int jvmAccMonitorMatch;
    public final int jvmAccHasMonitorBytecodes;
    public final int jvmAccHasFinalizer;
    public final int jvmAccFieldInternal;
    public final int jvmAccFieldStable;
    public final int jvmAccFieldHasGenericSignature;
    public final int jvmAccWrittenFlags;
    public final int jvmAccSynthetic;
    public final int jvmciCompileStateCanPostOnExceptionsOffset;
    public final int jvmciCompileStateCanPopFrameOffset;
    public final int jvmciCompileStateCanAccessLocalVariablesOffset;
    public final int threadTlabOffset;
    public final int javaThreadAnchorOffset;
    public final int javaThreadShouldPostOnExceptionsFlagOffset;
    public final int threadObjectOffset;
    public final int osThreadOffset;
    public final int threadIsMethodHandleReturnOffset;
    public final int threadObjectResultOffset;
    public final int jvmciCountersThreadOffset;
    public final int doingUnsafeAccessOffset;
    public final int javaThreadReservedStackActivationOffset;
    public final int jniEnvironmentOffset;
    public static final long INVALID_RTLD_DEFAULT_HANDLE = -559023410L;
    public final long dllLoad;
    public final long dllLookup;
    public final long rtldDefault;
    public final int threadExceptionOopOffset;
    public final int threadExceptionPcOffset;
    public final int pendingExceptionOffset;
    public final int pendingDeoptimizationOffset;
    public final int pendingTransferToInterpreterOffset;
    private final int javaFrameAnchorLastJavaSpOffset;
    private final int javaFrameAnchorLastJavaPcOffset;
    public final int pendingFailedSpeculationOffset;
    public final int runtimeCallStackSize;
    public final int frameInterpreterFrameSenderSpOffset;
    public final int frameInterpreterFrameLastSpOffset;
    public final int osThreadInterruptedOffset;
    public final long markWordHashShift;
    public final int biasedLockMaskInPlace;
    public final int ageMaskInPlace;
    public final int epochMaskInPlace;
    public final long markWordHashMask;
    public final long markWordHashMaskInPlace;
    public final int unlockedMask;
    public final int monitorMask;
    public final int biasedLockPattern;
    public final int objectMonitorOwner;
    public final int objectMonitorRecursions;
    public final int objectMonitorCxq;
    public final int objectMonitorEntryList;
    public final int objectMonitorSucc;
    public final int markWordNoHashInPlace;
    public final int markWordNoLockInPlace;
    public final int identityHashCodeShift;
    public final int uninitializedIdentityHashCodeValue;
    public final int methodAccessFlagsOffset;
    public final int methodConstMethodOffset;
    public final int methodIntrinsicIdOffset;
    public final int methodFlagsOffset;
    public final int methodVtableIndexOffset;
    public final int methodCountersOffset;
    public final int methodDataOffset;
    public final int methodCompiledEntryOffset;
    public final int methodCodeOffset;
    public final int methodFlagsCallerSensitive;
    public final int methodFlagsForceInline;
    public final int methodFlagsDontInline;
    public final int methodFlagsHidden;
    public final int nonvirtualVtableIndex;
    public final int invalidVtableIndex;
    public final int invocationCounterOffset;
    public final int backedgeCounterOffset;
    public final int invocationCounterIncrement;
    public final int invocationCounterShift;
    public final int nmethodEntryOffset;
    public final int compilationLevelFullOptimization;
    public final int constantPoolSize;
    public final int constantPoolLengthOffset;
    public final int heapWordSize;
    public final long nonOopBits;
    public final long verifyOopCounterAddress;
    public final long verifyOopMask;
    public final long verifyOopBits;
    public final int logOfHRGrainBytes;
    public final long cardtableStartAddress;
    public final int cardtableShift;
    public final int maxOopMapStackOffset;
    public final long safepointPollingAddress;
    public final byte dirtyCardValue;
    public final byte g1YoungCardValue;
    public final int g1SATBQueueMarkingOffset;
    public final int g1SATBQueueIndexOffset;
    public final int g1SATBQueueBufferOffset;
    public final int g1CardQueueIndexOffset;
    public final int g1CardQueueBufferOffset;
    public final int klassOffset;
    public final int arrayKlassOffset;
    public final int basicLockSize;
    public final int basicLockDisplacedHeaderOffset;
    public final int threadPollingPageOffset;
    public final int threadAllocatedBytesOffset;
    public final int tlabRefillWasteIncrement;
    private final int threadLocalAllocBufferStartOffset;
    private final int threadLocalAllocBufferEndOffset;
    private final int threadLocalAllocBufferTopOffset;
    private final int threadLocalAllocBufferPfTopOffset;
    private final int threadLocalAllocBufferSlowAllocationsOffset;
    private final int threadLocalAllocBufferFastRefillWasteOffset;
    private final int threadLocalAllocBufferNumberOfRefillsOffset;
    private final int threadLocalAllocBufferRefillWasteLimitOffset;
    private final int threadLocalAllocBufferDesiredSizeOffset;
    public final int tlabAlignmentReserve;
    public final boolean tlabStats;
    public final int psrInfoDczidValue;
    public final boolean inlineContiguousAllocationSupported;
    public final long heapEndAddress;
    public final long heapTopAddress;
    public final boolean cmsIncrementalMode;
    public final long inlineCacheMissStub;
    public final long handleWrongMethodStub;
    public final long handleDeoptStub;
    public final long uncommonTrapStub;
    public final long codeCacheLowBound;
    public final long codeCacheHighBound;
    public final long aescryptEncryptBlockStub;
    public final long aescryptDecryptBlockStub;
    public final long cipherBlockChainingEncryptAESCryptStub;
    public final long cipherBlockChainingDecryptAESCryptStub;
    public final long updateBytesCRC32Stub;
    public final long crcTableAddress;
    public final long sha1ImplCompress;
    public final long sha1ImplCompressMultiBlock;
    public final long sha256ImplCompress;
    public final long sha256ImplCompressMultiBlock;
    public final long sha512ImplCompress;
    public final long sha512ImplCompressMultiBlock;
    public final long multiplyToLen;
    public final long counterModeAESCrypt;
    public final long ghashProcessBlocks;
    public final long base64EncodeBlock;
    public final long crc32cTableTddr;
    public final long updateBytesCRC32C;
    public final long updateBytesAdler32;
    public final long squareToLen;
    public final long mulAdd;
    public final long montgomeryMultiply;
    public final long montgomerySquare;
    public final long vectorizedMismatch;
    public final long throwDelayedStackOverflowErrorEntry;
    public final long jbyteArraycopy;
    public final long jshortArraycopy;
    public final long jintArraycopy;
    public final long jlongArraycopy;
    public final long oopArraycopy;
    public final long oopArraycopyUninit;
    public final long jbyteDisjointArraycopy;
    public final long jshortDisjointArraycopy;
    public final long jintDisjointArraycopy;
    public final long jlongDisjointArraycopy;
    public final long oopDisjointArraycopy;
    public final long oopDisjointArraycopyUninit;
    public final long jbyteAlignedArraycopy;
    public final long jshortAlignedArraycopy;
    public final long jintAlignedArraycopy;
    public final long jlongAlignedArraycopy;
    public final long oopAlignedArraycopy;
    public final long oopAlignedArraycopyUninit;
    public final long jbyteAlignedDisjointArraycopy;
    public final long jshortAlignedDisjointArraycopy;
    public final long jintAlignedDisjointArraycopy;
    public final long jlongAlignedDisjointArraycopy;
    public final long oopAlignedDisjointArraycopy;
    public final long oopAlignedDisjointArraycopyUninit;
    public final long checkcastArraycopy;
    public final long checkcastArraycopyUninit;
    public final long unsafeArraycopy;
    public final long genericArraycopy;
    public final long newInstanceAddress;
    public final long newArrayAddress;
    public final long newMultiArrayAddress;
    public final long dynamicNewInstanceAddress;
    public final long newInstanceOrNullAddress;
    public final long newArrayOrNullAddress;
    public final long newMultiArrayOrNullAddress;
    public final long dynamicNewInstanceOrNullAddress;
    public final long threadIsInterruptedAddress;
    public final long vmMessageAddress;
    public final long identityHashCodeAddress;
    public final long exceptionHandlerForPcAddress;
    public final long monitorenterAddress;
    public final long monitorexitAddress;
    public final long notifyAddress;
    public final long notifyAllAddress;
    public final long throwAndPostJvmtiExceptionAddress;
    public final long throwKlassExternalNameExceptionAddress;
    public final long throwClassCastExceptionAddress;
    public final long logPrimitiveAddress;
    public final long logObjectAddress;
    public final long logPrintfAddress;
    public final long vmErrorAddress;
    public final long loadAndClearExceptionAddress;
    public final long writeBarrierPreAddress;
    public final long writeBarrierPostAddress;
    public final long validateObject;
    public final long testDeoptimizeCallInt;
    public final long registerFinalizerAddress;
    public final long exceptionHandlerForReturnAddressAddress;
    public final long osrMigrationEndAddress;
    public final long enableStackReservedZoneAddress;
    public final long javaTimeMillisAddress;
    public final long javaTimeNanosAddress;
    public final long arithmeticSinAddress;
    public final long arithmeticCosAddress;
    public final long arithmeticTanAddress;
    public final long arithmeticExpAddress;
    public final long arithmeticLogAddress;
    public final long arithmeticLog10Address;
    public final long arithmeticPowAddress;
    public final long fremAddress;
    public final long dremAddress;
    public final int jvmciCountersSize;
    public final long deoptimizationFetchUnrollInfo;
    public final long deoptimizationUncommonTrap;
    public final long deoptimizationUnpackFrames;
    public final int deoptimizationUnpackDeopt;
    public final int deoptimizationUnpackException;
    public final int deoptimizationUnpackUncommonTrap;
    public final int deoptimizationUnpackReexecute;
    public final int deoptimizationUnrollBlockSizeOfDeoptimizedFrameOffset;
    public final int deoptimizationUnrollBlockCallerAdjustmentOffset;
    public final int deoptimizationUnrollBlockNumberOfFramesOffset;
    public final int deoptimizationUnrollBlockTotalFrameSizesOffset;
    public final int deoptimizationUnrollBlockUnpackKindOffset;
    public final int deoptimizationUnrollBlockFrameSizesOffset;
    public final int deoptimizationUnrollBlockFramePcsOffset;
    public final int deoptimizationUnrollBlockInitialInfoOffset;
    public final int MARKID_VERIFIED_ENTRY;
    public final int MARKID_UNVERIFIED_ENTRY;
    public final int MARKID_OSR_ENTRY;
    public final int MARKID_EXCEPTION_HANDLER_ENTRY;
    public final int MARKID_DEOPT_HANDLER_ENTRY;
    public final int MARKID_INVOKEINTERFACE;
    public final int MARKID_INVOKEVIRTUAL;
    public final int MARKID_INVOKESTATIC;
    public final int MARKID_INVOKESPECIAL;
    public final int MARKID_INLINE_INVOKE;
    public final int MARKID_POLL_NEAR;
    public final int MARKID_POLL_RETURN_NEAR;
    public final int MARKID_POLL_FAR;
    public final int MARKID_POLL_RETURN_FAR;
    public final int MARKID_CARD_TABLE_SHIFT;
    public final int MARKID_CARD_TABLE_ADDRESS;
    public final int MARKID_INVOKE_INVALID;
    public final int MARKID_HEAP_TOP_ADDRESS;
    public final int MARKID_HEAP_END_ADDRESS;
    public final int MARKID_NARROW_KLASS_BASE_ADDRESS;
    public final int MARKID_NARROW_OOP_BASE_ADDRESS;
    public final int MARKID_CRC_TABLE_ADDRESS;
    public final int MARKID_LOG_OF_HEAP_REGION_GRAIN_BYTES;
    public final int MARKID_INLINE_CONTIGUOUS_ALLOCATION_SUPPORTED;

    GraalHotSpotVMConfig(HotSpotVMConfigStore store) {
        super(store);
        this.markWord = this.versioned.markWordFieldType;
        this.cAssertions = (Boolean)this.getConstant("ASSERT", Boolean.class);
        this.codeEntryAlignment = (Integer)this.getFlag("CodeEntryAlignment", Integer.class);
        this.enableContended = (Boolean)this.getFlag("EnableContended", Boolean.class);
        this.restrictContended = (Boolean)this.getFlag("RestrictContended", Boolean.class);
        this.contendedPaddingWidth = (Integer)this.getFlag("ContendedPaddingWidth", Integer.class);
        this.fieldsAllocationStyle = (Integer)this.getFlag("FieldsAllocationStyle", Integer.class);
        this.compactFields = (Boolean)this.getFlag("CompactFields", Boolean.class);
        this.verifyOops = (Boolean)this.getFlag("VerifyOops", Boolean.class);
        this.ciTime = (Boolean)this.getFlag("CITime", Boolean.class);
        this.ciTimeEach = (Boolean)this.getFlag("CITimeEach", Boolean.class);
        this.dontCompileHugeMethods = (Boolean)this.getFlag("DontCompileHugeMethods", Boolean.class);
        this.hugeMethodLimit = (Integer)this.getFlag("HugeMethodLimit", Integer.class);
        this.printInlining = (Boolean)this.getFlag("PrintInlining", Boolean.class);
        this.inline = (Boolean)this.getFlag("Inline", Boolean.class);
        this.inlineNotify = this.versioned.inlineNotify;
        this.useFastLocking = (Boolean)this.getFlag("JVMCIUseFastLocking", Boolean.class);
        this.forceUnreachable = (Boolean)this.getFlag("ForceUnreachable", Boolean.class);
        this.codeSegmentSize = (Integer)this.getFlag("CodeCacheSegmentSize", Integer.class);
        this.foldStableValues = (Boolean)this.getFlag("FoldStableValues", Boolean.class);
        this.maxVectorSize = (Integer)this.getFlag("MaxVectorSize", Integer.class);
        this.verifyBeforeGC = (Boolean)this.getFlag("VerifyBeforeGC", Boolean.class);
        this.verifyAfterGC = (Boolean)this.getFlag("VerifyAfterGC", Boolean.class);
        this.useTLAB = (Boolean)this.getFlag("UseTLAB", Boolean.class);
        this.useBiasedLocking = (Boolean)this.getFlag("UseBiasedLocking", Boolean.class);
        this.usePopCountInstruction = (Boolean)this.getFlag("UsePopCountInstruction", Boolean.class);
        this.useAESIntrinsics = (Boolean)this.getFlag("UseAESIntrinsics", Boolean.class);
        this.useAESCTRIntrinsics = (Boolean)this.getFlag("UseAESCTRIntrinsics", Boolean.class, false);
        this.useCRC32Intrinsics = (Boolean)this.getFlag("UseCRC32Intrinsics", Boolean.class);
        this.useCRC32CIntrinsics = this.versioned.useCRC32CIntrinsics;
        this.threadLocalHandshakes = (Boolean)this.getFlag("ThreadLocalHandshakes", Boolean.class, false);
        this.useMultiplyToLenIntrinsic = (Boolean)this.getFlag("UseMultiplyToLenIntrinsic", Boolean.class);
        this.useSHA1Intrinsics = (Boolean)this.getFlag("UseSHA1Intrinsics", Boolean.class);
        this.useSHA256Intrinsics = (Boolean)this.getFlag("UseSHA256Intrinsics", Boolean.class);
        this.useSHA512Intrinsics = (Boolean)this.getFlag("UseSHA512Intrinsics", Boolean.class);
        this.useGHASHIntrinsics = (Boolean)this.getFlag("UseGHASHIntrinsics", Boolean.class, false);
        this.useBase64Intrinsics = (Boolean)this.getFlag("UseBASE64Intrinsics", Boolean.class, false);
        this.useMontgomeryMultiplyIntrinsic = (Boolean)this.getFlag("UseMontgomeryMultiplyIntrinsic", Boolean.class, false);
        this.useMontgomerySquareIntrinsic = (Boolean)this.getFlag("UseMontgomerySquareIntrinsic", Boolean.class, false);
        this.useMulAddIntrinsic = (Boolean)this.getFlag("UseMulAddIntrinsic", Boolean.class, false);
        this.useSquareToLenIntrinsic = (Boolean)this.getFlag("UseSquareToLenIntrinsic", Boolean.class, false);
        this.useVectorizedMismatchIntrinsic = (Boolean)this.getFlag("UseVectorizedMismatchIntrinsic", Boolean.class, false);
        this.useFMAIntrinsics = (Boolean)this.getFlag("UseFMA", Boolean.class, false);
        this.useG1GC = (Boolean)this.getFlag("UseG1GC", Boolean.class);
        this.useCMSGC = (Boolean)this.getFlag("UseConcMarkSweepGC", Boolean.class);
        this.allocatePrefetchStyle = (Integer)this.getFlag("AllocatePrefetchStyle", Integer.class);
        this.allocatePrefetchInstr = (Integer)this.getFlag("AllocatePrefetchInstr", Integer.class);
        this.allocatePrefetchLines = (Integer)this.getFlag("AllocatePrefetchLines", Integer.class);
        this.allocateInstancePrefetchLines = (Integer)this.getFlag("AllocateInstancePrefetchLines", Integer.class);
        this.allocatePrefetchStepSize = (Integer)this.getFlag("AllocatePrefetchStepSize", Integer.class);
        this.allocatePrefetchDistance = (Integer)this.getFlag("AllocatePrefetchDistance", Integer.class);
        this.universeCollectedHeap = (Long)this.getFieldValue("CompilerToVM::Data::Universe_collectedHeap", Long.class, "CollectedHeap*");
        this.collectedHeapTotalCollectionsOffset = (Integer)this.getFieldOffset("CollectedHeap::_total_collections", Integer.class, "unsigned int");
        this.useDeferredInitBarriers = (Boolean)this.getFlag("ReduceInitialCardMarks", Boolean.class);
        this.useCompressedOops = (Boolean)this.getFlag("UseCompressedOops", Boolean.class);
        this.useCompressedClassPointers = (Boolean)this.getFlag("UseCompressedClassPointers", Boolean.class);
        this.narrowOopBase = (Long)this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_base", Long.class, "address");
        this.narrowOopShift = (Integer)this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_shift", Integer.class, "int");
        this.objectAlignment = (Integer)this.getFlag("ObjectAlignmentInBytes", Integer.class);
        this.narrowKlassSize = (Integer)this.getFieldValue("CompilerToVM::Data::sizeof_narrowKlass", Integer.class, "int");
        this.narrowKlassBase = (Long)this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_base", Long.class, "address");
        this.narrowKlassShift = (Integer)this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_shift", Integer.class, "int");
        this.logKlassAlignment = (Integer)this.getConstant("LogKlassAlignmentInBytes", Integer.class);
        this.stackShadowPages = (Integer)this.getFlag("StackShadowPages", Integer.class);
        this.stackReservedPages = (Integer)this.getFlag("StackReservedPages", Integer.class, 0);
        this.useStackBanging = (Boolean)this.getFlag("UseStackBanging", Boolean.class);
        this.stackBias = (Integer)this.getConstant("STACK_BIAS", Integer.class);
        this.vmPageSize = (Integer)this.getFieldValue("CompilerToVM::Data::vm_page_size", Integer.class, "int");
        this.markOffset = (Integer)this.getFieldOffset("oopDesc::_mark", Integer.class, this.markWord);
        this.hubOffset = (Integer)this.getFieldOffset("oopDesc::_metadata._klass", Integer.class, "Klass*");
        this.prototypeMarkWordOffset = (Integer)this.getFieldOffset("Klass::_prototype_header", Integer.class, this.markWord);
        this.subklassOffset = (Integer)this.getFieldOffset("Klass::_subklass", Integer.class, "Klass*");
        this.nextSiblingOffset = (Integer)this.getFieldOffset("Klass::_next_sibling", Integer.class, "Klass*");
        this.superCheckOffsetOffset = (Integer)this.getFieldOffset("Klass::_super_check_offset", Integer.class, "juint");
        this.secondarySuperCacheOffset = (Integer)this.getFieldOffset("Klass::_secondary_super_cache", Integer.class, "Klass*");
        this.secondarySupersOffset = (Integer)this.getFieldOffset("Klass::_secondary_supers", Integer.class, "Array<Klass*>*");
        this.classMirrorIsHandle = this.versioned.classMirrorIsHandle;
        this.classMirrorOffset = this.versioned.classMirrorOffset;
        this.klassSuperKlassOffset = (Integer)this.getFieldOffset("Klass::_super", Integer.class, "Klass*");
        this.klassModifierFlagsOffset = (Integer)this.getFieldOffset("Klass::_modifier_flags", Integer.class, "jint");
        this.klassAccessFlagsOffset = (Integer)this.getFieldOffset("Klass::_access_flags", Integer.class, "AccessFlags");
        this.klassLayoutHelperOffset = (Integer)this.getFieldOffset("Klass::_layout_helper", Integer.class, "jint");
        this.klassLayoutHelperNeutralValue = (Integer)this.getConstant("Klass::_lh_neutral_value", Integer.class);
        this.layoutHelperLog2ElementSizeShift = (Integer)this.getConstant("Klass::_lh_log2_element_size_shift", Integer.class);
        this.layoutHelperLog2ElementSizeMask = (Integer)this.getConstant("Klass::_lh_log2_element_size_mask", Integer.class);
        this.layoutHelperElementTypeShift = (Integer)this.getConstant("Klass::_lh_element_type_shift", Integer.class);
        this.layoutHelperElementTypeMask = (Integer)this.getConstant("Klass::_lh_element_type_mask", Integer.class);
        this.layoutHelperHeaderSizeShift = (Integer)this.getConstant("Klass::_lh_header_size_shift", Integer.class);
        this.layoutHelperHeaderSizeMask = (Integer)this.getConstant("Klass::_lh_header_size_mask", Integer.class);
        this.layoutHelperArrayTagShift = (Integer)this.getConstant("Klass::_lh_array_tag_shift", Integer.class);
        this.layoutHelperArrayTagTypeValue = (Integer)this.getConstant("Klass::_lh_array_tag_type_value", Integer.class);
        this.layoutHelperArrayTagObjectValue = (Integer)this.getConstant("Klass::_lh_array_tag_obj_value", Integer.class);
        this.vtableEntrySize = (Integer)this.getFieldValue("CompilerToVM::Data::sizeof_vtableEntry", Integer.class, "int");
        this.vtableEntryMethodOffset = (Integer)this.getFieldOffset("vtableEntry::_method", Integer.class, "Method*");
        this.instanceKlassInitStateOffset = (Integer)this.getFieldOffset("InstanceKlass::_init_state", Integer.class, "u1");
        this.instanceKlassInitThreadOffset = (Integer)this.getFieldOffset("InstanceKlass::_init_thread", Integer.class, "Thread*", -1);
        this.instanceKlassConstantsOffset = (Integer)this.getFieldOffset("InstanceKlass::_constants", Integer.class, "ConstantPool*");
        this.instanceKlassFieldsOffset = (Integer)this.getFieldOffset("InstanceKlass::_fields", Integer.class, "Array<u2>*");
        this.klassVtableStartOffset = (Integer)this.getFieldValue("CompilerToVM::Data::Klass_vtable_start_offset", Integer.class, "int");
        this.klassVtableLengthOffset = (Integer)this.getFieldValue("CompilerToVM::Data::Klass_vtable_length_offset", Integer.class, "int");
        this.instanceKlassStateLinked = (Integer)this.getConstant("InstanceKlass::linked", Integer.class);
        this.instanceKlassStateBeingInitialized = (Integer)this.getConstant("InstanceKlass::being_initialized", Integer.class, -1);
        this.instanceKlassStateFullyInitialized = (Integer)this.getConstant("InstanceKlass::fully_initialized", Integer.class);
        this.arrayOopDescSize = (Integer)this.getFieldValue("CompilerToVM::Data::sizeof_arrayOopDesc", Integer.class, "int");
        this.arrayU1LengthOffset = (Integer)this.getFieldOffset("Array<int>::_length", Integer.class, "int");
        this.arrayU1DataOffset = (Integer)this.getFieldOffset("Array<u1>::_data", Integer.class);
        this.arrayU2DataOffset = (Integer)this.getFieldOffset("Array<u2>::_data", Integer.class);
        this.metaspaceArrayLengthOffset = (Integer)this.getFieldOffset("Array<Klass*>::_length", Integer.class, "int");
        this.metaspaceArrayBaseOffset = (Integer)this.getFieldOffset("Array<Klass*>::_data[0]", Integer.class, "Klass*");
        this.arrayClassElementOffset = (Integer)this.getFieldOffset("ObjArrayKlass::_element_klass", Integer.class, "Klass*");
        this.fieldInfoAccessFlagsOffset = (Integer)this.getConstant("FieldInfo::access_flags_offset", Integer.class);
        this.fieldInfoNameIndexOffset = (Integer)this.getConstant("FieldInfo::name_index_offset", Integer.class);
        this.fieldInfoSignatureIndexOffset = (Integer)this.getConstant("FieldInfo::signature_index_offset", Integer.class);
        this.fieldInfoInitvalIndexOffset = (Integer)this.getConstant("FieldInfo::initval_index_offset", Integer.class);
        this.fieldInfoLowPackedOffset = (Integer)this.getConstant("FieldInfo::low_packed_offset", Integer.class);
        this.fieldInfoHighPackedOffset = (Integer)this.getConstant("FieldInfo::high_packed_offset", Integer.class);
        this.fieldInfoFieldSlots = (Integer)this.getConstant("FieldInfo::field_slots", Integer.class);
        this.fieldInfoTagSize = (Integer)this.getConstant("FIELDINFO_TAG_SIZE", Integer.class);
        this.jvmAccMonitorMatch = (Integer)this.getConstant("JVM_ACC_MONITOR_MATCH", Integer.class);
        this.jvmAccHasMonitorBytecodes = (Integer)this.getConstant("JVM_ACC_HAS_MONITOR_BYTECODES", Integer.class);
        this.jvmAccHasFinalizer = (Integer)this.getConstant("JVM_ACC_HAS_FINALIZER", Integer.class);
        this.jvmAccFieldInternal = (Integer)this.getConstant("JVM_ACC_FIELD_INTERNAL", Integer.class);
        this.jvmAccFieldStable = (Integer)this.getConstant("JVM_ACC_FIELD_STABLE", Integer.class);
        this.jvmAccFieldHasGenericSignature = (Integer)this.getConstant("JVM_ACC_FIELD_HAS_GENERIC_SIGNATURE", Integer.class);
        this.jvmAccWrittenFlags = (Integer)this.getConstant("JVM_ACC_WRITTEN_FLAGS", Integer.class);
        this.jvmAccSynthetic = (Integer)this.getConstant("JVM_ACC_SYNTHETIC", Integer.class);
        this.jvmciCompileStateCanPostOnExceptionsOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_post_on_exceptions");
        this.jvmciCompileStateCanPopFrameOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_pop_frame");
        this.jvmciCompileStateCanAccessLocalVariablesOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_access_local_variables");
        this.threadTlabOffset = (Integer)this.getFieldOffset("Thread::_tlab", Integer.class, "ThreadLocalAllocBuffer");
        this.javaThreadAnchorOffset = (Integer)this.getFieldOffset("JavaThread::_anchor", Integer.class, "JavaFrameAnchor");
        this.javaThreadShouldPostOnExceptionsFlagOffset = (Integer)this.getFieldOffset("JavaThread::_should_post_on_exceptions_flag", Integer.class, "int", Integer.MIN_VALUE);
        this.threadObjectOffset = (Integer)this.getFieldOffset("JavaThread::_threadObj", Integer.class, "oop");
        this.osThreadOffset = (Integer)this.getFieldOffset("JavaThread::_osthread", Integer.class, "OSThread*");
        this.threadIsMethodHandleReturnOffset = (Integer)this.getFieldOffset("JavaThread::_is_method_handle_return", Integer.class, "int");
        this.threadObjectResultOffset = (Integer)this.getFieldOffset("JavaThread::_vm_result", Integer.class, "oop");
        this.jvmciCountersThreadOffset = (Integer)this.getFieldOffset("JavaThread::_jvmci_counters", Integer.class, "jlong*");
        this.doingUnsafeAccessOffset = (Integer)this.getFieldOffset("JavaThread::_doing_unsafe_access", Integer.class, "bool", Integer.MAX_VALUE);
        this.javaThreadReservedStackActivationOffset = this.versioned.javaThreadReservedStackActivationOffset;
        this.jniEnvironmentOffset = (Integer)this.getFieldOffset("JavaThread::_jni_environment", Integer.class, "JNIEnv", Integer.MIN_VALUE);
        this.dllLoad = this.getAddress("os::dll_load");
        this.dllLookup = this.getAddress("os::dll_lookup");
        this.rtldDefault = this.getAddress("RTLD_DEFAULT", this.osName.equals("bsd") || this.osName.equals("linux") ? null : Long.valueOf(-559023410L));
        this.threadExceptionOopOffset = (Integer)this.getFieldOffset("JavaThread::_exception_oop", Integer.class, "oop");
        this.threadExceptionPcOffset = (Integer)this.getFieldOffset("JavaThread::_exception_pc", Integer.class, "address");
        this.pendingExceptionOffset = (Integer)this.getFieldOffset("ThreadShadow::_pending_exception", Integer.class, "oop");
        this.pendingDeoptimizationOffset = (Integer)this.getFieldOffset("JavaThread::_pending_deoptimization", Integer.class, "int");
        this.pendingTransferToInterpreterOffset = (Integer)this.getFieldOffset("JavaThread::_pending_transfer_to_interpreter", Integer.class, "bool");
        this.javaFrameAnchorLastJavaSpOffset = (Integer)this.getFieldOffset("JavaFrameAnchor::_last_Java_sp", Integer.class, "intptr_t*");
        this.javaFrameAnchorLastJavaPcOffset = (Integer)this.getFieldOffset("JavaFrameAnchor::_last_Java_pc", Integer.class, "address");
        String name = "JavaThread::_pending_failed_speculation";
        int offset = -1;
        try {
            offset = (Integer)this.getFieldOffset(name, Integer.class, "jlong");
        }
        catch (JVMCIError e) {
            try {
                offset = (Integer)this.getFieldOffset(name, Integer.class, "long");
            }
            catch (JVMCIError jVMCIError) {
                // empty catch block
            }
        }
        if (offset == -1) {
            throw new JVMCIError("cannot get offset of field " + name + " with type long or jlong");
        }
        this.pendingFailedSpeculationOffset = offset;
        this.runtimeCallStackSize = (Integer)this.getConstant("frame::arg_reg_save_area_bytes", Integer.class, this.intRequiredOnAMD64);
        this.frameInterpreterFrameSenderSpOffset = (Integer)this.getConstant("frame::interpreter_frame_sender_sp_offset", Integer.class, this.intRequiredOnAMD64);
        this.frameInterpreterFrameLastSpOffset = (Integer)this.getConstant("frame::interpreter_frame_last_sp_offset", Integer.class, this.intRequiredOnAMD64);
        this.osThreadInterruptedOffset = (Integer)this.getFieldOffset("OSThread::_interrupted", Integer.class, "jint");
        this.markWordHashShift = (Long)this.getConstant(this.markWordField("hash_shift"), Long.class);
        this.biasedLockMaskInPlace = (Integer)this.getConstant(this.markWordField("biased_lock_mask_in_place"), Integer.class);
        this.ageMaskInPlace = (Integer)this.getConstant(this.markWordField("age_mask_in_place"), Integer.class);
        this.epochMaskInPlace = (Integer)this.getConstant(this.markWordField("epoch_mask_in_place"), Integer.class);
        this.markWordHashMask = (Long)this.getConstant(this.markWordField("hash_mask"), Long.class);
        this.markWordHashMaskInPlace = (Long)this.getConstant(this.markWordField("hash_mask_in_place"), Long.class);
        this.unlockedMask = (Integer)this.getConstant(this.markWordField("unlocked_value"), Integer.class);
        this.monitorMask = (Integer)this.getConstant(this.markWordField("monitor_value"), Integer.class, -1);
        this.biasedLockPattern = (Integer)this.getConstant(this.markWordField("biased_lock_pattern"), Integer.class);
        this.objectMonitorOwner = (Integer)this.getFieldOffset("ObjectMonitor::_owner", Integer.class, null, -1);
        this.objectMonitorRecursions = (Integer)this.getFieldOffset("ObjectMonitor::_recursions", Integer.class, "intptr_t", -1);
        this.objectMonitorCxq = (Integer)this.getFieldOffset("ObjectMonitor::_cxq", Integer.class, "ObjectWaiter*", -1);
        this.objectMonitorEntryList = (Integer)this.getFieldOffset("ObjectMonitor::_EntryList", Integer.class, "ObjectWaiter*", -1);
        this.objectMonitorSucc = (Integer)this.getFieldOffset("ObjectMonitor::_succ", Integer.class, "Thread*", -1);
        this.markWordNoHashInPlace = (Integer)this.getConstant(this.markWordField("no_hash_in_place"), Integer.class);
        this.markWordNoLockInPlace = (Integer)this.getConstant(this.markWordField("no_lock_in_place"), Integer.class);
        this.identityHashCodeShift = (Integer)this.getConstant(this.markWordField("hash_shift"), Integer.class);
        this.uninitializedIdentityHashCodeValue = (Integer)this.getConstant(this.markWordField("no_hash"), Integer.class);
        this.methodAccessFlagsOffset = (Integer)this.getFieldOffset("Method::_access_flags", Integer.class, "AccessFlags");
        this.methodConstMethodOffset = (Integer)this.getFieldOffset("Method::_constMethod", Integer.class, "ConstMethod*");
        this.methodIntrinsicIdOffset = this.versioned.methodIntrinsicIdOffset;
        this.methodFlagsOffset = this.versioned.methodFlagsOffset;
        this.methodVtableIndexOffset = (Integer)this.getFieldOffset("Method::_vtable_index", Integer.class, "int");
        this.methodCountersOffset = (Integer)this.getFieldOffset("Method::_method_counters", Integer.class, "MethodCounters*");
        this.methodDataOffset = (Integer)this.getFieldOffset("Method::_method_data", Integer.class, "MethodData*");
        this.methodCompiledEntryOffset = (Integer)this.getFieldOffset("Method::_from_compiled_entry", Integer.class, "address");
        this.methodCodeOffset = this.versioned.methodCodeOffset;
        this.methodFlagsCallerSensitive = (Integer)this.getConstant("Method::_caller_sensitive", Integer.class);
        this.methodFlagsForceInline = (Integer)this.getConstant("Method::_force_inline", Integer.class);
        this.methodFlagsDontInline = (Integer)this.getConstant("Method::_dont_inline", Integer.class);
        this.methodFlagsHidden = (Integer)this.getConstant("Method::_hidden", Integer.class);
        this.nonvirtualVtableIndex = (Integer)this.getConstant("Method::nonvirtual_vtable_index", Integer.class);
        this.invalidVtableIndex = (Integer)this.getConstant("Method::invalid_vtable_index", Integer.class);
        this.invocationCounterOffset = (Integer)this.getFieldOffset("MethodCounters::_invocation_counter", Integer.class, "InvocationCounter");
        this.backedgeCounterOffset = (Integer)this.getFieldOffset("MethodCounters::_backedge_counter", Integer.class, "InvocationCounter");
        this.invocationCounterIncrement = this.versioned.invocationCounterIncrement;
        this.invocationCounterShift = this.versioned.invocationCounterShift;
        this.nmethodEntryOffset = (Integer)this.getFieldOffset("nmethod::_verified_entry_point", Integer.class, "address");
        this.compilationLevelFullOptimization = (Integer)this.getConstant("CompLevel_full_optimization", Integer.class);
        this.constantPoolSize = (Integer)this.getFieldValue("CompilerToVM::Data::sizeof_ConstantPool", Integer.class, "int");
        this.constantPoolLengthOffset = (Integer)this.getFieldOffset("ConstantPool::_length", Integer.class, "int");
        this.heapWordSize = (Integer)this.getConstant("HeapWordSize", Integer.class);
        this.nonOopBits = (Long)this.getFieldValue("CompilerToVM::Data::Universe_non_oop_bits", Long.class, "void*");
        this.verifyOopCounterAddress = this.getFieldAddress("StubRoutines::_verify_oop_count", "jint");
        this.verifyOopMask = (Long)this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_mask", Long.class, "uintptr_t");
        this.verifyOopBits = (Long)this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_bits", Long.class, "uintptr_t");
        this.logOfHRGrainBytes = (Integer)this.getFieldValue("HeapRegion::LogOfHRGrainBytes", Integer.class, "int");
        this.cardtableStartAddress = (Long)this.getFieldValue("CompilerToVM::Data::cardtable_start_address", Long.class, "jbyte*");
        this.cardtableShift = (Integer)this.getFieldValue("CompilerToVM::Data::cardtable_shift", Integer.class, "int");
        this.maxOopMapStackOffset = (Integer)this.getFieldValue("CompilerToVM::Data::_max_oop_map_stack_offset", Integer.class, "int");
        this.safepointPollingAddress = (Long)this.getFieldValue("os::_polling_page", Long.class, "address");
        this.dirtyCardValue = this.versioned.dirtyCardValue;
        this.g1YoungCardValue = this.versioned.g1YoungCardValue;
        this.g1SATBQueueMarkingOffset = this.versioned.g1SATBQueueMarkingOffset;
        this.g1SATBQueueIndexOffset = this.versioned.g1SATBQueueIndexOffset;
        this.g1SATBQueueBufferOffset = this.versioned.g1SATBQueueBufferOffset;
        this.g1CardQueueIndexOffset = this.versioned.g1CardQueueIndexOffset;
        this.g1CardQueueBufferOffset = this.versioned.g1CardQueueBufferOffset;
        this.klassOffset = (Integer)this.getFieldValue("java_lang_Class::_klass_offset", Integer.class, "int");
        this.arrayKlassOffset = (Integer)this.getFieldValue("java_lang_Class::_array_klass_offset", Integer.class, "int");
        this.basicLockSize = (Integer)this.getFieldValue("CompilerToVM::Data::sizeof_BasicLock", Integer.class, "int");
        this.basicLockDisplacedHeaderOffset = (Integer)this.getFieldOffset("BasicLock::_displaced_header", Integer.class, this.markWord);
        this.threadPollingPageOffset = (Integer)this.getFieldOffset("Thread::_polling_page", Integer.class, "address", -1);
        this.threadAllocatedBytesOffset = (Integer)this.getFieldOffset("Thread::_allocated_bytes", Integer.class, "jlong");
        this.tlabRefillWasteIncrement = (Integer)this.getFlag("TLABWasteIncrement", Integer.class);
        this.threadLocalAllocBufferStartOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_start", Integer.class, "HeapWord*");
        this.threadLocalAllocBufferEndOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_end", Integer.class, "HeapWord*");
        this.threadLocalAllocBufferTopOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_top", Integer.class, "HeapWord*");
        this.threadLocalAllocBufferPfTopOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_pf_top", Integer.class, "HeapWord*");
        this.threadLocalAllocBufferSlowAllocationsOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_slow_allocations", Integer.class, "unsigned");
        this.threadLocalAllocBufferFastRefillWasteOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_fast_refill_waste", Integer.class, "unsigned");
        this.threadLocalAllocBufferNumberOfRefillsOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_number_of_refills", Integer.class, "unsigned");
        this.threadLocalAllocBufferRefillWasteLimitOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_refill_waste_limit", Integer.class, "size_t");
        this.threadLocalAllocBufferDesiredSizeOffset = (Integer)this.getFieldOffset("ThreadLocalAllocBuffer::_desired_size", Integer.class, "size_t");
        this.tlabAlignmentReserve = (Integer)this.getFieldValue("CompilerToVM::Data::ThreadLocalAllocBuffer_alignment_reserve", Integer.class, "size_t");
        this.tlabStats = (Boolean)this.getFlag("TLABStats", Boolean.class);
        this.psrInfoDczidValue = (Integer)this.getFieldValue("VM_Version::_psr_info.dczid_el0", Integer.class, "uint32_t", 16);
        this.inlineContiguousAllocationSupported = (Boolean)this.getFieldValue("CompilerToVM::Data::_supports_inline_contig_alloc", Boolean.class);
        this.heapEndAddress = (Long)this.getFieldValue("CompilerToVM::Data::_heap_end_addr", Long.class, "HeapWord**");
        this.heapTopAddress = this.versioned.heapTopAddress;
        this.cmsIncrementalMode = (Boolean)this.getFlag("CMSIncrementalMode", Boolean.class, false);
        this.inlineCacheMissStub = (Long)this.getFieldValue("CompilerToVM::Data::SharedRuntime_ic_miss_stub", Long.class, "address");
        this.handleWrongMethodStub = (Long)this.getFieldValue("CompilerToVM::Data::SharedRuntime_handle_wrong_method_stub", Long.class, "address");
        this.handleDeoptStub = (Long)this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack", Long.class, "address");
        this.uncommonTrapStub = (Long)this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_uncommon_trap", Long.class, "address");
        this.codeCacheLowBound = this.versioned.codeCacheLowBound;
        this.codeCacheHighBound = this.versioned.codeCacheHighBound;
        this.aescryptEncryptBlockStub = (Long)this.getFieldValue("StubRoutines::_aescrypt_encryptBlock", Long.class, "address");
        this.aescryptDecryptBlockStub = (Long)this.getFieldValue("StubRoutines::_aescrypt_decryptBlock", Long.class, "address");
        this.cipherBlockChainingEncryptAESCryptStub = (Long)this.getFieldValue("StubRoutines::_cipherBlockChaining_encryptAESCrypt", Long.class, "address");
        this.cipherBlockChainingDecryptAESCryptStub = (Long)this.getFieldValue("StubRoutines::_cipherBlockChaining_decryptAESCrypt", Long.class, "address");
        this.updateBytesCRC32Stub = (Long)this.getFieldValue("StubRoutines::_updateBytesCRC32", Long.class, "address");
        this.crcTableAddress = (Long)this.getFieldValue("StubRoutines::_crc_table_adr", Long.class, "address");
        this.sha1ImplCompress = (Long)this.getFieldValue("StubRoutines::_sha1_implCompress", Long.class, "address", 0L);
        this.sha1ImplCompressMultiBlock = (Long)this.getFieldValue("StubRoutines::_sha1_implCompressMB", Long.class, "address", 0L);
        this.sha256ImplCompress = (Long)this.getFieldValue("StubRoutines::_sha256_implCompress", Long.class, "address", 0L);
        this.sha256ImplCompressMultiBlock = (Long)this.getFieldValue("StubRoutines::_sha256_implCompressMB", Long.class, "address", 0L);
        this.sha512ImplCompress = (Long)this.getFieldValue("StubRoutines::_sha512_implCompress", Long.class, "address", 0L);
        this.sha512ImplCompressMultiBlock = (Long)this.getFieldValue("StubRoutines::_sha512_implCompressMB", Long.class, "address", 0L);
        this.multiplyToLen = (Long)this.getFieldValue("StubRoutines::_multiplyToLen", Long.class, "address", this.longRequiredOnAMD64);
        this.counterModeAESCrypt = (Long)this.getFieldValue("StubRoutines::_counterMode_AESCrypt", Long.class, "address", 0L);
        this.ghashProcessBlocks = (Long)this.getFieldValue("StubRoutines::_ghash_processBlocks", Long.class, "address", 0L);
        this.base64EncodeBlock = (Long)this.getFieldValue("StubRoutines::_base64_encodeBlock", Long.class, "address", 0L);
        this.crc32cTableTddr = (Long)this.getFieldValue("StubRoutines::_crc32c_table_addr", Long.class, "address", 0L);
        this.updateBytesCRC32C = (Long)this.getFieldValue("StubRoutines::_updateBytesCRC32C", Long.class, "address", 0L);
        this.updateBytesAdler32 = (Long)this.getFieldValue("StubRoutines::_updateBytesAdler32", Long.class, "address", 0L);
        this.squareToLen = (Long)this.getFieldValue("StubRoutines::_squareToLen", Long.class, "address", this.longRequiredOnAMD64);
        this.mulAdd = (Long)this.getFieldValue("StubRoutines::_mulAdd", Long.class, "address", this.longRequiredOnAMD64);
        this.montgomeryMultiply = (Long)this.getFieldValue("StubRoutines::_montgomeryMultiply", Long.class, "address", this.longRequiredOnAMD64);
        this.montgomerySquare = (Long)this.getFieldValue("StubRoutines::_montgomerySquare", Long.class, "address", this.longRequiredOnAMD64);
        this.vectorizedMismatch = (Long)this.getFieldValue("StubRoutines::_vectorizedMismatch", Long.class, "address", 0L);
        this.throwDelayedStackOverflowErrorEntry = this.versioned.throwDelayedStackOverflowErrorEntry;
        this.jbyteArraycopy = (Long)this.getFieldValue("StubRoutines::_jbyte_arraycopy", Long.class, "address");
        this.jshortArraycopy = (Long)this.getFieldValue("StubRoutines::_jshort_arraycopy", Long.class, "address");
        this.jintArraycopy = (Long)this.getFieldValue("StubRoutines::_jint_arraycopy", Long.class, "address");
        this.jlongArraycopy = (Long)this.getFieldValue("StubRoutines::_jlong_arraycopy", Long.class, "address");
        this.oopArraycopy = (Long)this.getFieldValue("StubRoutines::_oop_arraycopy", Long.class, "address");
        this.oopArraycopyUninit = (Long)this.getFieldValue("StubRoutines::_oop_arraycopy_uninit", Long.class, "address");
        this.jbyteDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_jbyte_disjoint_arraycopy", Long.class, "address");
        this.jshortDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_jshort_disjoint_arraycopy", Long.class, "address");
        this.jintDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_jint_disjoint_arraycopy", Long.class, "address");
        this.jlongDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_jlong_disjoint_arraycopy", Long.class, "address");
        this.oopDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy", Long.class, "address");
        this.oopDisjointArraycopyUninit = (Long)this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy_uninit", Long.class, "address");
        this.jbyteAlignedArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jbyte_arraycopy", Long.class, "address");
        this.jshortAlignedArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jshort_arraycopy", Long.class, "address");
        this.jintAlignedArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jint_arraycopy", Long.class, "address");
        this.jlongAlignedArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jlong_arraycopy", Long.class, "address");
        this.oopAlignedArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy", Long.class, "address");
        this.oopAlignedArraycopyUninit = (Long)this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy_uninit", Long.class, "address");
        this.jbyteAlignedDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jbyte_disjoint_arraycopy", Long.class, "address");
        this.jshortAlignedDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jshort_disjoint_arraycopy", Long.class, "address");
        this.jintAlignedDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jint_disjoint_arraycopy", Long.class, "address");
        this.jlongAlignedDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_jlong_disjoint_arraycopy", Long.class, "address");
        this.oopAlignedDisjointArraycopy = (Long)this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy", Long.class, "address");
        this.oopAlignedDisjointArraycopyUninit = (Long)this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy_uninit", Long.class, "address");
        this.checkcastArraycopy = (Long)this.getFieldValue("StubRoutines::_checkcast_arraycopy", Long.class, "address");
        this.checkcastArraycopyUninit = (Long)this.getFieldValue("StubRoutines::_checkcast_arraycopy_uninit", Long.class, "address");
        this.unsafeArraycopy = (Long)this.getFieldValue("StubRoutines::_unsafe_arraycopy", Long.class, "address");
        this.genericArraycopy = (Long)this.getFieldValue("StubRoutines::_generic_arraycopy", Long.class, "address");
        this.newInstanceAddress = this.getAddress("JVMCIRuntime::new_instance");
        this.newArrayAddress = this.getAddress("JVMCIRuntime::new_array");
        this.newMultiArrayAddress = this.getAddress("JVMCIRuntime::new_multi_array");
        this.dynamicNewInstanceAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance");
        this.newInstanceOrNullAddress = this.getAddress("JVMCIRuntime::new_instance_or_null", 0L);
        this.newArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_array_or_null", 0L);
        this.newMultiArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_multi_array_or_null", 0L);
        this.dynamicNewInstanceOrNullAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance_or_null", 0L);
        this.threadIsInterruptedAddress = this.getAddress("JVMCIRuntime::thread_is_interrupted");
        this.vmMessageAddress = this.getAddress("JVMCIRuntime::vm_message");
        this.identityHashCodeAddress = this.getAddress("JVMCIRuntime::identity_hash_code");
        this.exceptionHandlerForPcAddress = this.getAddress("JVMCIRuntime::exception_handler_for_pc");
        this.monitorenterAddress = this.getAddress("JVMCIRuntime::monitorenter");
        this.monitorexitAddress = this.getAddress("JVMCIRuntime::monitorexit");
        this.notifyAddress = this.getAddress("JVMCIRuntime::object_notify", 0L);
        this.notifyAllAddress = this.getAddress("JVMCIRuntime::object_notifyAll", 0L);
        this.throwAndPostJvmtiExceptionAddress = this.getAddress("JVMCIRuntime::throw_and_post_jvmti_exception");
        this.throwKlassExternalNameExceptionAddress = this.getAddress("JVMCIRuntime::throw_klass_external_name_exception");
        this.throwClassCastExceptionAddress = this.getAddress("JVMCIRuntime::throw_class_cast_exception");
        this.logPrimitiveAddress = this.getAddress("JVMCIRuntime::log_primitive");
        this.logObjectAddress = this.getAddress("JVMCIRuntime::log_object");
        this.logPrintfAddress = this.getAddress("JVMCIRuntime::log_printf");
        this.vmErrorAddress = this.getAddress("JVMCIRuntime::vm_error");
        this.loadAndClearExceptionAddress = this.getAddress("JVMCIRuntime::load_and_clear_exception");
        this.writeBarrierPreAddress = this.getAddress("JVMCIRuntime::write_barrier_pre");
        this.writeBarrierPostAddress = this.getAddress("JVMCIRuntime::write_barrier_post");
        this.validateObject = this.getAddress("JVMCIRuntime::validate_object");
        this.testDeoptimizeCallInt = this.getAddress("JVMCIRuntime::test_deoptimize_call_int");
        this.registerFinalizerAddress = this.getAddress("SharedRuntime::register_finalizer");
        this.exceptionHandlerForReturnAddressAddress = this.getAddress("SharedRuntime::exception_handler_for_return_address");
        this.osrMigrationEndAddress = this.getAddress("SharedRuntime::OSR_migration_end");
        this.enableStackReservedZoneAddress = this.versioned.enableStackReservedZoneAddress;
        this.javaTimeMillisAddress = this.getAddress("os::javaTimeMillis");
        this.javaTimeNanosAddress = this.getAddress("os::javaTimeNanos");
        this.arithmeticSinAddress = (Long)this.getFieldValue("CompilerToVM::Data::dsin", Long.class, "address");
        this.arithmeticCosAddress = (Long)this.getFieldValue("CompilerToVM::Data::dcos", Long.class, "address");
        this.arithmeticTanAddress = (Long)this.getFieldValue("CompilerToVM::Data::dtan", Long.class, "address");
        this.arithmeticExpAddress = (Long)this.getFieldValue("CompilerToVM::Data::dexp", Long.class, "address");
        this.arithmeticLogAddress = (Long)this.getFieldValue("CompilerToVM::Data::dlog", Long.class, "address");
        this.arithmeticLog10Address = (Long)this.getFieldValue("CompilerToVM::Data::dlog10", Long.class, "address");
        this.arithmeticPowAddress = (Long)this.getFieldValue("CompilerToVM::Data::dpow", Long.class, "address");
        this.fremAddress = this.getAddress("SharedRuntime::frem");
        this.dremAddress = this.getAddress("SharedRuntime::drem");
        this.jvmciCountersSize = (Integer)this.getFlag("JVMCICounterSize", Integer.class);
        this.deoptimizationFetchUnrollInfo = this.getAddress("Deoptimization::fetch_unroll_info");
        this.deoptimizationUncommonTrap = this.getAddress("Deoptimization::uncommon_trap");
        this.deoptimizationUnpackFrames = this.getAddress("Deoptimization::unpack_frames");
        this.deoptimizationUnpackDeopt = (Integer)this.getConstant("Deoptimization::Unpack_deopt", Integer.class);
        this.deoptimizationUnpackException = (Integer)this.getConstant("Deoptimization::Unpack_exception", Integer.class);
        this.deoptimizationUnpackUncommonTrap = (Integer)this.getConstant("Deoptimization::Unpack_uncommon_trap", Integer.class);
        this.deoptimizationUnpackReexecute = (Integer)this.getConstant("Deoptimization::Unpack_reexecute", Integer.class);
        this.deoptimizationUnrollBlockSizeOfDeoptimizedFrameOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_size_of_deoptimized_frame", Integer.class, "int");
        this.deoptimizationUnrollBlockCallerAdjustmentOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_caller_adjustment", Integer.class, "int");
        this.deoptimizationUnrollBlockNumberOfFramesOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_number_of_frames", Integer.class, "int");
        this.deoptimizationUnrollBlockTotalFrameSizesOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_total_frame_sizes", Integer.class, "int");
        this.deoptimizationUnrollBlockUnpackKindOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_unpack_kind", Integer.class, "int");
        this.deoptimizationUnrollBlockFrameSizesOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_frame_sizes", Integer.class, "intptr_t*");
        this.deoptimizationUnrollBlockFramePcsOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_frame_pcs", Integer.class, "address*");
        this.deoptimizationUnrollBlockInitialInfoOffset = (Integer)this.getFieldOffset("Deoptimization::UnrollBlock::_initial_info", Integer.class, "intptr_t");
        this.MARKID_VERIFIED_ENTRY = (Integer)this.getConstant("CodeInstaller::VERIFIED_ENTRY", Integer.class);
        this.MARKID_UNVERIFIED_ENTRY = (Integer)this.getConstant("CodeInstaller::UNVERIFIED_ENTRY", Integer.class);
        this.MARKID_OSR_ENTRY = (Integer)this.getConstant("CodeInstaller::OSR_ENTRY", Integer.class);
        this.MARKID_EXCEPTION_HANDLER_ENTRY = (Integer)this.getConstant("CodeInstaller::EXCEPTION_HANDLER_ENTRY", Integer.class);
        this.MARKID_DEOPT_HANDLER_ENTRY = (Integer)this.getConstant("CodeInstaller::DEOPT_HANDLER_ENTRY", Integer.class);
        this.MARKID_INVOKEINTERFACE = (Integer)this.getConstant("CodeInstaller::INVOKEINTERFACE", Integer.class);
        this.MARKID_INVOKEVIRTUAL = (Integer)this.getConstant("CodeInstaller::INVOKEVIRTUAL", Integer.class);
        this.MARKID_INVOKESTATIC = (Integer)this.getConstant("CodeInstaller::INVOKESTATIC", Integer.class);
        this.MARKID_INVOKESPECIAL = (Integer)this.getConstant("CodeInstaller::INVOKESPECIAL", Integer.class);
        this.MARKID_INLINE_INVOKE = (Integer)this.getConstant("CodeInstaller::INLINE_INVOKE", Integer.class);
        this.MARKID_POLL_NEAR = (Integer)this.getConstant("CodeInstaller::POLL_NEAR", Integer.class);
        this.MARKID_POLL_RETURN_NEAR = (Integer)this.getConstant("CodeInstaller::POLL_RETURN_NEAR", Integer.class);
        this.MARKID_POLL_FAR = (Integer)this.getConstant("CodeInstaller::POLL_FAR", Integer.class);
        this.MARKID_POLL_RETURN_FAR = (Integer)this.getConstant("CodeInstaller::POLL_RETURN_FAR", Integer.class);
        this.MARKID_CARD_TABLE_SHIFT = (Integer)this.getConstant("CodeInstaller::CARD_TABLE_SHIFT", Integer.class);
        this.MARKID_CARD_TABLE_ADDRESS = (Integer)this.getConstant("CodeInstaller::CARD_TABLE_ADDRESS", Integer.class);
        this.MARKID_INVOKE_INVALID = (Integer)this.getConstant("CodeInstaller::INVOKE_INVALID", Integer.class);
        this.MARKID_HEAP_TOP_ADDRESS = (Integer)this.getConstant("CodeInstaller::HEAP_TOP_ADDRESS", Integer.class, 17);
        this.MARKID_HEAP_END_ADDRESS = (Integer)this.getConstant("CodeInstaller::HEAP_END_ADDRESS", Integer.class, 18);
        this.MARKID_NARROW_KLASS_BASE_ADDRESS = (Integer)this.getConstant("CodeInstaller::NARROW_KLASS_BASE_ADDRESS", Integer.class, 19);
        this.MARKID_NARROW_OOP_BASE_ADDRESS = (Integer)this.getConstant("CodeInstaller::NARROW_OOP_BASE_ADDRESS", Integer.class, 20);
        this.MARKID_CRC_TABLE_ADDRESS = (Integer)this.getConstant("CodeInstaller::CRC_TABLE_ADDRESS", Integer.class, 21);
        this.MARKID_LOG_OF_HEAP_REGION_GRAIN_BYTES = (Integer)this.getConstant("CodeInstaller::LOG_OF_HEAP_REGION_GRAIN_BYTES", Integer.class, 22);
        this.MARKID_INLINE_CONTIGUOUS_ALLOCATION_SUPPORTED = (Integer)this.getConstant("CodeInstaller::INLINE_CONTIGUOUS_ALLOCATION_SUPPORTED", Integer.class, 23);
        assert (this.narrowKlassShift <= this.logKlassAlignment);
        assert (this.narrowOopShift <= this.logMinObjAlignment());
        this.oopEncoding = new CompressEncoding(this.narrowOopBase, this.narrowOopShift);
        this.klassEncoding = new CompressEncoding(this.narrowKlassBase, this.narrowKlassShift);
        assert (this.check());
    }

    public CompressEncoding getOopEncoding() {
        return this.oopEncoding;
    }

    public CompressEncoding getKlassEncoding() {
        return this.klassEncoding;
    }

    public boolean useMultiplyToLenIntrinsic() {
        return this.useMultiplyToLenIntrinsic && this.multiplyToLen != 0L;
    }

    public boolean useSHA1Intrinsics() {
        return this.useSHA1Intrinsics && this.sha1ImplCompress != 0L && this.sha1ImplCompressMultiBlock != 0L;
    }

    public boolean useSHA256Intrinsics() {
        return this.useSHA256Intrinsics && this.sha256ImplCompress != 0L && this.sha256ImplCompressMultiBlock != 0L;
    }

    public boolean useSHA512Intrinsics() {
        return this.useSHA512Intrinsics && this.sha512ImplCompress != 0L && this.sha512ImplCompressMultiBlock != 0L;
    }

    public boolean useGHASHIntrinsics() {
        return this.useGHASHIntrinsics && this.ghashProcessBlocks != 0L;
    }

    public boolean useBase64Intrinsics() {
        return this.useBase64Intrinsics && this.base64EncodeBlock != 0L;
    }

    public boolean useMontgomeryMultiplyIntrinsic() {
        return this.useMontgomeryMultiplyIntrinsic && this.montgomeryMultiply != 0L;
    }

    public boolean useMontgomerySquareIntrinsic() {
        return this.useMontgomerySquareIntrinsic && this.montgomerySquare != 0L;
    }

    public boolean useMulAddIntrinsic() {
        return this.useMulAddIntrinsic && this.mulAdd != 0L;
    }

    public boolean useSquareToLenIntrinsic() {
        return this.useSquareToLenIntrinsic && this.squareToLen != 0L;
    }

    public boolean inlineNotify() {
        return this.inlineNotify && this.notifyAddress != 0L;
    }

    public boolean inlineNotifyAll() {
        return this.inlineNotify && this.notifyAllAddress != 0L;
    }

    public long gcTotalCollectionsAddress() {
        return this.universeCollectedHeap + (long)this.collectedHeapTotalCollectionsOffset;
    }

    public final int minObjAlignment() {
        return this.objectAlignment / this.heapWordSize;
    }

    public final int logMinObjAlignment() {
        return (int)(Math.log(this.objectAlignment) / Math.log(2.0));
    }

    public int layoutHelperElementTypePrimitiveInPlace() {
        return (this.layoutHelperArrayTagTypeValue & ~this.layoutHelperArrayTagObjectValue) << this.layoutHelperArrayTagShift;
    }

    public final int arrayOopDescLengthOffset() {
        return this.useCompressedClassPointers ? this.hubOffset + this.narrowKlassSize : this.arrayOopDescSize;
    }

    private int getJvmciJvmtiCapabilityOffset(String name) {
        int offset = (Integer)this.getFieldOffset("JVMCICompileState::" + name, Integer.class, "jbyte", Integer.MIN_VALUE);
        if (offset == Integer.MIN_VALUE) {
            offset = (Integer)this.getFieldOffset("JVMCIEnv::" + name, Integer.class, "jbyte", Integer.MIN_VALUE);
        }
        return offset;
    }

    public boolean requiresReservedStackCheck(List<ResolvedJavaMethod> methods) {
        if (this.enableStackReservedZoneAddress != 0L && methods != null) {
            for (ResolvedJavaMethod method : methods) {
                if (!((HotSpotResolvedJavaMethod)method).hasReservedStackAccess()) continue;
                return true;
            }
        }
        return false;
    }

    public int threadLastJavaSpOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaSpOffset;
    }

    public int threadLastJavaPcOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaPcOffset;
    }

    public int threadLastJavaFpOffset() {
        assert (this.osArch.equals("aarch64") || this.osArch.equals("amd64"));
        return this.javaThreadAnchorOffset + (Integer)this.getFieldOffset("JavaFrameAnchor::_last_Java_fp", Integer.class, "intptr_t*");
    }

    public int threadJavaFrameAnchorFlagsOffset() {
        assert (this.osArch.equals("sparc"));
        return this.javaThreadAnchorOffset + (Integer)this.getFieldOffset("JavaFrameAnchor::_flags", Integer.class, "int");
    }

    public long arrayPrototypeMarkWord() {
        return this.markWordNoHashInPlace | this.markWordNoLockInPlace;
    }

    public long tlabIntArrayMarkWord() {
        long tmp = this.arrayPrototypeMarkWord() & (this.markWordHashMaskInPlace ^ 0xFFFFFFFFFFFFFFFFL);
        return tmp |= (2L & this.markWordHashMask) << (int)this.markWordHashShift;
    }

    private String markWordField(String simpleName) {
        return this.versioned.markWordClassName + "::" + simpleName;
    }

    public int tlabSlowAllocationsOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferSlowAllocationsOffset;
    }

    public int tlabFastRefillWasteOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferFastRefillWasteOffset;
    }

    public int tlabNumberOfRefillsOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferNumberOfRefillsOffset;
    }

    public int tlabRefillWasteLimitOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferRefillWasteLimitOffset;
    }

    public int threadTlabSizeOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferDesiredSizeOffset;
    }

    public int threadTlabStartOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferStartOffset;
    }

    public int threadTlabEndOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferEndOffset;
    }

    public int threadTlabTopOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferTopOffset;
    }

    public int threadTlabPfTopOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferPfTopOffset;
    }

    public boolean areNullAllocationStubsAvailable() {
        return this.newInstanceOrNullAddress != 0L;
    }

    private boolean checkNullAllocationStubs() {
        if (this.newInstanceOrNullAddress == 0L) {
            assert (this.newArrayOrNullAddress == 0L);
            assert (this.newMultiArrayOrNullAddress == 0L);
            assert (this.dynamicNewInstanceOrNullAddress == 0L);
        } else {
            assert (this.newArrayOrNullAddress != 0L);
            assert (this.newMultiArrayOrNullAddress != 0L);
            assert (this.dynamicNewInstanceOrNullAddress != 0L);
        }
        return true;
    }

    protected boolean check() {
        for (Field f : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            int modifiers = f.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) assert (Modifier.isFinal(modifiers)) : "field should be final: " + f;
        }
        assert (this.codeEntryAlignment > 0) : this.codeEntryAlignment;
        assert (this.checkNullAllocationStubs());
        return true;
    }
}

