/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigVersioned;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.options.OptionValues;

public abstract class GraalHotSpotVMConfigBase
extends HotSpotVMConfigAccess {
    protected final GraalHotSpotVMConfigVersioned versioned;
    public static final GraalHotSpotVMConfig INJECTED_VMCONFIG = null;
    public static final MetaAccessProvider INJECTED_METAACCESS = null;
    public static final OptionValues INJECTED_OPTIONVALUES = null;
    public static final IntrinsicContext INJECTED_INTRINSIC_CONTEXT = null;
    public final String osName = GraalHotSpotVMConfigBase.getHostOSName();
    public final String osArch = GraalHotSpotVMConfigBase.getHostArchitectureName();
    public final boolean windowsOs = GraalHotSpotVMConfigBase.getProperty("os.name", "").startsWith("Windows");
    public final boolean linuxOs = GraalHotSpotVMConfigBase.getProperty("os.name", "").startsWith("Linux");
    protected final Integer intRequiredOnAMD64 = this.osArch.equals("amd64") ? null : Integer.valueOf(0);
    protected final Long longRequiredOnAMD64;

    GraalHotSpotVMConfigBase(HotSpotVMConfigStore store) {
        super(store);
        Long l = this.longRequiredOnAMD64 = this.osArch.equals("amd64") ? null : Long.valueOf(0L);
        assert (this instanceof GraalHotSpotVMConfig);
        this.versioned = new GraalHotSpotVMConfigVersioned(store);
        assert (this.checkVersioned());
    }

    private boolean checkVersioned() {
        Class<?> c = ((Object)((Object)this.versioned)).getClass();
        for (Field field : c.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) assert (!Modifier.isFinal(modifiers)) : "Non-static field in " + c.getName() + " must not be final: " + field.getName();
        }
        return true;
    }

    private static String getProperty(String name, String def) {
        String value = (String)Services.getSavedProperties().get(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    private static String getProperty(String name) {
        return GraalHotSpotVMConfigBase.getProperty(name, null);
    }

    private static String getHostOSName() {
        String osName;
        switch (osName = GraalHotSpotVMConfigBase.getProperty("os.name")) {
            case "Linux": {
                osName = "linux";
                break;
            }
            case "SunOS": {
                osName = "solaris";
                break;
            }
            case "Mac OS X": {
                osName = "bsd";
                break;
            }
            default: {
                if (osName.startsWith("Windows")) {
                    osName = "windows";
                    break;
                }
                throw new JVMCIError("Unexpected OS name: " + osName);
            }
        }
        return osName;
    }

    private static String getHostArchitectureName() {
        String arch;
        switch (arch = GraalHotSpotVMConfigBase.getProperty("os.arch")) {
            case "x86_64": {
                arch = "amd64";
                break;
            }
            case "sparcv9": {
                arch = "sparc";
            }
        }
        return arch;
    }
}

