/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.EnumSet;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotCompiledCodeBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotInstructionProfiling;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;

public abstract class HotSpotBackend
extends Backend
implements FrameMap.ReferenceMapBuilderFactory {
    public static final ForeignCallDescriptor EXCEPTION_HANDLER = new ForeignCallDescriptor("exceptionHandler", Void.TYPE, Object.class, Word.class);
    public static final ForeignCallDescriptor IC_MISS_HANDLER = new ForeignCallDescriptor("icMissHandler", Void.TYPE, new Class[0]);
    public static final ForeignCallDescriptor WRONG_METHOD_HANDLER = new ForeignCallDescriptor("wrongMethodHandler", Void.TYPE, new Class[0]);
    public static final ForeignCallDescriptor UNWIND_EXCEPTION_TO_CALLER = new ForeignCallDescriptor("unwindExceptionToCaller", Void.TYPE, Object.class, Word.class);
    public static final ForeignCallDescriptor EXCEPTION_HANDLER_IN_CALLER = new ForeignCallDescriptor("exceptionHandlerInCaller", Void.TYPE, Object.class, Word.class);
    private final HotSpotGraalRuntimeProvider runtime;
    public static final ForeignCallDescriptor ENCRYPT_BLOCK = new ForeignCallDescriptor("encrypt_block", Void.TYPE, Word.class, Word.class, Pointer.class);
    public static final ForeignCallDescriptor DECRYPT_BLOCK = new ForeignCallDescriptor("decrypt_block", Void.TYPE, Word.class, Word.class, Pointer.class);
    public static final ForeignCallDescriptor DECRYPT_BLOCK_WITH_ORIGINAL_KEY = new ForeignCallDescriptor("decrypt_block_with_original_key", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class);
    public static final ForeignCallDescriptor ENCRYPT = new ForeignCallDescriptor("encrypt", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class, Integer.TYPE);
    public static final ForeignCallDescriptor DECRYPT = new ForeignCallDescriptor("decrypt", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class, Integer.TYPE);
    public static final ForeignCallDescriptor DECRYPT_WITH_ORIGINAL_KEY = new ForeignCallDescriptor("decrypt_with_original_key", Void.TYPE, Word.class, Word.class, Pointer.class, Pointer.class, Integer.TYPE, Pointer.class);
    public static final ForeignCallDescriptor MULTIPLY_TO_LEN = new ForeignCallDescriptor("multiplyToLen", Void.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE);
    public static final ForeignCallDescriptor MUL_ADD = new ForeignCallDescriptor("mulAdd", Integer.TYPE, Word.class, Word.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor MONTGOMERY_MULTIPLY = new ForeignCallDescriptor("implMontgomeryMultiply", Void.TYPE, Word.class, Word.class, Word.class, Integer.TYPE, Long.TYPE, Word.class);
    public static final ForeignCallDescriptor MONTGOMERY_SQUARE = new ForeignCallDescriptor("implMontgomerySquare", Void.TYPE, Word.class, Word.class, Integer.TYPE, Long.TYPE, Word.class);
    public static final ForeignCallDescriptor SQUARE_TO_LEN = new ForeignCallDescriptor("implSquareToLen", Void.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE);
    public static final ForeignCallDescriptor SHA_IMPL_COMPRESS = new ForeignCallDescriptor("shaImplCompress", Void.TYPE, Word.class, Object.class);
    public static final ForeignCallDescriptor SHA2_IMPL_COMPRESS = new ForeignCallDescriptor("sha2ImplCompress", Void.TYPE, Word.class, Object.class);
    public static final ForeignCallDescriptor SHA5_IMPL_COMPRESS = new ForeignCallDescriptor("sha5ImplCompress", Void.TYPE, Word.class, Object.class);
    public static final ForeignCallDescriptor SHA_IMPL_COMPRESS_MB = new ForeignCallDescriptor("shaImplCompressMB", Integer.TYPE, Word.class, Object.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor SHA2_IMPL_COMPRESS_MB = new ForeignCallDescriptor("sha2ImplCompressMB", Integer.TYPE, Word.class, Object.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor SHA5_IMPL_COMPRESS_MB = new ForeignCallDescriptor("sha5ImplCompressMB", Integer.TYPE, Word.class, Object.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor GHASH_PROCESS_BLOCKS = new ForeignCallDescriptor("ghashProcessBlocks", Void.TYPE, Word.class, Word.class, Word.class, Integer.TYPE);
    public static final ForeignCallDescriptor BASE64_ENCODE_BLOCK = new ForeignCallDescriptor("base64EncodeBlock", Void.TYPE, Word.class, Integer.TYPE, Integer.TYPE, Word.class, Integer.TYPE, Boolean.TYPE);
    public static final ForeignCallDescriptor COUNTERMODE_IMPL_CRYPT = new ForeignCallDescriptor("counterModeAESCrypt", Integer.TYPE, Word.class, Word.class, Word.class, Word.class, Integer.TYPE, Word.class, Word.class);
    public static final ForeignCallDescriptor VECTORIZED_MISMATCHED = new ForeignCallDescriptor("vectorizedMismatch", Integer.TYPE, Word.class, Word.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor VM_ERROR = new ForeignCallDescriptor("vm_error", Void.TYPE, Object.class, Object.class, Long.TYPE);
    public static final ForeignCallDescriptor NEW_MULTI_ARRAY = new ForeignCallDescriptor("new_multi_array", Object.class, KlassPointer.class, Integer.TYPE, Word.class);
    public static final ForeignCallDescriptor NEW_MULTI_ARRAY_OR_NULL = new ForeignCallDescriptor("new_multi_array_or_null", Object.class, KlassPointer.class, Integer.TYPE, Word.class);
    public static final ForeignCallDescriptor NEW_ARRAY = new ForeignCallDescriptor("new_array", Object.class, KlassPointer.class, Integer.TYPE);
    public static final ForeignCallDescriptor NEW_ARRAY_OR_NULL = new ForeignCallDescriptor("new_array_or_null", Object.class, KlassPointer.class, Integer.TYPE);
    public static final ForeignCallDescriptor NEW_INSTANCE = new ForeignCallDescriptor("new_instance", Object.class, KlassPointer.class);
    public static final ForeignCallDescriptor NEW_INSTANCE_OR_NULL = new ForeignCallDescriptor("new_instance_or_null", Object.class, KlassPointer.class);
    public static final ForeignCallDescriptor RESOLVE_STRING_BY_SYMBOL = new ForeignCallDescriptor("resolve_string_by_symbol", Object.class, Word.class, Word.class);
    public static final ForeignCallDescriptor RESOLVE_DYNAMIC_INVOKE = new ForeignCallDescriptor("resolve_dynamic_invoke", Object.class, Word.class);
    public static final ForeignCallDescriptor RESOLVE_KLASS_BY_SYMBOL = new ForeignCallDescriptor("resolve_klass_by_symbol", Word.class, Word.class, Word.class);
    public static final ForeignCallDescriptor INITIALIZE_KLASS_BY_SYMBOL = new ForeignCallDescriptor("initialize_klass_by_symbol", Word.class, Word.class, Word.class);
    public static final ForeignCallDescriptor RESOLVE_METHOD_BY_SYMBOL_AND_LOAD_COUNTERS = new ForeignCallDescriptor("resolve_method_by_symbol_and_load_counters", Word.class, Word.class, Word.class, Word.class);
    public static final ForeignCallDescriptor INVOCATION_EVENT = new ForeignCallDescriptor("invocation_event", Void.TYPE, MethodCountersPointer.class);
    public static final ForeignCallDescriptor BACKEDGE_EVENT = new ForeignCallDescriptor("backedge_event", Void.TYPE, MethodCountersPointer.class, Integer.TYPE, Integer.TYPE);

    public static void multiplyToLenStub(Word xAddr, int xlen, Word yAddr, int ylen, Word zAddr, int zLen) {
        HotSpotBackend.multiplyToLenStub(MULTIPLY_TO_LEN, xAddr, xlen, yAddr, ylen, zAddr, zLen);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void multiplyToLenStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, Word var3, int var4, Word var5, int var6);

    public static int mulAddStub(Word inAddr, Word outAddr, int newOffset, int len, int k) {
        return HotSpotBackend.mulAddStub(MUL_ADD, inAddr, outAddr, newOffset, len, k);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int mulAddStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, int var3, int var4, int var5);

    public static void implMontgomeryMultiply(Word aAddr, Word bAddr, Word nAddr, int len, long inv, Word productAddr) {
        HotSpotBackend.implMontgomeryMultiply(MONTGOMERY_MULTIPLY, aAddr, bAddr, nAddr, len, inv, productAddr);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void implMontgomeryMultiply(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Word var3, int var4, long var5, Word var7);

    public static void implMontgomerySquare(Word aAddr, Word nAddr, int len, long inv, Word productAddr) {
        HotSpotBackend.implMontgomerySquare(MONTGOMERY_SQUARE, aAddr, nAddr, len, inv, productAddr);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void implMontgomerySquare(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, int var3, long var4, Word var6);

    public static void implSquareToLen(Word xAddr, int len, Word zAddr, int zLen) {
        HotSpotBackend.implSquareToLen(SQUARE_TO_LEN, xAddr, len, zAddr, zLen);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void implSquareToLen(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, Word var3, int var4);

    public static void shaImplCompressStub(Word bufAddr, Object state) {
        HotSpotBackend.shaImplCompressStub(SHA_IMPL_COMPRESS, bufAddr, state);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void shaImplCompressStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2);

    public static void sha2ImplCompressStub(Word bufAddr, Object state) {
        HotSpotBackend.sha2ImplCompressStub(SHA2_IMPL_COMPRESS, bufAddr, state);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void sha2ImplCompressStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2);

    public static void sha5ImplCompressStub(Word bufAddr, Object state) {
        HotSpotBackend.sha5ImplCompressStub(SHA5_IMPL_COMPRESS, bufAddr, state);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void sha5ImplCompressStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2);

    public static int shaImplCompressMBStub(Word bufAddr, Object stateAddr, int ofs, int limit) {
        return HotSpotBackend.shaImplCompressMBStub(SHA_IMPL_COMPRESS_MB, bufAddr, stateAddr, ofs, limit);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int shaImplCompressMBStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2, int var3, int var4);

    public static int sha2ImplCompressMBStub(Word bufAddr, Object stateAddr, int ofs, int limit) {
        return HotSpotBackend.sha2ImplCompressMBStub(SHA2_IMPL_COMPRESS_MB, bufAddr, stateAddr, ofs, limit);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int sha2ImplCompressMBStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2, int var3, int var4);

    public static int sha5ImplCompressMBStub(Word bufAddr, Object stateAddr, int ofs, int limit) {
        return HotSpotBackend.sha5ImplCompressMBStub(SHA5_IMPL_COMPRESS_MB, bufAddr, stateAddr, ofs, limit);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int sha5ImplCompressMBStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2, int var3, int var4);

    public static void unsafeArraycopy(Word srcAddr, Word dstAddr, Word size) {
        HotSpotBackend.unsafeArraycopyStub(ArrayCopyForeignCalls.UNSAFE_ARRAYCOPY, srcAddr, dstAddr, size);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void unsafeArraycopyStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Word var3);

    public static int counterModeAESCrypt(Word srcAddr, Word dstAddr, Word kPtr, Word cntPtr, int len, Word encCntPtr, Word used) {
        return HotSpotBackend.counterModeAESCrypt(COUNTERMODE_IMPL_CRYPT, srcAddr, dstAddr, kPtr, cntPtr, len, encCntPtr, used);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int counterModeAESCrypt(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Word var3, Word var4, int var5, Word var6, Word var7);

    public static int vectorizedMismatch(Word aAddr, Word bAddr, int length, int log2ArrayIndexScale) {
        return HotSpotBackend.vectorizedMismatchStub(VECTORIZED_MISMATCHED, aAddr, bAddr, length, log2ArrayIndexScale);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int vectorizedMismatchStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, int var3, int var4);

    public HotSpotBackend(HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(providers);
        this.runtime = runtime;
    }

    public HotSpotGraalRuntimeProvider getRuntime() {
        return this.runtime;
    }

    public void completeInitialization(HotSpotJVMCIRuntime jvmciRuntime, OptionValues options) {
    }

    private EconomicSet<Register> gatherDestroyedCallerRegisters(HotSpotLIRGenerationResult gen) {
        CallingConvention cc;
        AllocatableValue returnValue;
        LIR lir = gen.getLIR();
        final EconomicSet preservedRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        final EconomicSet destroyedRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        ValueConsumer defConsumer = new ValueConsumer(){

            @Override
            public void visitValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                Register reg;
                if (ValueUtil.isRegister((Value)value) && !preservedRegisters.contains((Object)(reg = ValueUtil.asRegister((Value)value)))) {
                    destroyedRegisters.add((Object)reg);
                }
            }
        };
        boolean sawSaveRegisters = false;
        for (AbstractBlockBase<?> block : lir.codeEmittingOrder()) {
            if (block == null) continue;
            StandardOp.SaveRegistersOp save = null;
            for (LIRInstruction op : lir.getLIRforBlock(block)) {
                if (op instanceof StandardOp.LabelOp) continue;
                if (op instanceof StandardOp.SaveRegistersOp) {
                    save = (StandardOp.SaveRegistersOp)op;
                    sawSaveRegisters = true;
                    preservedRegisters.addAll(save.getSaveableRegisters());
                    continue;
                }
                if (op instanceof StandardOp.RestoreRegistersOp) {
                    save = null;
                    preservedRegisters.clear();
                    continue;
                }
                op.visitEachTemp(defConsumer);
                op.visitEachOutput(defConsumer);
            }
            assert (save == null) : "missing RestoreRegistersOp";
        }
        if (sawSaveRegisters && (returnValue = (cc = gen.getCallingConvention()).getReturn()) != null && ValueUtil.isRegister((Value)returnValue)) {
            destroyedRegisters.add((Object)ValueUtil.asRegister((Value)returnValue));
        }
        return this.translateToCallerRegisters((EconomicSet<Register>)destroyedRegisters);
    }

    protected abstract EconomicSet<Register> translateToCallerRegisters(EconomicSet<Register> var1);

    protected void updateStub(Stub stub, HotSpotLIRGenerationResult gen, FrameMap frameMap) {
        EconomicSet<Register> destroyedRegisters = this.gatherDestroyedCallerRegisters(gen);
        EconomicMap<LIRFrameState, StandardOp.SaveRegistersOp> calleeSaveInfo = gen.getCalleeSaveInfo();
        if (stub.getLinkage().needsDebugInfo() && calleeSaveInfo.isEmpty()) {
            for (Register r : frameMap.getRegisterConfig().getCallerSaveRegisters()) {
                destroyedRegisters.add((Object)r);
            }
        }
        stub.initDestroyedCallerRegisters(destroyedRegisters);
        MapCursor cursor = calleeSaveInfo.getEntries();
        while (cursor.advance()) {
            StandardOp.SaveRegistersOp save = (StandardOp.SaveRegistersOp)cursor.getValue();
            save.remove(destroyedRegisters);
            if (cursor.getKey() == LIRFrameState.NO_STATE) continue;
            ((LIRFrameState)cursor.getKey()).debugInfo().setCalleeSaveInfo(save.getMap(frameMap));
        }
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    @Override
    public SuitesProvider getSuites() {
        return this.getProviders().getSuites();
    }

    protected void profileInstructions(LIR lir, CompilationResultBuilder crb) {
        if (Options.ASMInstructionProfiling.getValue(lir.getOptions()) != null) {
            HotSpotInstructionProfiling.countInstructions(lir, crb.asm);
        }
    }

    @Override
    public CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compResult, boolean isDefault, OptionValues options) {
        assert (!isDefault || compResult.getName() == null) : "a default nmethod should have a null name since it is associated with a Method*";
        HotSpotCompilationRequest compRequest = compilationRequest instanceof HotSpotCompilationRequest ? (HotSpotCompilationRequest)compilationRequest : null;
        return HotSpotCompiledCodeBuilder.createCompiledCode(this.getCodeCache(), method, compRequest, compResult, options);
    }

    @Override
    public CompilationIdentifier getCompilationIdentifier(ResolvedJavaMethod resolvedJavaMethod) {
        if (resolvedJavaMethod instanceof HotSpotResolvedJavaMethod) {
            HotSpotCompilationRequest request = new HotSpotCompilationRequest((HotSpotResolvedJavaMethod)resolvedJavaMethod, -1, 0L);
            return new HotSpotCompilationIdentifier(request);
        }
        return super.getCompilationIdentifier(resolvedJavaMethod);
    }

    public static class Options {
        @Option(help={"Use Graal arithmetic stubs instead of HotSpot stubs where possible"})
        public static final OptionKey<Boolean> GraalArithmeticStubs = new OptionKey<Boolean>(JavaVersionUtil.JAVA_SPEC >= 9);
        @Option(help={"Enables instruction profiling on assembler level. Valid values are a comma separated list of supported instructions. Compare with subclasses of Assembler.InstructionCounter."}, type=OptionType.Debug)
        public static final OptionKey<String> ASMInstructionProfiling = new OptionKey<Object>(null);
    }
}

