/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.nio.ByteBuffer;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SerializableConstant;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.asm.DataBuilder;

public class HotSpotDataBuilder
extends DataBuilder {
    private final TargetDescription target;

    public HotSpotDataBuilder(TargetDescription target) {
        this.target = target;
    }

    @Override
    public DataSection.Data createDataItem(Constant constant) {
        if (JavaConstant.isNull((Constant)constant)) {
            boolean compressed = HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(constant);
            int size = compressed ? 4 : this.target.wordSize;
            return DataSection.ZeroData.create(size, size);
        }
        if (constant instanceof VMConstant) {
            final VMConstant vmConstant = (VMConstant)constant;
            if (!(constant instanceof HotSpotConstant)) {
                throw new GraalError(String.valueOf(constant));
            }
            HotSpotConstant c = (HotSpotConstant)vmConstant;
            int size = c.isCompressed() ? 4 : this.target.wordSize;
            return new DataSection.Data(size, size){

                @Override
                protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
                    int position = buffer.position();
                    if (this.getSize() == 4) {
                        buffer.putInt(-559030611);
                    } else {
                        buffer.putLong(-2401018187971961171L);
                    }
                    patches.registerPatch(position, vmConstant);
                }
            };
        }
        if (constant instanceof SerializableConstant) {
            SerializableConstant s = (SerializableConstant)constant;
            return new DataSection.SerializableData(s);
        }
        throw new GraalError(String.valueOf(constant));
    }
}

