/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.TTYStreamProvider;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=TTYStreamProvider.class)
public class HotSpotTTYStreamProvider
implements TTYStreamProvider {
    @Override
    public PrintStream getStream() {
        return Options.LogFile.getStream();
    }

    private static class LogStreamOptionKey
    extends OptionKey<String> {
        LogStreamOptionKey() {
            super(null);
        }

        private static String makeFilename(String nameTemplate) {
            String name = nameTemplate;
            if (name.contains("%p")) {
                name = name.replaceAll("%p", GraalServices.getExecutionID());
            }
            if (name.contains("%t")) {
                name = name.replaceAll("%t", String.valueOf(System.currentTimeMillis()));
            }
            for (String subst : new String[]{"%o", "%e"}) {
                if (!name.contains(subst) || name.equals(subst)) continue;
                throw new IllegalArgumentException("LogFile substitution " + subst + " cannot be combined with any other characters");
            }
            return name;
        }

        public PrintStream getStream() {
            return new PrintStream(new DelayedOutputStream());
        }

        class DelayedOutputStream
        extends OutputStream {
            @NativeImageReinitialize
            private volatile OutputStream lazy;

            DelayedOutputStream() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OutputStream lazy() {
                if (this.lazy == null) {
                    DelayedOutputStream delayedOutputStream = this;
                    synchronized (delayedOutputStream) {
                        if (this.lazy == null) {
                            String nameTemplate = (String)LogStreamOptionKey.this.getValue(HotSpotGraalOptionValues.defaultOptions());
                            if (nameTemplate != null) {
                                String name;
                                switch (name = LogStreamOptionKey.makeFilename(nameTemplate)) {
                                    case "%o": {
                                        this.lazy = System.out;
                                        break;
                                    }
                                    case "%e": {
                                        this.lazy = System.err;
                                        break;
                                    }
                                    default: {
                                        try {
                                            boolean enableAutoflush = true;
                                            FileOutputStream result = new FileOutputStream(name);
                                            if (!Services.IS_IN_NATIVE_IMAGE) {
                                                this.printVMConfig(true, result);
                                            }
                                            this.lazy = result;
                                            break;
                                        }
                                        catch (FileNotFoundException e) {
                                            throw new RuntimeException("couldn't open file: " + name, e);
                                        }
                                    }
                                }
                                return this.lazy;
                            }
                            this.lazy = HotSpotJVMCIRuntime.runtime().getLogStream();
                            PrintStream ps = new PrintStream(this.lazy);
                            ps.printf("[Use -D%sLogFile=<path> to redirect Graal log output to a file.]%n", "graal.");
                            ps.flush();
                        }
                    }
                }
                return this.lazy;
            }

            @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="false positive on dead store to `ps`")
            private void printVMConfig(boolean enableAutoflush, FileOutputStream result) {
                String cmd;
                PrintStream ps = new PrintStream(result, enableAutoflush);
                List<String> inputArguments = GraalServices.getInputArguments();
                if (inputArguments != null) {
                    ps.println("VM Arguments: " + String.join((CharSequence)" ", inputArguments));
                }
                if ((cmd = (String)Services.getSavedProperties().get("sun.java.command")) != null) {
                    ps.println("sun.java.command=" + cmd);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.lazy().write(b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                this.lazy().write(b);
            }

            @Override
            public void flush() throws IOException {
                this.lazy().flush();
            }

            @Override
            public void close() throws IOException {
                this.lazy().close();
            }
        }
    }

    public static class Options {
        @Option(help={"File to which logging is sent.  A %p in the name will be replaced with a string identifying the process, usually the process id and %t will be replaced by System.currentTimeMillis().  Using %o as filename sends logging to System.out whereas %e sends logging to System.err."}, type=OptionType.Expert)
        public static final LogStreamOptionKey LogFile = new LogStreamOptionKey();
    }
}

