/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;

@Opcode(value="CALL_DIRECT")
final class AArch64HotSpotDirectVirtualCallOp
extends AArch64Call.DirectCallOp {
    public static final LIRInstructionClass<AArch64HotSpotDirectVirtualCallOp> TYPE = LIRInstructionClass.create(AArch64HotSpotDirectVirtualCallOp.class);
    private final CallTargetNode.InvokeKind invokeKind;
    private final GraalHotSpotVMConfig config;

    AArch64HotSpotDirectVirtualCallOp(ResolvedJavaMethod target, Value result, Value[] parameters, Value[] temps, LIRFrameState state, CallTargetNode.InvokeKind invokeKind, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends AArch64Call.DirectCallOp>)TYPE, target, result, parameters, temps, state);
        assert (invokeKind.isIndirect());
        this.invokeKind = invokeKind;
        this.config = config;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        crb.recordMark(this.invokeKind == CallTargetNode.InvokeKind.Virtual ? this.config.MARKID_INVOKEVIRTUAL : this.config.MARKID_INVOKEINTERFACE);
        masm.movNativeAddress(AArch64HotSpotRegisterConfig.inlineCacheRegister, this.config.nonOopBits);
        super.emitCode(crb, masm);
    }
}

