/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotEpilogueOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

@Opcode(value="JUMP_TO_EXCEPTION_HANDLER_IN_CALLER")
public class AArch64HotSpotJumpToExceptionHandlerInCallerOp
extends AArch64HotSpotEpilogueOp {
    public static final LIRInstructionClass<AArch64HotSpotJumpToExceptionHandlerInCallerOp> TYPE = LIRInstructionClass.create(AArch64HotSpotJumpToExceptionHandlerInCallerOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue handlerInCallerPc;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue exception;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue exceptionPc;
    private final Register thread;
    private final int isMethodHandleReturnOffset;

    public AArch64HotSpotJumpToExceptionHandlerInCallerOp(AllocatableValue handlerInCallerPc, AllocatableValue exception, AllocatableValue exceptionPc, int isMethodHandleReturnOffset, Register thread, GraalHotSpotVMConfig config) {
        super(TYPE, config);
        this.handlerInCallerPc = handlerInCallerPc;
        this.exception = exception;
        this.exceptionPc = exceptionPc;
        this.isMethodHandleReturnOffset = isMethodHandleReturnOffset;
        this.thread = thread;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        this.leaveFrame(crb, masm, false, false);
        if (JavaVersionUtil.JAVA_SPEC < 8) {
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                boolean allowOverwrite = false;
                AArch64Address address = masm.makeAddress(this.thread, this.isMethodHandleReturnOffset, scratch, 4, false);
                masm.ldr(32, scratch, address);
                Label noRestore = new Label();
                masm.cbz(32, scratch, noRestore);
                masm.mov(64, AArch64.sp, AArch64HotSpotRegisterConfig.fp);
                masm.bind(noRestore);
            }
        }
        masm.jmp(ValueUtil.asRegister((Value)this.handlerInCallerPc));
    }
}

