/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AMD64HotSpotMathIntrinsicOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotMathIntrinsicOp> TYPE = LIRInstructionClass.create(AMD64HotSpotMathIntrinsicOp.class);
    @Opcode
    private final IntrinsicOpcode opcode;
    @LIRInstruction.Def
    protected Value result;
    @LIRInstruction.Use
    protected Value input;

    public AMD64HotSpotMathIntrinsicOp(IntrinsicOpcode opcode, Value result, Value input) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        switch (this.opcode) {
            case LOG: {
                masm.flog(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), false);
                break;
            }
            case LOG10: {
                masm.flog(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), true);
                break;
            }
            case SIN: {
                masm.fsin(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE));
                break;
            }
            case COS: {
                masm.fcos(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE));
                break;
            }
            case TAN: {
                masm.ftan(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public static enum IntrinsicOpcode {
        SIN,
        COS,
        TAN,
        LOG,
        LOG10;

    }
}

