/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotEpilogueBlockEndOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="UNWIND")
final class AMD64HotSpotUnwindOp
extends AMD64HotSpotEpilogueBlockEndOp {
    public static final LIRInstructionClass<AMD64HotSpotUnwindOp> TYPE = LIRInstructionClass.create(AMD64HotSpotUnwindOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected RegisterValue exception;

    AMD64HotSpotUnwindOp(RegisterValue exception) {
        super((LIRInstructionClass<? extends AMD64HotSpotEpilogueBlockEndOp>)TYPE);
        this.exception = exception;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        this.leaveFrameAndRestoreRbp(crb, masm);
        ForeignCallLinkage linkage = crb.foreignCalls.lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention cc = linkage.getOutgoingCallingConvention();
        assert (cc.getArgumentCount() == 2);
        assert (this.exception.equals((Object)cc.getArgument(0)));
        Register returnAddress = ValueUtil.asRegister((Value)cc.getArgument(1));
        masm.movq(returnAddress, new AMD64Address(AMD64.rsp, 0));
        AMD64Call.directJmp(crb, masm, linkage);
    }
}

