/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VolatileCallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CRC32;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotAOTClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotAOTProfilingPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotJITClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotNodePlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotUnsafeSubstitutions;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.replacements.AESCryptSubstitutions;
import org.graalvm.compiler.hotspot.replacements.ArraysSupportSubstitutions;
import org.graalvm.compiler.hotspot.replacements.BigIntegerSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CRC32CSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CRC32Substitutions;
import org.graalvm.compiler.hotspot.replacements.CallSiteTargetNode;
import org.graalvm.compiler.hotspot.replacements.CipherBlockChainingSubstitutions;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.CounterModeSubstitutions;
import org.graalvm.compiler.hotspot.replacements.DigestBaseSubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotArraySubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotClassSubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.IdentityHashCodeNode;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneNode;
import org.graalvm.compiler.hotspot.replacements.ObjectSubstitutions;
import org.graalvm.compiler.hotspot.replacements.ReflectionGetCallerClassNode;
import org.graalvm.compiler.hotspot.replacements.ReflectionSubstitutions;
import org.graalvm.compiler.hotspot.replacements.SHA2Substitutions;
import org.graalvm.compiler.hotspot.replacements.SHA5Substitutions;
import org.graalvm.compiler.hotspot.replacements.SHASubstitutions;
import org.graalvm.compiler.hotspot.replacements.StringUTF16Substitutions;
import org.graalvm.compiler.hotspot.replacements.ThreadSubstitutions;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodeIntrinsicPluginFactory;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyNode;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public class HotSpotGraphBuilderPlugins {
    private static final LocationIdentity INSTANCE_KLASS_CONSTANTS = NamedLocationIdentity.immutable("InstanceKlass::_constants");
    private static final LocationIdentity CONSTANT_POOL_LENGTH = NamedLocationIdentity.immutable("ConstantPool::_length");
    public static final String reflectionClass;
    public static final String constantPoolClass;

    public static GraphBuilderConfiguration.Plugins create(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, final GraalHotSpotVMConfig config, final HotSpotWordTypes wordTypes, final MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, final SnippetReflectionProvider snippetReflection, final ForeignCallsProvider foreignCalls, final ReplacementsImpl replacements, final OptionValues options, TargetDescription target) {
        final HotSpotInvocationPlugins invocationPlugins = new HotSpotInvocationPlugins(graalRuntime, config, compilerConfiguration);
        final GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        final NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(metaAccess, snippetReflection, foreignCalls, wordTypes, target);
        HotSpotWordOperationPlugin wordOperationPlugin = new HotSpotWordOperationPlugin(snippetReflection, wordTypes);
        HotSpotNodePlugin nodePlugin = new HotSpotNodePlugin(wordOperationPlugin, config, wordTypes);
        plugins.appendTypePlugin(nodePlugin);
        plugins.appendNodePlugin(nodePlugin);
        if (!GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            plugins.appendNodePlugin(new MethodHandlePlugin(constantReflection.getMethodHandleAccess(), true));
        }
        plugins.appendInlineInvokePlugin(replacements);
        if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        if (GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            plugins.setClassInitializationPlugin(new HotSpotAOTClassInitializationPlugin());
            if (HotSpotAOTProfilingPlugin.Options.TieredAOT.getValue(options).booleanValue()) {
                plugins.setProfilingPlugin(new HotSpotAOTProfilingPlugin());
            }
        } else if (config.instanceKlassInitThreadOffset != -1) {
            plugins.setClassInitializationPlugin(new HotSpotJITClassInitializationPlugin());
        }
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                HotSpotGraphBuilderPlugins.registerObjectPlugins(invocationPlugins, options, config, replacements);
                HotSpotGraphBuilderPlugins.registerClassPlugins(plugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSystemPlugins(invocationPlugins, foreignCalls);
                HotSpotGraphBuilderPlugins.registerThreadPlugins(invocationPlugins, metaAccess, wordTypes, config, replacements);
                if (!GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
                    HotSpotGraphBuilderPlugins.registerCallSitePlugins(invocationPlugins);
                }
                HotSpotGraphBuilderPlugins.registerReflectionPlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerConstantPoolPlugins(invocationPlugins, wordTypes, config, replacements);
                HotSpotGraphBuilderPlugins.registerAESPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32CPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSHAPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerGHASHPlugins(invocationPlugins, config, metaAccess, foreignCalls);
                HotSpotGraphBuilderPlugins.registerCounterModePlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBase64Plugins(invocationPlugins, config, metaAccess, foreignCalls);
                HotSpotGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, config, replacements);
                StandardGraphBuilderPlugins.registerInvocationPlugins(metaAccess, snippetReflection, invocationPlugins, replacements, true, false);
                HotSpotGraphBuilderPlugins.registerArrayPlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins, config, replacements);
                for (NodeIntrinsicPluginFactory factory : GraalServices.load(NodeIntrinsicPluginFactory.class)) {
                    factory.registerPlugins(invocationPlugins, nodeIntrinsificationProvider);
                }
            }
        });
        return plugins;
    }

    private static void registerObjectPlugins(InvocationPlugins plugins, OptionValues options, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class), replacements);
        if (!GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            r.register1("clone", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.addPush(JavaKind.Object, new ObjectCloneNode(b.getInvokeKind(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), object));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
        r.registerMethodSubstitution(ObjectSubstitutions.class, "hashCode", new Type[]{InvocationPlugin.Receiver.class});
        if (config.inlineNotify()) {
            r.registerMethodSubstitution(ObjectSubstitutions.class, "notify", new Type[]{InvocationPlugin.Receiver.class});
        }
        if (config.inlineNotifyAll()) {
            r.registerMethodSubstitution(ObjectSubstitutions.class, "notifyAll", new Type[]{InvocationPlugin.Receiver.class});
        }
    }

    private static void registerClassPlugins(GraphBuilderConfiguration.Plugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)((Object)Class.class), replacements);
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "getModifiers", new Type[]{InvocationPlugin.Receiver.class});
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "isInterface", new Type[]{InvocationPlugin.Receiver.class});
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "isArray", new Type[]{InvocationPlugin.Receiver.class});
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "isPrimitive", new Type[]{InvocationPlugin.Receiver.class});
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "getSuperclass", new Type[]{InvocationPlugin.Receiver.class});
        if ((Integer)config.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop", Integer.MAX_VALUE) != Integer.MAX_VALUE) {
            r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "getComponentType", new Type[]{InvocationPlugin.Receiver.class});
        }
    }

    private static void registerCallSitePlugins(InvocationPlugins plugins) {
        InvocationPlugin plugin = new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode callSite = receiver.get();
                ConstantNode folded = CallSiteTargetNode.tryFold(GraphUtil.originalValue(callSite, true), b.getMetaAccess(), b.getAssumptions());
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    b.addPush(JavaKind.Object, new CallSiteTargetNode(b.getInvokeKind(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), callSite));
                }
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        };
        plugins.register(plugin, (Type)((Object)ConstantCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
        plugins.register(plugin, (Type)((Object)MutableCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
        plugins.register(plugin, (Type)((Object)VolatileCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, reflectionClass, replacements);
        r.register0("getCallerClass", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new ReflectionGetCallerClassNode(b.getInvokeKind(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), new ValueNode[0]));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.registerMethodSubstitution(ReflectionSubstitutions.class, "getClassAccessFlags", new Type[]{Class.class});
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = JavaVersionUtil.JAVA_SPEC <= 8 ? new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class), replacements) : new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        String substituteMethodName = config.doingUnsafeAccessOffset != Integer.MAX_VALUE ? "copyMemoryGuarded" : "copyMemory";
        r.registerMethodSubstitution(HotSpotUnsafeSubstitutions.class, HotSpotUnsafeSubstitutions.copyMemoryName, substituteMethodName, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE});
    }

    private static ValueNode getMetaspaceConstantPool(GraphBuilderContext b, ValueNode constantPoolOop, WordTypes wordTypes, GraalHotSpotVMConfig config) {
        ValueNode value = b.nullCheckedValue(constantPoolOop, DeoptimizationAction.None);
        ValueNode klass = b.add(ClassGetHubNode.create(value, b.getMetaAccess(), b.getConstantReflection(), false));
        boolean notCompressible = false;
        AddressNode constantsAddress = b.add(new OffsetAddressNode(klass, b.add(ConstantNode.forLong(config.instanceKlassConstantsOffset))));
        return WordOperationPlugin.readOp(b, wordTypes.getWordKind(), constantsAddress, INSTANCE_KLASS_CONSTANTS, HeapAccess.BarrierType.NONE, notCompressible);
    }

    private static boolean readMetaspaceConstantPoolElement(GraphBuilderContext b, ValueNode constantPoolOop, ValueNode index, JavaKind elementKind, WordTypes wordTypes, GraalHotSpotVMConfig config) {
        ValueNode constants = HotSpotGraphBuilderPlugins.getMetaspaceConstantPool(b, constantPoolOop, wordTypes, config);
        int shift = CodeUtil.log2((int)wordTypes.getWordKind().getByteCount());
        LeftShiftNode scaledIndex = b.add(new LeftShiftNode(IntegerConvertNode.convert(index, StampFactory.forKind(JavaKind.Long), NodeView.DEFAULT), b.add(ConstantNode.forInt(shift))));
        AddNode offset = b.add(new AddNode(scaledIndex, b.add(ConstantNode.forLong(config.constantPoolSize))));
        AddressNode elementAddress = b.add(new OffsetAddressNode(constants, offset));
        boolean notCompressible = false;
        ValueNode elementValue = WordOperationPlugin.readOp(b, elementKind, elementAddress, NamedLocationIdentity.getArrayLocation(elementKind), HeapAccess.BarrierType.NONE, notCompressible);
        b.addPush(elementKind, elementValue);
        return true;
    }

    private static void registerConstantPoolPlugins(InvocationPlugins plugins, final WordTypes wordTypes, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, constantPoolClass, replacements);
        r.register2("getSize0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode constantPoolOop) {
                boolean notCompressible = false;
                ValueNode constants = HotSpotGraphBuilderPlugins.getMetaspaceConstantPool(b, constantPoolOop, wordTypes, config);
                AddressNode lengthAddress = b.add(new OffsetAddressNode(constants, b.add(ConstantNode.forLong(config.constantPoolLengthOffset))));
                ValueNode length = WordOperationPlugin.readOp(b, JavaKind.Int, lengthAddress, CONSTANT_POOL_LENGTH, HeapAccess.BarrierType.NONE, notCompressible);
                b.addPush(JavaKind.Int, length);
                return true;
            }
        });
        r.register3("getIntAt0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode constantPoolOop, ValueNode index) {
                return HotSpotGraphBuilderPlugins.readMetaspaceConstantPoolElement(b, constantPoolOop, index, JavaKind.Int, wordTypes, config);
            }
        });
        r.register3("getLongAt0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode constantPoolOop, ValueNode index) {
                return HotSpotGraphBuilderPlugins.readMetaspaceConstantPoolElement(b, constantPoolOop, index, JavaKind.Long, wordTypes, config);
            }
        });
        r.register3("getFloatAt0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode constantPoolOop, ValueNode index) {
                return HotSpotGraphBuilderPlugins.readMetaspaceConstantPoolElement(b, constantPoolOop, index, JavaKind.Float, wordTypes, config);
            }
        });
        r.register3("getDoubleAt0", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode constantPoolOop, ValueNode index) {
                return HotSpotGraphBuilderPlugins.readMetaspaceConstantPoolElement(b, constantPoolOop, index, JavaKind.Double, wordTypes, config);
            }
        });
    }

    private static void registerSystemPlugins(InvocationPlugins plugins, ForeignCallsProvider foreignCalls) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)System.class));
        r.register0("currentTimeMillis", new ForeignCallPlugin(foreignCalls, HotSpotHostForeignCallsProvider.JAVA_TIME_MILLIS));
        r.register0("nanoTime", new ForeignCallPlugin(foreignCalls, HotSpotHostForeignCallsProvider.JAVA_TIME_NANOS));
        r.register1("identityHashCode", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, new IdentityHashCodeNode(object));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.register5("arraycopy", (Type)((Object)Object.class), Integer.TYPE, (Type)((Object)Object.class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcPos, ValueNode dst, ValueNode dstPos, ValueNode length) {
                b.add(new ArrayCopyNode(b.bci(), src, srcPos, dst, dstPos, length));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.setAllowOverwrite(true);
        r.registerMethodSubstitution(HotSpotArraySubstitutions.class, "newInstance", new Type[]{Class.class, Integer.TYPE});
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
            utf16r.registerMethodSubstitution(StringUTF16Substitutions.class, "toBytes", new Type[]{char[].class, Integer.TYPE, Integer.TYPE});
            utf16r.registerMethodSubstitution(StringUTF16Substitutions.class, "getChars", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE});
        }
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, final MetaAccessProvider metaAccess, final WordTypes wordTypes, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register0("currentThread", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                CurrentJavaThreadNode thread = b.add(new CurrentJavaThreadNode(wordTypes.getWordKind()));
                ConstantNode offset = b.add(ConstantNode.forLong(config.threadObjectOffset));
                AddressNode address = b.add(new OffsetAddressNode(thread, offset));
                ObjectStamp stamp = StampFactory.objectNonNull(TypeReference.create(b.getAssumptions(), metaAccess.lookupJavaType(Thread.class)));
                b.addPush(JavaKind.Object, new ReadNode(address, HotSpotReplacementsUtil.JAVA_THREAD_THREAD_OBJECT_LOCATION, stamp, HeapAccess.BarrierType.NONE));
                return true;
            }
        });
        r.registerMethodSubstitution(ThreadSubstitutions.class, "isInterrupted", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE});
    }

    public static String lookupIntrinsicName(GraalHotSpotVMConfig config, String className, String name1, String name2) {
        boolean foundName1 = false;
        boolean foundName2 = false;
        String name = name1;
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass)) continue;
            if (name1.equals(intrinsic.name)) {
                foundName1 = true;
                continue;
            }
            if (!name2.equals(intrinsic.name)) continue;
            foundName2 = true;
            name = name2;
        }
        if (foundName1 != foundName2) {
            return name;
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean isIntrinsicName(GraalHotSpotVMConfig config, String className, String name) {
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass) || !name.equals(intrinsic.name)) continue;
            return true;
        }
        return false;
    }

    private static void registerAESPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (config.useAESIntrinsics) {
            assert (config.aescryptEncryptBlockStub != 0L);
            assert (config.aescryptDecryptBlockStub != 0L);
            assert (config.cipherBlockChainingEncryptAESCryptStub != 0L);
            assert (config.cipherBlockChainingDecryptAESCryptStub != 0L);
            String arch = config.osArch;
            String decryptSuffix = arch.equals("sparc") ? "WithOriginalKey" : "";
            String cbcEncryptName = HotSpotGraphBuilderPlugins.lookupIntrinsicName(config, "com/sun/crypto/provider/CipherBlockChaining", "implEncrypt", "encrypt");
            String cbcDecryptName = HotSpotGraphBuilderPlugins.lookupIntrinsicName(config, "com/sun/crypto/provider/CipherBlockChaining", "implDecrypt", "decrypt");
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
            r.registerMethodSubstitution(CipherBlockChainingSubstitutions.class, cbcEncryptName, new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
            r.registerMethodSubstitution(CipherBlockChainingSubstitutions.class, cbcDecryptName, cbcDecryptName + decryptSuffix, new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
            String aesEncryptName = HotSpotGraphBuilderPlugins.lookupIntrinsicName(config, "com/sun/crypto/provider/AESCrypt", "implEncryptBlock", "encryptBlock");
            String aesDecryptName = HotSpotGraphBuilderPlugins.lookupIntrinsicName(config, "com/sun/crypto/provider/AESCrypt", "implDecryptBlock", "decryptBlock");
            r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.AESCrypt", replacements);
            r.registerMethodSubstitution(AESCryptSubstitutions.class, aesEncryptName, new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE});
            r.registerMethodSubstitution(AESCryptSubstitutions.class, aesDecryptName, aesDecryptName + decryptSuffix, new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE});
        }
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        assert (!config.useMultiplyToLenIntrinsic() || config.multiplyToLen != 0L);
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            r.registerConditionalMethodSubstitution(config.useMultiplyToLenIntrinsic(), BigIntegerSubstitutions.class, "multiplyToLen", "multiplyToLenStatic", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class});
        } else {
            r.registerConditionalMethodSubstitution(config.useMultiplyToLenIntrinsic(), BigIntegerSubstitutions.class, "implMultiplyToLen", "multiplyToLenStatic", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class});
        }
        r.registerConditionalMethodSubstitution(config.useMulAddIntrinsic(), BigIntegerSubstitutions.class, "implMulAdd", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        r.registerConditionalMethodSubstitution(config.useMontgomeryMultiplyIntrinsic(), BigIntegerSubstitutions.class, "implMontgomeryMultiply", new Type[]{int[].class, int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class});
        r.registerConditionalMethodSubstitution(config.useMontgomerySquareIntrinsic(), BigIntegerSubstitutions.class, "implMontgomerySquare", new Type[]{int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class});
        r.registerConditionalMethodSubstitution(config.useSquareToLenIntrinsic(), BigIntegerSubstitutions.class, "implSquareToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE});
    }

    private static void registerSHAPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r;
        boolean useSha1 = config.useSHA1Intrinsics();
        boolean useSha256 = config.useSHA256Intrinsics();
        boolean useSha512 = config.useSHA512Intrinsics();
        if (HotSpotGraphBuilderPlugins.isIntrinsicName(config, "sun/security/provider/DigestBase", "implCompressMultiBlock0") && (useSha1 || useSha256 || useSha512)) {
            InvocationPlugins.Registration r2 = new InvocationPlugins.Registration(plugins, "sun.security.provider.DigestBase", replacements);
            r2.registerMethodSubstitution(DigestBaseSubstitutions.class, "implCompressMultiBlock0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE});
        }
        String implCompressName = HotSpotGraphBuilderPlugins.lookupIntrinsicName(config, "sun/security/provider/SHA", "implCompress", "implCompress0");
        if (useSha1) {
            assert (config.sha1ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA", replacements);
            r.registerMethodSubstitution(SHASubstitutions.class, implCompressName, "implCompress0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE});
        }
        if (useSha256) {
            assert (config.sha256ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA2", replacements);
            r.registerMethodSubstitution(SHA2Substitutions.class, implCompressName, "implCompress0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE});
        }
        if (useSha512) {
            assert (config.sha512ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA5", replacements);
            r.registerMethodSubstitution(SHA5Substitutions.class, implCompressName, "implCompress0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE});
        }
    }

    private static void registerGHASHPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess, final ForeignCallsProvider foreignCalls) {
        if (config.useGHASHIntrinsics()) {
            assert (config.ghashProcessBlocks != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GHASH");
            r.register5("processBlocks", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)long[].class), (Type)((Object)long[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode data, ValueNode inOffset, ValueNode blocks, ValueNode state, ValueNode hashSubkey) {
                    int longArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Long);
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ValueNode dataOffset = AddNode.create(ConstantNode.forInt(byteArrayBaseOffset), inOffset, NodeView.DEFAULT);
                    ComputeObjectAddressNode dataAddress = b.add(new ComputeObjectAddressNode(data, dataOffset));
                    ComputeObjectAddressNode stateAddress = b.add(new ComputeObjectAddressNode(state, ConstantNode.forInt(longArrayBaseOffset)));
                    ComputeObjectAddressNode hashSubkeyAddress = b.add(new ComputeObjectAddressNode(hashSubkey, ConstantNode.forInt(longArrayBaseOffset)));
                    b.add(new ForeignCallNode(foreignCalls, HotSpotBackend.GHASH_PROCESS_BLOCKS, stateAddress, hashSubkeyAddress, dataAddress, blocks));
                    return true;
                }
            });
        }
    }

    private static void registerCounterModePlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            assert (!config.useAESCTRIntrinsics || config.counterModeAESCrypt != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
            r.registerConditionalMethodSubstitution(config.useAESCTRIntrinsics, CounterModeSubstitutions.class, "implCrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }
    }

    private static void registerBase64Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess, final ForeignCallsProvider foreignCalls) {
        if (config.useBase64Intrinsics()) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Encoder");
            r.register7("encodeBlock", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Boolean.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                    ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                    b.add(new ForeignCallNode(foreignCalls, HotSpotBackend.BASE64_ENCODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                    return true;
                }
            });
        }
    }

    private static void registerCRC32Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)CRC32.class), replacements);
        r.registerConditionalMethodSubstitution(config.useCRC32Intrinsics, CRC32Substitutions.class, "update", Integer.TYPE, Integer.TYPE);
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            r.registerConditionalMethodSubstitution(config.useCRC32Intrinsics, CRC32Substitutions.class, "updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
            r.registerConditionalMethodSubstitution(config.useCRC32Intrinsics, CRC32Substitutions.class, "updateByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
        } else {
            r.registerConditionalMethodSubstitution(config.useCRC32Intrinsics, CRC32Substitutions.class, "updateBytes0", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
            r.registerConditionalMethodSubstitution(config.useCRC32Intrinsics, CRC32Substitutions.class, "updateByteBuffer0", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
    }

    private static void registerCRC32CPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.CRC32C", replacements);
            r.registerConditionalMethodSubstitution(config.useCRC32CIntrinsics, CRC32CSubstitutions.class, "updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
            r.registerConditionalMethodSubstitution(config.useCRC32CIntrinsics, CRC32CSubstitutions.class, "updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
            r.registerConditionalMethodSubstitution(config.useVectorizedMismatchIntrinsic, ArraysSupportSubstitutions.class, "vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE});
        }
    }

    static {
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            reflectionClass = "sun.reflect.Reflection";
            constantPoolClass = "sun.reflect.ConstantPool";
        } else {
            reflectionClass = "jdk.internal.reflect.Reflection";
            constantPoolClass = "jdk.internal.reflect.ConstantPool";
        }
    }
}

