/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.EnumMap;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilerRuntimeHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.AssertionSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotG1WriteBarrierSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.Log;
import org.graalvm.compiler.hotspot.replacements.MonitorSnippets;
import org.graalvm.compiler.hotspot.replacements.NewObjectSnippets;
import org.graalvm.compiler.hotspot.stubs.ArrayStoreExceptionStub;
import org.graalvm.compiler.hotspot.stubs.ClassCastExceptionStub;
import org.graalvm.compiler.hotspot.stubs.CreateExceptionStub;
import org.graalvm.compiler.hotspot.stubs.DivisionByZeroExceptionStub;
import org.graalvm.compiler.hotspot.stubs.ExceptionHandlerStub;
import org.graalvm.compiler.hotspot.stubs.IntegerExactOverflowExceptionStub;
import org.graalvm.compiler.hotspot.stubs.LongExactOverflowExceptionStub;
import org.graalvm.compiler.hotspot.stubs.NullPointerExceptionStub;
import org.graalvm.compiler.hotspot.stubs.OutOfBoundsExceptionStub;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.hotspot.stubs.StubUtil;
import org.graalvm.compiler.hotspot.stubs.UnwindExceptionToCallerStub;
import org.graalvm.compiler.hotspot.stubs.VerifyOopStub;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.java.ForeignCallDescriptors;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public abstract class HotSpotHostForeignCallsProvider
extends HotSpotForeignCallsProviderImpl
implements ArrayCopyForeignCalls {
    public static final ForeignCallDescriptor JAVA_TIME_MILLIS = new ForeignCallDescriptor("javaTimeMillis", Long.TYPE, new Class[0]);
    public static final ForeignCallDescriptor JAVA_TIME_NANOS = new ForeignCallDescriptor("javaTimeNanos", Long.TYPE, new Class[0]);
    public static final ForeignCallDescriptor NOTIFY = new ForeignCallDescriptor("object_notify", Boolean.TYPE, Object.class);
    public static final ForeignCallDescriptor NOTIFY_ALL = new ForeignCallDescriptor("object_notifyAll", Boolean.TYPE, Object.class);
    private static final EnumMap<JavaKind, ForeignCallDescriptor>[][] arraycopyDescriptors = new EnumMap[2][2];
    private static final EnumMap<JavaKind, ForeignCallDescriptor>[][] arraycopyDescriptorsKillAny = new EnumMap[2][2];
    private static final ForeignCallDescriptor[][] uninitObjectArraycopyDescriptors = new ForeignCallDescriptor[2][2];
    private static final ForeignCallDescriptor[] checkcastArraycopyDescriptors = new ForeignCallDescriptor[2];

    public HotSpotHostForeignCallsProvider(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes) {
        super(jvmciRuntime, runtime, metaAccess, codeCache, wordTypes);
    }

    protected static void link(Stub stub) {
        stub.getLinkage().setCompiledStub(stub);
    }

    @Override
    public ForeignCallDescriptor lookupCheckcastArraycopyDescriptor(boolean uninit) {
        return checkcastArraycopyDescriptors[uninit ? 1 : 0];
    }

    @Override
    public ForeignCallDescriptor lookupArraycopyDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, boolean killAny) {
        if (uninit) {
            assert (kind == JavaKind.Object);
            assert (!killAny) : "unsupported";
            return uninitObjectArraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0];
        }
        if (killAny) {
            return arraycopyDescriptorsKillAny[aligned ? 1 : 0][disjoint ? 1 : 0].get(kind);
        }
        return arraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0].get(kind);
    }

    private void registerArraycopyDescriptor(EconomicMap<Long, ForeignCallDescriptor> descMap, JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, boolean killAny, long routine) {
        ForeignCallDescriptor desc = (ForeignCallDescriptor)descMap.get((Object)routine);
        if (desc == null) {
            desc = this.buildDescriptor(kind, aligned, disjoint, uninit, killAny, routine);
            descMap.put((Object)routine, (Object)desc);
        }
        if (uninit) {
            assert (kind == JavaKind.Object);
            HotSpotHostForeignCallsProvider.uninitObjectArraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0] = desc;
        } else if (killAny) {
            arraycopyDescriptorsKillAny[aligned ? 1 : 0][disjoint ? 1 : 0].put(kind, desc);
        } else {
            arraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0].put(kind, desc);
        }
    }

    private ForeignCallDescriptor buildDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, boolean killAny, long routine) {
        assert (!uninit || kind == JavaKind.Object);
        String name = kind + (aligned ? "Aligned" : "") + (disjoint ? "Disjoint" : "") + (uninit ? "Uninit" : "") + "Arraycopy" + (killAny ? "KillAny" : "");
        ForeignCallDescriptor desc = new ForeignCallDescriptor(name, Void.TYPE, Word.class, Word.class, Word.class);
        LocationIdentity killed = killAny ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(kind);
        this.registerForeignCall(desc, routine, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, killed);
        return desc;
    }

    private void registerCheckcastArraycopyDescriptor(boolean uninit, long routine) {
        String name = "Object" + (uninit ? "Uninit" : "") + "CheckcastArraycopy";
        ForeignCallDescriptor desc = new ForeignCallDescriptor(name, Integer.TYPE, Word.class, Word.class, Word.class, Word.class, Word.class);
        LocationIdentity killed = NamedLocationIdentity.any();
        this.registerForeignCall(desc, routine, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, killed);
        HotSpotHostForeignCallsProvider.checkcastArraycopyDescriptors[uninit ? 1 : 0] = desc;
    }

    private void registerArrayCopy(JavaKind kind, long routine, long alignedRoutine, long disjointRoutine, long alignedDisjointRoutine) {
        this.registerArrayCopy(kind, routine, alignedRoutine, disjointRoutine, alignedDisjointRoutine, false);
    }

    private void registerArrayCopy(JavaKind kind, long routine, long alignedRoutine, long disjointRoutine, long alignedDisjointRoutine, boolean uninit) {
        EconomicMap descMap = EconomicMap.create();
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, false, false, uninit, false, routine);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, true, false, uninit, false, alignedRoutine);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, false, true, uninit, false, disjointRoutine);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, true, true, uninit, false, alignedDisjointRoutine);
        if (!uninit) {
            EconomicMap killAnyDescMap = EconomicMap.create();
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, false, false, uninit, true, routine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, true, false, uninit, true, alignedRoutine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, false, true, uninit, true, disjointRoutine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, true, true, uninit, true, alignedDisjointRoutine);
        }
    }

    public void initialize(HotSpotProviders providers, OptionValues options) {
        GraalHotSpotVMConfig c;
        block24: {
            c = this.runtime.getVMConfig();
            this.registerForeignCall(HotSpotHostBackend.DEOPTIMIZATION_HANDLER, c.handleDeoptStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerForeignCall(HotSpotHostBackend.UNCOMMON_TRAP_HANDLER, c.uncommonTrapStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerForeignCall(HotSpotBackend.IC_MISS_HANDLER, c.inlineCacheMissStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            if (c.enableStackReservedZoneAddress != 0L) {
                assert (c.throwDelayedStackOverflowErrorEntry != 0L) : "both must exist";
                this.registerForeignCall(HotSpotHostBackend.ENABLE_STACK_RESERVED_ZONE, c.enableStackReservedZoneAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
                this.registerForeignCall(HotSpotHostBackend.THROW_DELAYED_STACKOVERFLOW_ERROR, c.throwDelayedStackOverflowErrorEntry, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            }
            this.registerForeignCall(JAVA_TIME_MILLIS, c.javaTimeMillisAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerForeignCall(JAVA_TIME_NANOS, c.javaTimeNanosAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerMathStubs(c, providers, options);
            this.registerForeignCall(Backend.ARITHMETIC_FREM, c.fremAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerForeignCall(Backend.ARITHMETIC_DREM, c.dremAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerForeignCall(LOAD_AND_CLEAR_EXCEPTION, c.loadAndClearExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
            this.registerForeignCall(ExceptionHandlerStub.EXCEPTION_HANDLER_FOR_PC, c.exceptionHandlerForPcAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
            this.registerForeignCall(UnwindExceptionToCallerStub.EXCEPTION_HANDLER_FOR_RETURN_ADDRESS, c.exceptionHandlerForReturnAddressAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
            CreateExceptionStub.registerForeignCalls(c, this);
            this.registerForeignCall(StubUtil.VM_MESSAGE_C, c.vmMessageAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.registerForeignCall(AssertionSnippets.ASSERTION_VM_MESSAGE_C, c.vmMessageAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, HotSpotBackend.NEW_INSTANCE, c.newInstanceAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
            this.linkForeignCall(options, providers, HotSpotBackend.NEW_ARRAY, c.newArrayAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
            this.linkForeignCall(options, providers, HotSpotBackend.NEW_MULTI_ARRAY, c.newMultiArrayAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
            this.linkForeignCall(options, providers, NewObjectSnippets.DYNAMIC_NEW_INSTANCE, c.dynamicNewInstanceAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, new LocationIdentity[0]);
            if (c.areNullAllocationStubsAvailable()) {
                this.linkForeignCall(options, providers, HotSpotBackend.NEW_INSTANCE_OR_NULL, c.newInstanceOrNullAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
                this.linkForeignCall(options, providers, HotSpotBackend.NEW_ARRAY_OR_NULL, c.newArrayOrNullAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
                this.linkForeignCall(options, providers, HotSpotBackend.NEW_MULTI_ARRAY_OR_NULL, c.newMultiArrayOrNullAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
                this.linkForeignCall(options, providers, NewObjectSnippets.DYNAMIC_NEW_INSTANCE_OR_NULL, c.dynamicNewInstanceOrNullAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, new LocationIdentity[0]);
            }
            HotSpotHostForeignCallsProvider.link(new ExceptionHandlerStub(options, providers, (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)HotSpotBackend.EXCEPTION_HANDLER)));
            HotSpotHostForeignCallsProvider.link(new UnwindExceptionToCallerStub(options, providers, this.registerStubCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new VerifyOopStub(options, providers, this.registerStubCall(VERIFY_OOP, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, NO_LOCATIONS)));
            EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> exceptionRuntimeCalls = DefaultHotSpotLoweringProvider.RuntimeCalls.runtimeCalls;
            HotSpotHostForeignCallsProvider.link(new ArrayStoreExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new ClassCastExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new NullPointerExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new OutOfBoundsExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new DivisionByZeroExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new IntegerExactOverflowExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new LongExactOverflowExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW), HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            this.linkForeignCall(options, providers, IDENTITY_HASHCODE, c.identityHashCodeAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, HotSpotReplacementsUtil.MARK_WORD_LOCATION);
            this.linkForeignCall(options, providers, ForeignCallDescriptors.REGISTER_FINALIZER, c.registerFinalizerAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
            this.linkForeignCall(options, providers, MonitorSnippets.MONITORENTER, c.monitorenterAddress, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
            this.linkForeignCall(options, providers, MonitorSnippets.MONITOREXIT, c.monitorexitAddress, true, HotSpotForeignCallLinkage.Transition.STACK_INSPECTABLE_LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
            this.linkForeignCall(options, providers, NOTIFY, c.notifyAddress, true, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
            this.linkForeignCall(options, providers, NOTIFY_ALL, c.notifyAllAddress, true, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
            this.linkForeignCall(options, providers, Log.LOG_PRINTF, c.logPrintfAddress, true, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, Log.LOG_OBJECT, c.logObjectAddress, true, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, Log.LOG_PRIMITIVE, c.logPrimitiveAddress, true, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, HotSpotBackend.VM_ERROR, c.vmErrorAddress, true, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, OSR_MIGRATION_END, c.osrMigrationEndAddress, false, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, HotSpotG1WriteBarrierSnippets.G1WBPRECALL, c.writeBarrierPreAddress, true, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, HotSpotG1WriteBarrierSnippets.G1WBPOSTCALL, c.writeBarrierPostAddress, true, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            this.linkForeignCall(options, providers, HotSpotG1WriteBarrierSnippets.VALIDATE_OBJECT, c.validateObject, true, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            if (GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
                this.registerForeignCall(HotSpotBackend.WRONG_METHOD_HANDLER, c.handleWrongMethodStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
                CompilerRuntimeHotSpotVMConfig cr = new CompilerRuntimeHotSpotVMConfig(HotSpotJVMCIRuntime.runtime().getConfigStore());
                this.linkForeignCall(options, providers, HotSpotBackend.RESOLVE_STRING_BY_SYMBOL, cr.resolveStringBySymbol, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
                this.linkForeignCall(options, providers, HotSpotBackend.RESOLVE_DYNAMIC_INVOKE, cr.resolveDynamicInvoke, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
                this.linkForeignCall(options, providers, HotSpotBackend.RESOLVE_KLASS_BY_SYMBOL, cr.resolveKlassBySymbol, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
                this.linkForeignCall(options, providers, HotSpotBackend.RESOLVE_METHOD_BY_SYMBOL_AND_LOAD_COUNTERS, cr.resolveMethodBySymbolAndLoadCounters, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
                this.linkForeignCall(options, providers, HotSpotBackend.INITIALIZE_KLASS_BY_SYMBOL, cr.initializeKlassBySymbol, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
                this.linkForeignCall(options, providers, HotSpotBackend.INVOCATION_EVENT, cr.invocationEvent, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
                this.linkForeignCall(options, providers, HotSpotBackend.BACKEDGE_EVENT, cr.backedgeEvent, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
            }
            this.linkForeignCall(options, providers, TEST_DEOPTIMIZE_CALL_INT, c.testDeoptimizeCallInt, true, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
            this.registerArrayCopy(JavaKind.Byte, c.jbyteArraycopy, c.jbyteAlignedArraycopy, c.jbyteDisjointArraycopy, c.jbyteAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Boolean, c.jbyteArraycopy, c.jbyteAlignedArraycopy, c.jbyteDisjointArraycopy, c.jbyteAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Char, c.jshortArraycopy, c.jshortAlignedArraycopy, c.jshortDisjointArraycopy, c.jshortAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Short, c.jshortArraycopy, c.jshortAlignedArraycopy, c.jshortDisjointArraycopy, c.jshortAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Int, c.jintArraycopy, c.jintAlignedArraycopy, c.jintDisjointArraycopy, c.jintAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Float, c.jintArraycopy, c.jintAlignedArraycopy, c.jintDisjointArraycopy, c.jintAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Long, c.jlongArraycopy, c.jlongAlignedArraycopy, c.jlongDisjointArraycopy, c.jlongAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Double, c.jlongArraycopy, c.jlongAlignedArraycopy, c.jlongDisjointArraycopy, c.jlongAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Object, c.oopArraycopy, c.oopAlignedArraycopy, c.oopDisjointArraycopy, c.oopAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Object, c.oopArraycopyUninit, c.oopAlignedArraycopyUninit, c.oopDisjointArraycopyUninit, c.oopAlignedDisjointArraycopyUninit, true);
            this.registerCheckcastArraycopyDescriptor(true, c.checkcastArraycopyUninit);
            this.registerCheckcastArraycopyDescriptor(false, c.checkcastArraycopy);
            this.registerForeignCall(GENERIC_ARRAYCOPY, c.genericArraycopy, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            this.registerForeignCall(UNSAFE_ARRAYCOPY, c.unsafeArraycopy, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            if (c.useMultiplyToLenIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MULTIPLY_TO_LEN, c.multiplyToLen, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int));
            }
            if (c.useSHA1Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.SHA_IMPL_COMPRESS, c.sha1ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
                this.registerForeignCall(HotSpotBackend.SHA_IMPL_COMPRESS_MB, c.sha1ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            }
            if (c.useSHA256Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.SHA2_IMPL_COMPRESS, c.sha256ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
                this.registerForeignCall(HotSpotBackend.SHA2_IMPL_COMPRESS_MB, c.sha256ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            }
            if (c.useSHA512Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.SHA5_IMPL_COMPRESS, c.sha512ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
                this.registerForeignCall(HotSpotBackend.SHA5_IMPL_COMPRESS_MB, c.sha512ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            }
            if (c.useGHASHIntrinsics()) {
                this.registerForeignCall(HotSpotBackend.GHASH_PROCESS_BLOCKS, c.ghashProcessBlocks, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            }
            if (c.useBase64Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.BASE64_ENCODE_BLOCK, c.base64EncodeBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
            }
            if (c.useMulAddIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MUL_ADD, c.mulAdd, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int));
            }
            if (c.useMontgomeryMultiplyIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MONTGOMERY_MULTIPLY, c.montgomeryMultiply, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int));
            }
            if (c.useMontgomerySquareIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MONTGOMERY_SQUARE, c.montgomerySquare, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int));
            }
            if (c.useSquareToLenIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.SQUARE_TO_LEN, c.squareToLen, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Int));
            }
            if (c.useAESIntrinsics) {
                block23: {
                    try {
                        this.registerForeignCall(HotSpotBackend.ENCRYPT_BLOCK, c.aescryptEncryptBlockStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
                        this.registerForeignCall(HotSpotBackend.DECRYPT_BLOCK, c.aescryptDecryptBlockStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
                        this.registerForeignCall(HotSpotBackend.DECRYPT_BLOCK_WITH_ORIGINAL_KEY, c.aescryptDecryptBlockStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
                    }
                    catch (GraalError e) {
                        if (e.getCause() instanceof ClassNotFoundException) break block23;
                        throw e;
                    }
                }
                try {
                    this.registerForeignCall(HotSpotBackend.ENCRYPT, c.cipherBlockChainingEncryptAESCryptStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
                    this.registerForeignCall(HotSpotBackend.DECRYPT, c.cipherBlockChainingDecryptAESCryptStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
                    this.registerForeignCall(HotSpotBackend.DECRYPT_WITH_ORIGINAL_KEY, c.cipherBlockChainingDecryptAESCryptStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
                }
                catch (GraalError e) {
                    if (e.getCause() instanceof ClassNotFoundException) break block24;
                    throw e;
                }
            }
        }
        if (c.useAESCTRIntrinsics) {
            assert (c.counterModeAESCrypt != 0L);
            this.registerForeignCall(HotSpotBackend.COUNTERMODE_IMPL_CRYPT, c.counterModeAESCrypt, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
        }
        if (c.useVectorizedMismatchIntrinsic) {
            assert (c.vectorizedMismatch != 0L);
            this.registerForeignCall(HotSpotBackend.VECTORIZED_MISMATCHED, c.vectorizedMismatch, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any());
        }
    }

    public HotSpotForeignCallLinkage getForeignCall(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls != null) : descriptor;
        return (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor);
    }

    protected void registerMathStubs(GraalHotSpotVMConfig hotSpotVMConfig, HotSpotProviders providers, OptionValues options) {
        this.registerForeignCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallDescriptor, hotSpotVMConfig.arithmeticSinAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
        this.registerForeignCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallDescriptor, hotSpotVMConfig.arithmeticCosAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
        this.registerForeignCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallDescriptor, hotSpotVMConfig.arithmeticTanAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
        this.registerForeignCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallDescriptor, hotSpotVMConfig.arithmeticExpAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
        this.registerForeignCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallDescriptor, hotSpotVMConfig.arithmeticLogAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
        this.registerForeignCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallDescriptor, hotSpotVMConfig.arithmeticLog10Address, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
        this.registerForeignCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallDescriptor, hotSpotVMConfig.arithmeticPowAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, NO_LOCATIONS);
    }

    static {
        for (int i = 0; i < arraycopyDescriptors.length; ++i) {
            for (int j = 0; j < arraycopyDescriptors[i].length; ++j) {
                HotSpotHostForeignCallsProvider.arraycopyDescriptors[i][j] = new EnumMap(JavaKind.class);
                HotSpotHostForeignCallsProvider.arraycopyDescriptorsKillAny[i][j] = new EnumMap(JavaKind.class);
            }
        }
    }
}

