/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.word.WordTypes;

public class HotSpotSnippetReflectionProvider
implements SnippetReflectionProvider {
    private final HotSpotGraalRuntimeProvider runtime;
    private final HotSpotConstantReflectionProvider constantReflection;
    private final WordTypes wordTypes;
    private Class<?> wordTypesType;
    private Class<?> runtimeType;
    private Class<?> configType;

    public HotSpotSnippetReflectionProvider(HotSpotGraalRuntimeProvider runtime, HotSpotConstantReflectionProvider constantReflection, WordTypes wordTypes) {
        this.runtime = runtime;
        this.constantReflection = constantReflection;
        this.wordTypes = wordTypes;
    }

    @Override
    public JavaConstant forObject(Object object) {
        return this.constantReflection.forObject(object);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        if (constant instanceof HotSpotObjectConstant) {
            HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
            return (T)hsConstant.asObject(type);
        }
        return null;
    }

    @Override
    public JavaConstant forBoxed(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return this.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    @Override
    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        GraalHotSpotVMConfig config = this.runtime.getVMConfig();
        if (this.configType == null || this.wordTypesType == null || this.runtimeType == null) {
            this.wordTypesType = this.wordTypes.getClass();
            this.runtimeType = this.runtime.getClass();
            this.configType = ((Object)((Object)config)).getClass();
        }
        if (type.isAssignableFrom(this.wordTypesType)) {
            return type.cast(this.wordTypes);
        }
        if (type.isAssignableFrom(this.runtimeType)) {
            return type.cast(this.runtime);
        }
        if (type.isAssignableFrom(this.configType)) {
            return type.cast((Object)config);
        }
        return null;
    }

    @Override
    public Class<?> originalClass(ResolvedJavaType type) {
        return HotSpotJVMCIRuntime.runtime().getMirror(type);
    }
}

