/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.ListIterator;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotInstructionProfiling;
import org.graalvm.compiler.hotspot.lir.VerifyMaxRegisterSizePhase;
import org.graalvm.compiler.hotspot.meta.HotSpotAOTProfilingPlugin;
import org.graalvm.compiler.hotspot.phases.AheadOfTimeVerificationPhase;
import org.graalvm.compiler.hotspot.phases.LoadJavaMirrorWithKlassPhase;
import org.graalvm.compiler.hotspot.phases.aot.AOTInliningPolicy;
import org.graalvm.compiler.hotspot.phases.aot.EliminateRedundantInitializationPhase;
import org.graalvm.compiler.hotspot.phases.aot.ReplaceConstantNodesPhase;
import org.graalvm.compiler.hotspot.phases.profiling.FinalizeProfileNodesPhase;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.java.SuitesProviderBase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.SimplifyingGraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.tiers.SuitesCreator;

public class HotSpotSuitesProvider
extends SuitesProviderBase {
    protected final GraalHotSpotVMConfig config;
    protected final HotSpotGraalRuntimeProvider runtime;
    private final SuitesCreator defaultSuitesCreator;

    public HotSpotSuitesProvider(SuitesCreator defaultSuitesCreator, GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime) {
        this.defaultSuitesCreator = defaultSuitesCreator;
        this.config = config;
        this.runtime = runtime;
        this.defaultGraphBuilderSuite = this.createGraphBuilderSuite();
    }

    @Override
    public Suites createSuites(OptionValues options) {
        Suites ret = this.defaultSuitesCreator.createSuites(options);
        if (GraalOptions.ImmutableCode.getValue(options).booleanValue()) {
            ret.getHighTier().appendPhase(new LoadJavaMirrorWithKlassPhase(this.config));
            if (GraalOptions.VerifyPhases.getValue(options).booleanValue()) {
                ret.getHighTier().appendPhase(new AheadOfTimeVerificationPhase());
            }
            if (GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
                ListIterator<BasePhase<HighTierContext>> highTierLowering = ret.getHighTier().findPhase(LoweringPhase.class);
                highTierLowering.previous();
                highTierLowering.add(new EliminateRedundantInitializationPhase());
                if (HotSpotAOTProfilingPlugin.Options.TieredAOT.getValue(options).booleanValue()) {
                    highTierLowering.add(new FinalizeProfileNodesPhase(HotSpotAOTProfilingPlugin.Options.TierAInvokeInlineeNotifyFreqLog.getValue(options)));
                }
                ListIterator<BasePhase<MidTierContext>> midTierLowering = ret.getMidTier().findPhase(LoweringPhase.class);
                midTierLowering.add(new ReplaceConstantNodesPhase());
                if (HighTier.Options.Inline.getValue(options).booleanValue()) {
                    ListIterator<BasePhase<HighTierContext>> iter = ret.getHighTier().findPhase(InliningPhase.class);
                    InliningPhase inlining = (InliningPhase)iter.previous();
                    CanonicalizerPhase canonicalizer = inlining.getCanonicalizer();
                    iter.set(new InliningPhase(new AOTInliningPolicy(null), canonicalizer));
                }
            }
        }
        return ret;
    }

    protected PhaseSuite<HighTierContext> createGraphBuilderSuite() {
        PhaseSuite<HighTierContext> suite = this.defaultSuitesCreator.getDefaultGraphBuilderSuite().copy();
        assert (this.appendGraphEncoderTest(suite));
        return suite;
    }

    private boolean appendGraphEncoderTest(PhaseSuite<HighTierContext> suite) {
        suite.appendPhase(new BasePhase<HighTierContext>(){

            @Override
            protected void run(StructuredGraph graph, HighTierContext context) {
                EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graph, HotSpotSuitesProvider.this.runtime.getTarget().arch);
                StructuredGraph targetGraph = new StructuredGraph.Builder(graph.getOptions(), graph.getDebug(), StructuredGraph.AllowAssumptions.YES).method(graph.method()).trackNodeSourcePosition(graph.trackNodeSourcePosition()).build();
                SimplifyingGraphDecoder graphDecoder = new SimplifyingGraphDecoder(HotSpotSuitesProvider.this.runtime.getTarget().arch, targetGraph, context, GraalOptions.ImmutableCode.getValue(graph.getOptions()) == false);
                graphDecoder.decode(encodedGraph);
            }

            @Override
            protected CharSequence getName() {
                return "VerifyEncodingDecoding";
            }
        });
        return true;
    }

    public static PhaseSuite<HighTierContext> withNodeSourcePosition(PhaseSuite<HighTierContext> gbs) {
        PhaseSuite<HighTierContext> newGbs = gbs.copy();
        GraphBuilderPhase graphBuilderPhase = (GraphBuilderPhase)newGbs.findPhase(GraphBuilderPhase.class).previous();
        GraphBuilderConfiguration graphBuilderConfig = graphBuilderPhase.getGraphBuilderConfig();
        GraphBuilderPhase newGraphBuilderPhase = new GraphBuilderPhase(graphBuilderConfig.withNodeSourcePosition(true));
        newGbs.findPhase(GraphBuilderPhase.class).set(newGraphBuilderPhase);
        return newGbs;
    }

    @Override
    public LIRSuites createLIRSuites(OptionValues options) {
        LIRSuites suites = this.defaultSuitesCreator.createLIRSuites(options);
        String profileInstructions = HotSpotBackend.Options.ASMInstructionProfiling.getValue(options);
        if (profileInstructions != null) {
            suites.getPostAllocationOptimizationStage().appendPhase(new HotSpotInstructionProfiling(profileInstructions));
        }
        if (Assertions.assertionsEnabled()) {
            suites.getPostAllocationOptimizationStage().appendPhase(new VerifyMaxRegisterSizePhase(this.config.maxVectorSize));
        }
        return suites;
    }
}

