/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class GraalHotSpotVMConfigNode
extends FloatingNode
implements LIRLowerable,
Canonicalizable {
    public static final NodeClass<GraalHotSpotVMConfigNode> TYPE = NodeClass.create(GraalHotSpotVMConfigNode.class);
    private final GraalHotSpotVMConfig config;
    protected final int markId;

    public GraalHotSpotVMConfigNode(@Node.InjectedNodeParameter GraalHotSpotVMConfig config) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.config = config;
        this.markId = 0;
    }

    public GraalHotSpotVMConfigNode(@Node.InjectedNodeParameter Stamp stamp, @Node.InjectedNodeParameter GraalHotSpotVMConfig config, int markId) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        this.config = config;
        this.markId = markId;
    }

    public GraalHotSpotVMConfigNode(GraalHotSpotVMConfig config, int markId, JavaKind kind) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(kind));
        this.config = config;
        this.markId = markId;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        Value res = ((HotSpotLIRGenerator)generator.getLIRGeneratorTool()).emitLoadConfigValue(this.markId, generator.getLIRGeneratorTool().getLIRKind(this.stamp));
        generator.setResult(this, res);
    }

    @Node.NodeIntrinsic
    private static native boolean areConfigValuesConstant();

    @Node.NodeIntrinsic
    private static native long loadLongConfigValue(@Node.ConstantNodeParameter int var0);

    @Node.NodeIntrinsic
    private static native int loadIntConfigValue(@Node.ConstantNodeParameter int var0);

    @Node.NodeIntrinsic
    private static native byte loadByteConfigValue(@Node.ConstantNodeParameter int var0);

    public static long cardTableAddress() {
        return GraalHotSpotVMConfigNode.loadLongConfigValue(GraalHotSpotVMConfigNode.cardTableAddressMark(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    public static boolean isCardTableAddressConstant() {
        return GraalHotSpotVMConfigNode.areConfigValuesConstant();
    }

    public static long heapTopAddress() {
        return GraalHotSpotVMConfigNode.loadLongConfigValue(GraalHotSpotVMConfigNode.heapTopAddressMark(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    public static long heapEndAddress() {
        return GraalHotSpotVMConfigNode.loadLongConfigValue(GraalHotSpotVMConfigNode.heapEndAddressMark(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    public static long crcTableAddress() {
        return GraalHotSpotVMConfigNode.loadLongConfigValue(GraalHotSpotVMConfigNode.crcTableAddressMark(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    public static int logOfHeapRegionGrainBytes() {
        return GraalHotSpotVMConfigNode.loadIntConfigValue(GraalHotSpotVMConfigNode.logOfHeapRegionGrainBytesMark(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    public static boolean inlineContiguousAllocationSupported() {
        return GraalHotSpotVMConfigNode.loadByteConfigValue(GraalHotSpotVMConfigNode.inlineContiguousAllocationSupportedMark(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) != 0;
    }

    @Fold
    public static int cardTableAddressMark(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.MARKID_CARD_TABLE_ADDRESS;
    }

    @Fold
    public static int heapTopAddressMark(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.MARKID_HEAP_TOP_ADDRESS;
    }

    @Fold
    public static int heapEndAddressMark(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.MARKID_HEAP_END_ADDRESS;
    }

    @Fold
    public static int crcTableAddressMark(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.MARKID_CRC_TABLE_ADDRESS;
    }

    @Fold
    public static int logOfHeapRegionGrainBytesMark(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.MARKID_LOG_OF_HEAP_REGION_GRAIN_BYTES;
    }

    @Fold
    public static int inlineContiguousAllocationSupportedMark(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.MARKID_INLINE_CONTIGUOUS_ALLOCATION_SUPPORTED;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.markId == 0) {
            return ConstantNode.forBoolean(GraalOptions.GeneratePIC.getValue(tool.getOptions()) == false);
        }
        if (!GraalOptions.GeneratePIC.getValue(tool.getOptions()).booleanValue()) {
            if (this.markId == this.config.MARKID_CARD_TABLE_ADDRESS) {
                return ConstantNode.forLong(this.config.cardtableStartAddress);
            }
            if (this.markId == this.config.MARKID_HEAP_TOP_ADDRESS) {
                return ConstantNode.forLong(this.config.heapTopAddress);
            }
            if (this.markId == this.config.MARKID_HEAP_END_ADDRESS) {
                return ConstantNode.forLong(this.config.heapEndAddress);
            }
            if (this.markId == this.config.MARKID_CRC_TABLE_ADDRESS) {
                return ConstantNode.forLong(this.config.crcTableAddress);
            }
            if (this.markId == this.config.MARKID_LOG_OF_HEAP_REGION_GRAIN_BYTES) {
                return ConstantNode.forInt(this.config.logOfHRGrainBytes);
            }
            if (this.markId == this.config.MARKID_INLINE_CONTIGUOUS_ALLOCATION_SUPPORTED) {
                return ConstantNode.forBoolean(this.config.inlineContiguousAllocationSupported);
            }
            assert (false);
        }
        return this;
    }
}

