/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.phases.aot;

import java.util.Map;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.policy.GreedyInliningPolicy;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;
import org.graalvm.compiler.phases.common.inlining.walker.MethodInvocation;

public class AOTInliningPolicy
extends GreedyInliningPolicy {
    public AOTInliningPolicy(Map<Invoke, Double> hints) {
        super(hints);
    }

    protected double maxInliningSize(int inliningDepth, OptionValues options) {
        return Math.max((double)Options.AOTInliningSizeMaximum.getValue(options).intValue() / ((double)inliningDepth * Options.AOTInliningDepthToSizeRate.getValue(options)), (double)Options.AOTInliningSizeMinimum.getValue(options).intValue());
    }

    @Override
    public InliningPolicy.Decision isWorthInlining(Replacements replacements, MethodInvocation invocation, InlineInfo calleeInfo, int inliningDepth, boolean fullyProcessed) {
        OptionValues options = calleeInfo.graph().getOptions();
        boolean isTracing = GraalOptions.TraceInlining.getValue(options);
        InlineInfo info = invocation.callee();
        for (int i = 0; i < info.numberOfMethods(); ++i) {
            HotSpotResolvedObjectType t = (HotSpotResolvedObjectType)info.methodAt(i).getDeclaringClass();
            if (t.getFingerprint() != 0L) continue;
            return InliningPolicy.Decision.NO;
        }
        double probability = invocation.probability();
        double relevance = invocation.relevance();
        if (GraalOptions.InlineEverything.getValue(options).booleanValue()) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "inline everything", new Object[0]);
            return InliningPolicy.Decision.YES.withReason(isTracing, "inline everything", new Object[0]);
        }
        if (this.isIntrinsic(replacements, info)) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "intrinsic", new Object[0]);
            return InliningPolicy.Decision.YES.withReason(isTracing, "intrinsic", new Object[0]);
        }
        if (info.shouldInline()) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "forced inlining", new Object[0]);
            return InliningPolicy.Decision.YES.withReason(isTracing, "forced inlining", new Object[0]);
        }
        double inliningBonus = this.getInliningBonus(info);
        int nodes = info.determineNodeCount();
        if ((double)nodes < (double)GraalOptions.TrivialInliningSize.getValue(options).intValue() * inliningBonus) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "trivial (relevance=%f, probability=%f, bonus=%f, nodes=%d)", relevance, probability, inliningBonus, nodes);
            return InliningPolicy.Decision.YES.withReason(isTracing, "trivial (relevance=%f, probability=%f, bonus=%f, nodes=%d)", relevance, probability, inliningBonus, nodes);
        }
        double maximumNodes = this.computeMaximumSize(relevance, (int)(this.maxInliningSize(inliningDepth, options) * inliningBonus));
        if ((double)nodes <= maximumNodes) {
            InliningUtil.traceInlinedMethod(info, inliningDepth, fullyProcessed, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d <= %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
            return InliningPolicy.Decision.YES.withReason(isTracing, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d <= %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
        }
        InliningUtil.traceNotInlinedMethod(info, inliningDepth, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d > %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
        return InliningPolicy.Decision.NO.withReason(isTracing, "relevance-based (relevance=%f, probability=%f, bonus=%f, nodes=%d > %f)", relevance, probability, inliningBonus, nodes, maximumNodes);
    }

    public static class Options {
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Double> AOTInliningDepthToSizeRate = new OptionKey<Double>(2.5);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> AOTInliningSizeMaximum = new OptionKey<Integer>(300);
        @Option(help={""}, type=OptionType.Expert)
        public static final OptionKey<Integer> AOTInliningSizeMinimum = new OptionKey<Integer>(50);
    }
}

