/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.phases.aot;

import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.nodes.aot.InitializeKlassNode;
import org.graalvm.compiler.hotspot.nodes.aot.LoadConstantIndirectlyFixedNode;
import org.graalvm.compiler.hotspot.nodes.aot.LoadConstantIndirectlyNode;
import org.graalvm.compiler.hotspot.nodes.aot.LoadMethodCountersNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveConstantNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveDynamicConstantNode;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveMethodAndLoadCountersNode;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public class ReplaceConstantNodesPhase
extends BasePhase<CoreProviders> {
    private final boolean verifyFingerprints;
    static Class<?> characterCacheClass = Character.class.getDeclaredClasses()[0];
    static Class<?> byteCacheClass = Byte.class.getDeclaredClasses()[0];
    static Class<?> shortCacheClass = Short.class.getDeclaredClasses()[0];
    static Class<?> integerCacheClass = Integer.class.getDeclaredClasses()[0];
    static Class<?> longCacheClass = Long.class.getDeclaredClasses()[0];

    private static boolean isReplacementNode(Node n) {
        return n instanceof LoadConstantIndirectlyNode || n instanceof LoadConstantIndirectlyFixedNode || n instanceof ResolveDynamicConstantNode || n instanceof ResolveConstantNode || n instanceof InitializeKlassNode;
    }

    private static boolean anyUsagesNeedReplacement(ConstantNode node) {
        return node.usages().filter(n -> !ReplaceConstantNodesPhase.isReplacementNode(n)).isNotEmpty();
    }

    private static boolean anyUsagesNeedReplacement(LoadMethodCountersNode node) {
        return node.usages().filter(n -> !(n instanceof ResolveMethodAndLoadCountersNode)).isNotEmpty();
    }

    private static boolean checkForBadFingerprint(HotSpotResolvedJavaType type) {
        if (type.isArray()) {
            if (type.getElementalType().isPrimitive()) {
                return false;
            }
            return ((HotSpotResolvedObjectType)type.getElementalType()).getFingerprint() == 0L;
        }
        return ((HotSpotResolvedObjectType)type).getFingerprint() == 0L;
    }

    private static void insertReplacement(StructuredGraph graph, FrameStateMapperClosure stateMapper, FloatingNode node, FixedWithNextNode replacement) {
        FixedWithNextNode insertionPoint = ReplaceConstantNodesPhase.findInsertionPoint(graph, stateMapper, node);
        graph.addAfterFixed(insertionPoint, replacement);
        stateMapper.addState(replacement, stateMapper.getState(insertionPoint));
    }

    private static FixedWithNextNode findInsertionPoint(StructuredGraph graph, FrameStateMapperClosure stateMapper, FloatingNode node) {
        FixedWithNextNode fixed = ReplaceConstantNodesPhase.findFixedBeforeFloating(graph, node);
        FixedWithNextNode result = ReplaceConstantNodesPhase.findFixedWithValidState(graph, stateMapper, fixed);
        return result;
    }

    private static FixedWithNextNode findFixedBeforeFloating(StructuredGraph graph, FloatingNode node) {
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        NodeMap<Block> nodeToBlock = schedule.getNodeToBlockMap();
        Block block = nodeToBlock.get(node);
        BlockMap<List<Node>> blockToNodes = schedule.getBlockToNodesMap();
        FixedWithNextNode result = null;
        for (Node n : blockToNodes.get(block)) {
            if (n.equals(node)) break;
            if (!(n instanceof FixedWithNextNode)) continue;
            result = (FixedWithNextNode)n;
        }
        assert (result != null);
        return result;
    }

    private static FixedWithNextNode findFixedWithValidState(StructuredGraph graph, FrameStateMapperClosure stateMapper, FixedWithNextNode node) {
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        NodeMap<Block> nodeToBlock = schedule.getNodeToBlockMap();
        Block block = nodeToBlock.get(node);
        Node n = node;
        do {
            if (ReplaceConstantNodesPhase.isFixedWithValidState(stateMapper, n)) {
                return n;
            }
            while (n != block.getBeginNode()) {
                if (!ReplaceConstantNodesPhase.isFixedWithValidState(stateMapper, n = n.predecessor())) continue;
                return n;
            }
            if ((block = (Block)block.getDominator()) == null) continue;
            n = block.getEndNode();
        } while (block != null);
        return graph.start();
    }

    private static boolean isFixedWithValidState(FrameStateMapperClosure stateMapper, Node n) {
        if (n instanceof FixedWithNextNode) {
            FixedWithNextNode fixed = (FixedWithNextNode)n;
            assert (stateMapper.getState(fixed) != null);
            if (!BytecodeFrame.isPlaceholderBci((int)stateMapper.getState((Node)fixed).bci)) {
                return true;
            }
        }
        return false;
    }

    private static void tryToReplaceWithExisting(StructuredGraph graph, ConstantNode node) {
        StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
        NodeMap<Block> nodeToBlock = schedule.getNodeToBlockMap();
        BlockMap<List<Node>> blockToNodes = schedule.getBlockToNodesMap();
        EconomicMap blockToExisting = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (Node n2 : node.usages().filter(n -> ReplaceConstantNodesPhase.isReplacementNode(n))) {
            blockToExisting.put((Object)nodeToBlock.get(n2), (Object)n2);
        }
        block1: for (Node use : node.usages().filter(n -> !ReplaceConstantNodesPhase.isReplacementNode(n)).snapshot()) {
            boolean replaced = false;
            Block b = nodeToBlock.get(use);
            Node e = (Node)blockToExisting.get((Object)b);
            if (e != null) {
                for (Node n3 : blockToNodes.get(b)) {
                    if (n3.equals(use)) break;
                    if (!n3.equals(e)) continue;
                    use.replaceFirstInput(node, e);
                    replaced = true;
                    break;
                }
            }
            if (replaced) continue;
            for (Block d : blockToExisting.getKeys()) {
                if (!AbstractControlFlowGraph.strictlyDominates(d, b)) continue;
                use.replaceFirstInput(node, (Node)blockToExisting.get((Object)d));
                continue block1;
            }
        }
    }

    private static void replaceWithResolution(StructuredGraph graph, FrameStateMapperClosure stateMapper, ConstantNode node, ClassInfo classInfo) {
        ValueNode replacement;
        HotSpotMetaspaceConstant metaspaceConstant = (HotSpotMetaspaceConstant)node.asConstant();
        HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)metaspaceConstant.asResolvedJavaType();
        ResolvedJavaType topMethodHolder = graph.method().getDeclaringClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            replacement = graph.addOrUnique(new LoadConstantIndirectlyNode(node));
        } else if (type.equals((Object)topMethodHolder) || type.isAssignableFrom(topMethodHolder) && !type.isInterface()) {
            replacement = graph.addOrUnique(new LoadConstantIndirectlyNode(node));
        } else {
            FixedWithNextNode fixedReplacement = classInfo.builtIns.contains(type) ? (FixedWithNextNode)graph.add(new ResolveConstantNode(node, HotSpotConstantLoadAction.INITIALIZE)) : (FixedWithNextNode)graph.add(new ResolveConstantNode(node));
            ReplaceConstantNodesPhase.insertReplacement(graph, stateMapper, node, fixedReplacement);
            replacement = fixedReplacement;
        }
        node.replaceAtUsages(replacement, n -> !ReplaceConstantNodesPhase.isReplacementNode(n));
    }

    private void handleHotSpotMetaspaceConstant(StructuredGraph graph, FrameStateMapperClosure stateMapper, ConstantNode node, ClassInfo classInfo) {
        HotSpotMetaspaceConstant metaspaceConstant = (HotSpotMetaspaceConstant)node.asConstant();
        HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)metaspaceConstant.asResolvedJavaType();
        if (type != null) {
            if (this.verifyFingerprints && ReplaceConstantNodesPhase.checkForBadFingerprint(type)) {
                throw new GraalError("Type with bad fingerprint: " + type);
            }
            assert (!metaspaceConstant.isCompressed()) : "No support for replacing compressed metaspace constants";
            ReplaceConstantNodesPhase.tryToReplaceWithExisting(graph, node);
            if (ReplaceConstantNodesPhase.anyUsagesNeedReplacement(node)) {
                ReplaceConstantNodesPhase.replaceWithResolution(graph, stateMapper, node, classInfo);
            }
        } else {
            throw new GraalError("Unsupported metaspace constant type: " + type);
        }
    }

    private static void handleHotSpotObjectConstant(StructuredGraph graph, FrameStateMapperClosure stateMapper, ConstantNode node, ClassInfo classInfo) {
        HotSpotObjectConstant constant = (HotSpotObjectConstant)node.asJavaConstant();
        HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)constant.getType();
        if (type.equals((Object)classInfo.stringType)) {
            assert (!constant.isCompressed()) : "No support for replacing compressed oop constants";
        } else {
            throw new GraalError("Unsupported object constant type: " + type);
        }
        FixedWithNextNode replacement = graph.add(new ResolveConstantNode(node));
        ReplaceConstantNodesPhase.insertReplacement(graph, stateMapper, node, replacement);
        node.replaceAtUsages(replacement, n -> !(n instanceof ResolveConstantNode));
    }

    private static void handleLoadMethodCounters(StructuredGraph graph, FrameStateMapperClosure stateMapper, LoadMethodCountersNode node, CoreProviders context) {
        ResolvedJavaType type = node.getMethod().getDeclaringClass();
        AbstractPointerStamp hubStamp = context.getStampProvider().createHubStamp((ObjectStamp)StampFactory.objectNonNull());
        ConstantReflectionProvider constantReflection = context.getConstantReflection();
        ConstantNode klassHint = ConstantNode.forConstant(hubStamp, constantReflection.asObjectHub(type), context.getMetaAccess(), graph);
        FixedWithNextNode replacement = graph.add(new ResolveMethodAndLoadCountersNode(node.getMethod(), klassHint));
        ReplaceConstantNodesPhase.insertReplacement(graph, stateMapper, node, replacement);
        node.replaceAtUsages(replacement, n -> !(n instanceof ResolveMethodAndLoadCountersNode));
    }

    private static void replaceLoadMethodCounters(StructuredGraph graph, FrameStateMapperClosure stateMapper, CoreProviders context) {
        new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS, true).apply(graph, false);
        for (LoadMethodCountersNode node : LoadMethodCountersNode.getLoadMethodCountersNodes(graph)) {
            if (!ReplaceConstantNodesPhase.anyUsagesNeedReplacement(node)) continue;
            ReplaceConstantNodesPhase.handleLoadMethodCounters(graph, stateMapper, node, context);
        }
    }

    private void replaceKlassesAndObjects(StructuredGraph graph, FrameStateMapperClosure stateMapper, ClassInfo classInfo) {
        new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS, true).apply(graph, false);
        for (ConstantNode node : ConstantNode.getConstantNodes(graph)) {
            Constant constant = node.asConstant();
            if (constant instanceof HotSpotMetaspaceConstant && ReplaceConstantNodesPhase.anyUsagesNeedReplacement(node)) {
                this.handleHotSpotMetaspaceConstant(graph, stateMapper, node, classInfo);
                continue;
            }
            if (!(constant instanceof HotSpotObjectConstant) || !ReplaceConstantNodesPhase.anyUsagesNeedReplacement(node)) continue;
            ReplaceConstantNodesPhase.handleHotSpotObjectConstant(graph, stateMapper, node, classInfo);
        }
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        FrameStateMapperClosure stateMapper = new FrameStateMapperClosure(graph);
        ReentrantNodeIterator.apply(stateMapper, graph.start(), null);
        ReplaceConstantNodesPhase.replaceLoadMethodCounters(graph, stateMapper, context);
        this.replaceKlassesAndObjects(graph, stateMapper, new ClassInfo(context.getMetaAccess()));
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    public ReplaceConstantNodesPhase() {
        this(true);
    }

    public ReplaceConstantNodesPhase(boolean verifyFingerprints) {
        this.verifyFingerprints = verifyFingerprints;
    }

    private static class FrameStateMapperClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<FrameState> {
        private NodeMap<FrameState> reachingStates;

        @Override
        protected FrameState processNode(FixedNode node, FrameState previousState) {
            StateSplit stateSplit;
            FrameState stateAfter;
            FrameState currentState = previousState;
            if (node instanceof StateSplit && (stateAfter = (stateSplit = (StateSplit)((Object)node)).stateAfter()) != null) {
                currentState = stateAfter;
            }
            this.reachingStates.put(node, currentState);
            return currentState;
        }

        @Override
        protected FrameState merge(AbstractMergeNode merge, List<FrameState> states) {
            FrameState singleFrameState = FrameStateMapperClosure.singleFrameState(states);
            FrameState currentState = singleFrameState == null ? merge.stateAfter() : singleFrameState;
            this.reachingStates.put(merge, currentState);
            return currentState;
        }

        @Override
        protected FrameState afterSplit(AbstractBeginNode node, FrameState oldState) {
            return oldState;
        }

        @Override
        protected EconomicMap<LoopExitNode, FrameState> processLoop(LoopBeginNode loop, FrameState initialState) {
            return ReentrantNodeIterator.processLoop(this, (LoopBeginNode)loop, initialState).exitStates;
        }

        private static FrameState singleFrameState(List<FrameState> states) {
            FrameState singleState = states.get(0);
            for (int i = 1; i < states.size(); ++i) {
                if (states.get(i) == singleState) continue;
                return null;
            }
            return singleState;
        }

        FrameStateMapperClosure(StructuredGraph graph) {
            this.reachingStates = new NodeMap(graph);
        }

        public FrameState getState(Node n) {
            return this.reachingStates.get(n);
        }

        public void addState(Node n, FrameState s) {
            this.reachingStates.setAndGrow(n, s);
        }
    }

    static class ClassInfo {
        private ResolvedJavaType stringType;
        private final HashSet<ResolvedJavaType> builtIns = new HashSet();

        ClassInfo(MetaAccessProvider metaAccessProvider) {
            this.builtIns.add(metaAccessProvider.lookupJavaType(Boolean.class));
            assert ("java.lang.Character$CharacterCache".equals(characterCacheClass.getName()));
            this.builtIns.add(metaAccessProvider.lookupJavaType(characterCacheClass));
            assert ("java.lang.Byte$ByteCache".equals(byteCacheClass.getName()));
            this.builtIns.add(metaAccessProvider.lookupJavaType(byteCacheClass));
            assert ("java.lang.Short$ShortCache".equals(shortCacheClass.getName()));
            this.builtIns.add(metaAccessProvider.lookupJavaType(shortCacheClass));
            assert ("java.lang.Integer$IntegerCache".equals(integerCacheClass.getName()));
            this.builtIns.add(metaAccessProvider.lookupJavaType(integerCacheClass));
            assert ("java.lang.Long$LongCache".equals(longCacheClass.getName()));
            this.builtIns.add(metaAccessProvider.lookupJavaType(longCacheClass));
            this.stringType = metaAccessProvider.lookupJavaType(String.class);
        }
    }
}

