/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.phases.profiling;

import java.util.HashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileInvokeNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileNode;
import org.graalvm.compiler.hotspot.nodes.profiling.RandomSeedNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.phases.BasePhase;

public class FinalizeProfileNodesPhase
extends BasePhase<CoreProviders> {
    private int inlineeInvokeNotificationFreqLog;

    public FinalizeProfileNodesPhase(int inlineeInvokeNotificationFreqLog) {
        this.inlineeInvokeNotificationFreqLog = inlineeInvokeNotificationFreqLog;
    }

    private static void removeAllProfilingNodes(StructuredGraph graph) {
        ProfileNode.getProfileNodes(graph).forEach(n -> GraphUtil.removeFixedWithUnusedInputs(n));
    }

    private void assignInlineeInvokeFrequencies(StructuredGraph graph) {
        for (ProfileInvokeNode node : ProfileInvokeNode.getProfileInvokeNodes(graph)) {
            ResolvedJavaMethod profiledMethod = node.getProfiledMethod();
            if (profiledMethod.equals(graph.method())) continue;
            node.setNotificationFreqLog(this.inlineeInvokeNotificationFreqLog);
        }
    }

    private static boolean simpleMethodHeuristic(StructuredGraph graph) {
        if (Options.ProfileSimpleMethods.getValue(graph.getOptions()).booleanValue()) {
            return false;
        }
        if (graph.getNodeCount() > Options.SimpleMethodGraphSize.getValue(graph.getOptions())) {
            return false;
        }
        if (graph.hasLoops()) {
            return false;
        }
        if (graph.getNodes().filter(InvokeNode.class).count() > Options.SimpleMethodCalls.getValue(graph.getOptions())) {
            return false;
        }
        return graph.getNodes().filter(InvokeNode.class).filter(n -> ((InvokeNode)n).getInvokeKind().isIndirect()).count() <= Options.SimpleMethodIndirectCalls.getDefaultValue();
    }

    private static void assignRandomSources(StructuredGraph graph) {
        ValueNode seed = graph.unique(new RandomSeedNode());
        ControlFlowGraph cfg = ControlFlowGraph.compute(graph, false, true, false, false);
        HashMap<LoopBeginNode, ValueNode> loopRandomValueCache = new HashMap<LoopBeginNode, ValueNode>();
        for (ProfileNode node : ProfileNode.getProfileNodes(graph)) {
            ValueNode random;
            Block block = cfg.blockFor(node);
            Loop<Block> loop = block.getLoop();
            if (loop != null) {
                LoopBeginNode loopBegin = (LoopBeginNode)loop.getHeader().getBeginNode();
                random = (ValueNode)loopRandomValueCache.get(loopBegin);
                if (random == null) {
                    PhiNode phi = graph.addWithoutUnique(new ValuePhiNode(seed.stamp(NodeView.DEFAULT), loopBegin));
                    phi.addInput(seed);
                    ConstantNode a = ConstantNode.forInt(1103515245, graph);
                    ConstantNode c = ConstantNode.forInt(12345, graph);
                    ValueNode next = graph.addOrUniqueWithInputs(new AddNode(c, new MulNode(phi, a)));
                    for (int i = 0; i < loopBegin.getLoopEndCount(); ++i) {
                        phi.addInput(next);
                    }
                    random = phi;
                    loopRandomValueCache.put(loopBegin, random);
                }
            } else {
                random = seed;
            }
            node.setRandom(random);
        }
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (FinalizeProfileNodesPhase.simpleMethodHeuristic(graph)) {
            FinalizeProfileNodesPhase.removeAllProfilingNodes(graph);
            return;
        }
        this.assignInlineeInvokeFrequencies(graph);
        if (ProfileNode.Options.ProbabilisticProfiling.getValue(graph.getOptions()).booleanValue()) {
            FinalizeProfileNodesPhase.assignRandomSources(graph);
        }
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    public static class Options {
        @Option(help={"Profile simple methods"}, type=OptionType.Expert)
        public static final OptionKey<Boolean> ProfileSimpleMethods = new OptionKey<Boolean>(true);
        @Option(help={"Maximum number of nodes in a graph for a simple method"}, type=OptionType.Expert)
        public static final OptionKey<Integer> SimpleMethodGraphSize = new OptionKey<Integer>(256);
        @Option(help={"Maximum number of calls in a simple method"}, type=OptionType.Expert)
        public static final OptionKey<Integer> SimpleMethodCalls = new OptionKey<Integer>(1);
        @Option(help={"Maximum number of indirect calls in a simple moethod"}, type=OptionType.Expert)
        public static final OptionKey<Integer> SimpleMethodIndirectCalls = new OptionKey<Integer>(0);
    }
}

