/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"java.util.zip.CRC32C"}, optional=true)
public class CRC32CSubstitutions {
    public static final ForeignCallDescriptor UPDATE_BYTES_CRC32C = new ForeignCallDescriptor("updateBytesCRC32C", Integer.TYPE, Integer.TYPE, WordBase.class, Integer.TYPE);

    @MethodSubstitution
    static int updateBytes(int crc, byte[] b, int off, int end) {
        Word bufAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(b, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfigBase.INJECTED_METAACCESS, JavaKind.Byte) + off));
        return CRC32CSubstitutions.updateBytesCRC32(UPDATE_BYTES_CRC32C, crc, (WordBase)bufAddr, end - off);
    }

    @MethodSubstitution
    static int updateDirectByteBuffer(int crc, long addr, int off, int end) {
        UnsignedWord bufAddr = WordFactory.unsigned((long)addr).add(off);
        return CRC32CSubstitutions.updateBytesCRC32(UPDATE_BYTES_CRC32C, crc, (WordBase)bufAddr, end - off);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int updateBytesCRC32(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, WordBase var2, int var3);
}

