/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.util.zip.CRC32;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.nodes.GraalHotSpotVMConfigNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@ClassSubstitution(value=CRC32.class)
public class CRC32Substitutions {
    public static final ForeignCallDescriptor UPDATE_BYTES_CRC32 = new ForeignCallDescriptor("updateBytesCRC32", Integer.TYPE, Integer.TYPE, WordBase.class, Integer.TYPE);

    @MethodSubstitution(optional=true)
    static int update(int crc, int b) {
        Pointer crcTableRawAddress = (Pointer)WordFactory.pointer((long)GraalHotSpotVMConfigNode.crcTableAddress());
        int c = ~crc;
        int index = (b ^ c) & 0xFF;
        int offset = index << 2;
        int result = crcTableRawAddress.readInt(offset);
        return ~(result ^= c >>> 8);
    }

    @MethodSubstitution(optional=true)
    static int updateBytes(int crc, byte[] buf, int off, int len) {
        Word bufAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(buf, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfigBase.INJECTED_METAACCESS, JavaKind.Byte) + off));
        return CRC32Substitutions.updateBytesCRC32(UPDATE_BYTES_CRC32, crc, (WordBase)bufAddr, len);
    }

    @MethodSubstitution(optional=true)
    static int updateBytes0(int crc, byte[] buf, int off, int len) {
        Word bufAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(buf, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfigBase.INJECTED_METAACCESS, JavaKind.Byte) + off));
        return CRC32Substitutions.updateBytesCRC32(UPDATE_BYTES_CRC32, crc, (WordBase)bufAddr, len);
    }

    @MethodSubstitution(optional=true)
    static int updateByteBuffer(int crc, long addr, int off, int len) {
        UnsignedWord bufAddr = WordFactory.unsigned((long)addr).add(off);
        return CRC32Substitutions.updateBytesCRC32(UPDATE_BYTES_CRC32, crc, (WordBase)bufAddr, len);
    }

    @MethodSubstitution(optional=true)
    static int updateByteBuffer0(int crc, long addr, int off, int len) {
        UnsignedWord bufAddr = WordFactory.unsigned((long)addr).add(off);
        return CRC32Substitutions.updateBytesCRC32(UPDATE_BYTES_CRC32, crc, (WordBase)bufAddr, len);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int updateBytesCRC32(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, WordBase var2, int var3);
}

