/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.MacroStateSplitNode;

@NodeInfo
public final class ReflectionGetCallerClassNode
extends MacroStateSplitNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<ReflectionGetCallerClassNode> TYPE = NodeClass.create(ReflectionGetCallerClassNode.class);

    public ReflectionGetCallerClassNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
        super(TYPE, invokeKind, targetMethod, bci, returnStamp, arguments);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ConstantNode callerClassNode = this.getCallerClassNode(tool.getMetaAccess(), tool.getConstantReflection());
        if (callerClassNode != null) {
            return callerClassNode;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        ConstantNode callerClassNode = this.getCallerClassNode(tool.getMetaAccess(), tool.getConstantReflection());
        if (callerClassNode != null) {
            this.graph().replaceFixedWithFloating(this, this.graph().addOrUniqueWithInputs(callerClassNode));
        } else {
            InvokeNode invoke = this.createInvoke();
            this.graph().replaceFixedWithFixed(this, invoke);
            invoke.lower(tool);
        }
    }

    private ConstantNode getCallerClassNode(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        FrameState state = this.stateAfter();
        int n = 1;
        while (state != null) {
            HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)state.getMethod();
            switch (n) {
                case 0: {
                    throw GraalError.shouldNotReachHere("current frame state does not include the Reflection.getCallerClass frame");
                }
                case 1: {
                    if (method.isCallerSensitive()) break;
                    return null;
                }
                default: {
                    if (method.ignoredBySecurityStackWalk()) break;
                    HotSpotResolvedObjectType callerClass = method.getDeclaringClass();
                    return ConstantNode.forConstant(constantReflection.asJavaClass((ResolvedJavaType)callerClass), metaAccess);
                }
            }
            state = state.outerFrameState();
            ++n;
        }
        return null;
    }
}

