/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigBase;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"sun.security.provider.SHA5"}, optional=true)
public class SHA5Substitutions {
    @MethodSubstitution(isStatic=false)
    static void implCompress0(Object receiver, byte[] buf, int ofs) {
        Object realReceiver = PiNode.piCastNonNull(receiver, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT));
        Object state = RawLoadNode.load(realReceiver, SHA5Substitutions.stateOffset(GraalHotSpotVMConfigBase.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        Word bufAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(buf, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfigBase.INJECTED_METAACCESS, JavaKind.Byte) + ofs));
        Word stateAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(state, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfigBase.INJECTED_METAACCESS, JavaKind.Int)));
        HotSpotBackend.sha5ImplCompressStub(bufAddr, stateAddr);
    }

    @Fold
    static long stateOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(HotSpotReplacementsUtil.methodHolderClass(context), "state");
    }
}

