/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.lang.ref.Reference;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class UnsafeLoadSnippets
implements Snippets {
    @Snippet
    public static Object lowerUnsafeLoad(Object object, long offset) {
        Object fixedObject = FixedValueAnchorNode.getObject(object);
        if (object instanceof Reference && HotSpotReplacementsUtil.referentOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS) == offset) {
            return Word.objectToTrackedPointer(fixedObject).readObject((int)offset, HeapAccess.BarrierType.WEAK_FIELD);
        }
        return Word.objectToTrackedPointer(fixedObject).readObject((int)offset, HeapAccess.BarrierType.NONE);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo unsafeLoad = this.snippet(UnsafeLoadSnippets.class, "lowerUnsafeLoad", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
        }

        public void lower(RawLoadNode load, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.unsafeLoad, load.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", load.object());
            args.add("offset", load.offset());
            this.template(load, args).instantiate(this.providers.getMetaAccess(), load, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

