/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.CRC32CSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CRC32Substitutions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public class SPARCHotSpotForeignCallsProvider
extends HotSpotHostForeignCallsProvider {
    private final Value[] nativeABICallerSaveRegisters;

    public SPARCHotSpotForeignCallsProvider(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        super(jvmciRuntime, runtime, metaAccess, codeCache, wordTypes);
        this.nativeABICallerSaveRegisters = nativeABICallerSaveRegisters;
    }

    @Override
    public void initialize(HotSpotProviders providers, OptionValues options) {
        GraalHotSpotVMConfig config = this.runtime.getVMConfig();
        TargetDescription target = providers.getCodeCache().getTarget();
        PlatformKind word = target.arch.getWordKind();
        RegisterValue outgoingException = SPARC.o0.asValue((ValueKind)LIRKind.fromJavaKind(target.arch, JavaKind.Object));
        RegisterValue outgoingExceptionPc = SPARC.o1.asValue((ValueKind)LIRKind.value(word));
        RegisterValue incomingException = SPARC.i0.asValue((ValueKind)LIRKind.fromJavaKind(target.arch, JavaKind.Object));
        RegisterValue incomingExceptionPc = SPARC.i1.asValue((ValueKind)LIRKind.value(word));
        CallingConvention outgoingExceptionCc = new CallingConvention(0, Value.ILLEGAL, new AllocatableValue[]{outgoingException, outgoingExceptionPc});
        CallingConvention incomingExceptionCc = new CallingConvention(0, Value.ILLEGAL, new AllocatableValue[]{incomingException, incomingExceptionPc});
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER, 0L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, outgoingExceptionCc, incomingExceptionCc, LocationIdentity.any()));
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER, -2401018188504514833L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, outgoingExceptionCc, incomingExceptionCc, LocationIdentity.any()));
        if (config.useCRC32Intrinsics) {
            this.registerForeignCall(CRC32Substitutions.UPDATE_BYTES_CRC32, config.updateBytesCRC32Stub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
        }
        if (config.useCRC32CIntrinsics) {
            this.registerForeignCall(CRC32CSubstitutions.UPDATE_BYTES_CRC32C, config.updateBytesCRC32C, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.LEAF_NO_VZERO, HotSpotForeignCallLinkage.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any());
        }
        super.initialize(providers, options);
    }

    @Override
    public Value[] getNativeABICallerSaveRegisters() {
        return this.nativeABICallerSaveRegisters;
    }
}

