/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.core.sparc.SPARCMoveFactory;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotMove;
import org.graalvm.compiler.lir.LIRInstruction;

public class SPARCHotSpotMoveFactory
extends SPARCMoveFactory {
    public SPARCHotSpotMoveFactory(SPARCLIRGenerator.ConstantTableBaseProvider constantTableBaseProvider) {
        super(constantTableBaseProvider);
    }

    @Override
    public boolean canInlineConstant(Constant c) {
        if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
            return true;
        }
        if (c instanceof HotSpotObjectConstant || c instanceof HotSpotMetaspaceConstant) {
            return false;
        }
        return super.canInlineConstant(c);
    }

    @Override
    public LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        Object usedSource = HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(src) ? JavaConstant.INT_0 : (src instanceof HotSpotObjectConstant && ((HotSpotObjectConstant)src).isNull() ? JavaConstant.LONG_0 : src);
        if (usedSource instanceof HotSpotConstant) {
            HotSpotConstant constant = (HotSpotConstant)usedSource;
            if (constant.isCompressed()) {
                return new SPARCHotSpotMove.LoadHotSpotObjectConstantInline(constant, dst);
            }
            return new SPARCHotSpotMove.LoadHotSpotObjectConstantFromTable(constant, dst, this.constantTableBaseProvider.getConstantTableBase());
        }
        return super.createLoad(dst, (Constant)usedSource);
    }
}

