/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;

@Opcode(value="PUSH_INTERPRETER_FRAME")
final class SPARCHotSpotPushInterpreterFrameOp
extends SPARCLIRInstruction {
    public static final LIRInstructionClass<SPARCHotSpotPushInterpreterFrameOp> TYPE = LIRInstructionClass.create(SPARCHotSpotPushInterpreterFrameOp.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue frameSize;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue framePc;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue senderSp;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue initialInfo;

    SPARCHotSpotPushInterpreterFrameOp(AllocatableValue frameSize, AllocatableValue framePc, AllocatableValue senderSp, AllocatableValue initialInfo) {
        super(TYPE);
        this.frameSize = frameSize;
        this.framePc = framePc;
        this.senderSp = senderSp;
        this.initialInfo = initialInfo;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        Register frameSizeRegister = ValueUtil.asRegister((Value)this.frameSize);
        Register framePcRegister = ValueUtil.asRegister((Value)this.framePc);
        Register senderSpRegister = ValueUtil.asRegister((Value)this.senderSp);
        masm.mov(senderSpRegister, SPARC.o5);
        masm.neg(frameSizeRegister);
        masm.save(SPARC.sp, frameSizeRegister, SPARC.sp);
        masm.mov(SPARC.i0, SPARC.o0);
        masm.mov(SPARC.i1, SPARC.o1);
        masm.mov(SPARC.i2, SPARC.o2);
        masm.mov(SPARC.i3, SPARC.o3);
        masm.mov(SPARC.i4, SPARC.o4);
        masm.mov(framePcRegister, SPARC.i7);
    }

    @Override
    public boolean leavesRegisterWindow() {
        return true;
    }
}

