/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotEpilogueOp;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotSafepointOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCControlFlow;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

@Opcode(value="RETURN")
final class SPARCHotSpotReturnOp
extends SPARCHotSpotEpilogueOp {
    public static final LIRInstructionClass<SPARCHotSpotReturnOp> TYPE = LIRInstructionClass.create(SPARCHotSpotReturnOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(2);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value safepointPollAddress;
    private final boolean requiresReservedStackAccessCheck;
    private final boolean isStub;
    private final GraalHotSpotVMConfig config;
    private final Register thread;

    SPARCHotSpotReturnOp(Value value, boolean isStub, GraalHotSpotVMConfig config, Register thread, Value safepointPoll, boolean requiresReservedStackAccessCheck) {
        super((LIRInstructionClass<? extends SPARCHotSpotEpilogueOp>)TYPE, SIZE);
        this.value = value;
        this.isStub = isStub;
        this.config = config;
        this.thread = thread;
        this.safepointPollAddress = safepointPoll;
        this.requiresReservedStackAccessCheck = requiresReservedStackAccessCheck;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        if (!this.isStub) {
            if (this.requiresReservedStackAccessCheck) {
                try (SPARCMacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    HotSpotForeignCallsProvider foreignCalls = (HotSpotForeignCallsProvider)crb.foreignCalls;
                    Label noReserved = new Label();
                    Register scratch = sc.getRegister();
                    masm.ldx(new SPARCAddress(this.thread, this.config.javaThreadReservedStackActivationOffset), scratch);
                    masm.compareBranch(SPARC.sp, scratch, SPARCAssembler.ConditionFlag.LessUnsigned, SPARCAssembler.CC.Xcc, noReserved, SPARCAssembler.BranchPredict.PREDICT_TAKEN, null);
                    ForeignCallLinkage enableStackReservedZone = foreignCalls.lookupForeignCall(HotSpotHostBackend.ENABLE_STACK_RESERVED_ZONE);
                    CallingConvention cc = enableStackReservedZone.getOutgoingCallingConvention();
                    assert (cc.getArgumentCount() == 1);
                    Register arg0 = ((RegisterValue)cc.getArgument(0)).getRegister();
                    masm.mov(this.thread, arg0);
                    SPARCCall.directCall(crb, masm, enableStackReservedZone, scratch, null);
                    masm.restoreWindow();
                    SPARCCall.indirectJmp(crb, masm, scratch, foreignCalls.lookupForeignCall(HotSpotHostBackend.THROW_DELAYED_STACKOVERFLOW_ERROR));
                    masm.bind(noReserved);
                }
            }
            SPARCHotSpotSafepointOp.emitCode(crb, masm, this.config, true, null, this.thread, this.safepointPollAddress);
        }
        SPARCControlFlow.ReturnOp.emitCodeHelper(crb, masm);
    }
}

