/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCControlFlow;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCMove;

final class SPARCHotSpotStrategySwitchOp
extends SPARCControlFlow.StrategySwitchOp {
    public static final LIRInstructionClass<SPARCHotSpotStrategySwitchOp> TYPE = LIRInstructionClass.create(SPARCHotSpotStrategySwitchOp.class);

    SPARCHotSpotStrategySwitchOp(Value constantTableBase, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Variable scratch) {
        super(TYPE, constantTableBase, strategy, keyTargets, defaultTarget, key, scratch);
    }

    @Override
    protected int estimateEmbeddedSize(Constant c) {
        if (c instanceof HotSpotMetaspaceConstant) {
            return ((HotSpotMetaspaceConstant)c).isCompressed() ? 4 : 8;
        }
        return super.estimateEmbeddedSize(c);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        Register keyRegister = ValueUtil.asRegister((Value)this.key);
        Register constantBaseRegister = AllocatableValue.ILLEGAL.equals((Object)this.constantTableBase) ? SPARC.g0 : ValueUtil.asRegister((Value)this.constantTableBase);
        this.strategy.run(new HotSpotSwitchClosure(keyRegister, constantBaseRegister, crb, masm));
    }

    public class HotSpotSwitchClosure
    extends SPARCControlFlow.StrategySwitchOp.SwitchClosure {
        protected HotSpotSwitchClosure(Register keyRegister, Register constantBaseRegister, CompilationResultBuilder crb, SPARCMacroAssembler masm) {
            super(keyRegister, constantBaseRegister, crb, masm);
        }

        @Override
        protected void conditionalJump(int index, Condition condition, Label target) {
            if (SPARCHotSpotStrategySwitchOp.this.keyConstants[index] instanceof HotSpotMetaspaceConstant) {
                HotSpotMetaspaceConstant constant = (HotSpotMetaspaceConstant)SPARCHotSpotStrategySwitchOp.this.keyConstants[index];
                SPARCAssembler.CC conditionCode = constant.isCompressed() ? SPARCAssembler.CC.Icc : SPARCAssembler.CC.Xcc;
                SPARCAssembler.ConditionFlag conditionFlag = SPARCControlFlow.fromCondition(true, condition, false);
                Assembler.LabelHint hint = SPARCHotSpotStrategySwitchOp.this.requestHint(this.masm, target);
                int cbCondPosition = this.masm.position() + 4;
                boolean canUseShortBranch = this.masm.hasFeature(SPARC.CPUFeature.CBCOND) && SPARCControlFlow.isShortBranch(this.masm, cbCondPosition, hint, target);
                Register scratchRegister = ValueUtil.asRegister((Value)SPARCHotSpotStrategySwitchOp.this.scratch);
                SPARCMove.loadFromConstantTable(this.crb, this.masm, ValueUtil.asRegister((Value)SPARCHotSpotStrategySwitchOp.this.constantTableBase), (Constant)constant, scratchRegister, SPARCDelayedControlTransfer.DUMMY);
                if (canUseShortBranch) {
                    SPARCAssembler.CBCOND.emit(this.masm, conditionFlag, conditionCode == SPARCAssembler.CC.Xcc, this.keyRegister, scratchRegister, target);
                } else {
                    this.masm.cmp(this.keyRegister, scratchRegister);
                    SPARCAssembler.BPCC.emit(this.masm, conditionCode, conditionFlag, SPARCAssembler.Annul.ANNUL, SPARCAssembler.BranchPredict.PREDICT_TAKEN, target);
                    this.masm.nop();
                }
            } else {
                super.conditionalJump(index, condition, target);
            }
        }
    }
}

