/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.sparc;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.sparc.SPARCHotSpotEpilogueOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

@Opcode(value="UNWIND")
final class SPARCHotSpotUnwindOp
extends SPARCHotSpotEpilogueOp {
    public static final LIRInstructionClass<SPARCHotSpotUnwindOp> TYPE = LIRInstructionClass.create(SPARCHotSpotUnwindOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(32);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected RegisterValue exception;

    SPARCHotSpotUnwindOp(RegisterValue exception) {
        super((LIRInstructionClass<? extends SPARCHotSpotEpilogueOp>)TYPE, SIZE);
        this.exception = exception;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        masm.mov(SPARC.o0, SPARC.i0);
        this.leaveFrame(crb);
        ForeignCallLinkage linkage = crb.foreignCalls.lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention cc = linkage.getOutgoingCallingConvention();
        assert (cc.getArgumentCount() == 2);
        assert (this.exception.equals((Object)cc.getArgument(0)));
        Register returnAddress = ValueUtil.asRegister((Value)cc.getArgument(1));
        masm.add(SPARC.o7, 8, returnAddress);
        Register scratch = SPARC.g5;
        SPARCCall.indirectJmp(crb, masm, scratch, linkage);
    }
}

