/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class CreateExceptionStub
extends SnippetStub {
    private static final ForeignCallDescriptor THROW_AND_POST_JVMTI_EXCEPTION = new ForeignCallDescriptor("throw_and_post_jvmti_exception", Void.TYPE, Word.class, Word.class, Word.class);
    private static final ForeignCallDescriptor THROW_KLASS_EXTERNAL_NAME_EXCEPTION = new ForeignCallDescriptor("throw_klass_external_name_exception", Void.TYPE, Word.class, Word.class, KlassPointer.class);
    private static final ForeignCallDescriptor THROW_CLASS_CAST_EXCEPTION = new ForeignCallDescriptor("throw_class_cast_exception", Void.TYPE, Word.class, Word.class, KlassPointer.class, KlassPointer.class);

    protected CreateExceptionStub(String snippetMethodName, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(snippetMethodName, options, providers, linkage);
    }

    @Fold
    static String getInternalClassName(Class<?> cls) {
        return cls.getName().replace('.', '/');
    }

    private static Word classAsCString(Class<?> cls) {
        return CStringConstant.cstring(CreateExceptionStub.getInternalClassName(cls));
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception) {
        Word message = (Word)WordFactory.zero();
        return CreateExceptionStub.createException(threadRegister, exception, message);
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception, Word message) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        CreateExceptionStub.throwAndPostJvmtiException(THROW_AND_POST_JVMTI_EXCEPTION, thread, CreateExceptionStub.classAsCString(exception), message);
        return HotSpotReplacementsUtil.clearPendingException(thread);
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception, KlassPointer klass) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        CreateExceptionStub.throwKlassExternalNameException(THROW_KLASS_EXTERNAL_NAME_EXCEPTION, thread, CreateExceptionStub.classAsCString(exception), klass);
        return HotSpotReplacementsUtil.clearPendingException(thread);
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception, KlassPointer objKlass, KlassPointer targetKlass) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        CreateExceptionStub.throwClassCastException(THROW_CLASS_CAST_EXCEPTION, thread, CreateExceptionStub.classAsCString(exception), objKlass, targetKlass);
        return HotSpotReplacementsUtil.clearPendingException(thread);
    }

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native void throwAndPostJvmtiException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Word var3);

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native void throwKlassExternalNameException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, KlassPointer var3);

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native void throwClassCastException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, KlassPointer var3, KlassPointer var4);

    public static void registerForeignCalls(GraalHotSpotVMConfig c, HotSpotForeignCallsProviderImpl foreignCalls) {
        foreignCalls.registerForeignCall(THROW_AND_POST_JVMTI_EXCEPTION, c.throwAndPostJvmtiExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
        foreignCalls.registerForeignCall(THROW_KLASS_EXTERNAL_NAME_EXCEPTION, c.throwKlassExternalNameExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
        foreignCalls.registerForeignCall(THROW_CLASS_CAST_EXCEPTION, c.throwClassCastExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, HotSpotForeignCallLinkage.Transition.SAFEPOINT, HotSpotForeignCallLinkage.Reexecutability.REEXECUTABLE, LocationIdentity.any());
    }
}

