/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;

public abstract class SnippetStub
extends Stub
implements Snippets {
    protected final ResolvedJavaMethod method;

    public SnippetStub(String snippetMethodName, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        this(null, snippetMethodName, options, providers, linkage);
    }

    public SnippetStub(Class<? extends Snippets> snippetDeclaringClass, String snippetMethodName, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(options, providers, linkage);
        this.method = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), snippetDeclaringClass == null ? this.getClass() : snippetDeclaringClass, snippetMethodName);
        this.registerSnippet();
    }

    protected void registerSnippet() {
        this.providers.getReplacements().registerSnippet(this.method, null, null, false, this.options);
    }

    @Override
    protected StructuredGraph getGraph(DebugContext debug, CompilationIdentifier compilationId) {
        StructuredGraph graph = this.buildInitialGraph(debug, compilationId, this.makeConstArgs());
        try (DebugContext.Scope outer = debug.scope((Object)"SnippetStub", graph);){
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                int index = param.index();
                if (this.method.getParameterAnnotation(Snippet.NonNullParameter.class, index) == null) continue;
                param.setStamp(param.stamp(NodeView.DEFAULT).join(StampFactory.objectNonNull()));
            }
            new RemoveValueProxyPhase().apply(graph);
            graph.setGuardsStage(StructuredGraph.GuardsStage.FLOATING_GUARDS);
            CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
            canonicalizer.apply(graph, this.providers);
            new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.HIGH_TIER).apply(graph, this.providers);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return graph;
    }

    protected StructuredGraph buildInitialGraph(DebugContext debug, CompilationIdentifier compilationId, Object[] args) {
        return this.providers.getReplacements().getSnippet(this.method, null, args, false, null, this.options).copyWithIdentifier(compilationId, debug);
    }

    protected boolean checkConstArg(int index, String expectedName) {
        assert (this.method.getParameterAnnotation(Snippet.ConstantParameter.class, index) != null) : String.format("parameter %d of %s is expected to be constant", index, this.method.format("%H.%n(%p)"));
        LocalVariableTable lvt = this.method.getLocalVariableTable();
        if (lvt != null) {
            Local local = lvt.getLocal(index, 0);
            assert (local != null);
            String actualName = local.getName();
            assert (actualName.equals(expectedName)) : String.format("parameter %d of %s is expected to be named %s, not %s", index, this.method.format("%H.%n(%p)"), expectedName, actualName);
        }
        return true;
    }

    protected Object[] makeConstArgs() {
        int count = this.method.getSignature().getParameterCount(false);
        Object[] args = new Object[count];
        for (int i = 0; i < args.length; ++i) {
            if (this.method.getParameterAnnotation(Snippet.ConstantParameter.class, i) == null) continue;
            args[i] = this.getConstantParameterValue(i, null);
        }
        return args;
    }

    protected Object getConstantParameterValue(int index, String name) {
        throw new GraalError("%s must override getConstantParameterValue() to provide a value for parameter %d%s", this.getClass().getName(), index, name == null ? "" : " (" + name + ")");
    }

    @Override
    protected Object debugScopeContext() {
        return this.getInstalledCodeOwner();
    }

    @Override
    public ResolvedJavaMethod getInstalledCodeOwner() {
        return this.method;
    }

    @Override
    public String toString() {
        return "Stub<" + this.getInstalledCodeOwner().format("%h.%n") + ">";
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }
}

