/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.WordFactory;

public class StubUtil {
    public static final ForeignCallDescriptor VM_MESSAGE_C = StubUtil.newDescriptor(StubUtil.class, "vmMessageC", Void.TYPE, Boolean.TYPE, Word.class, Long.TYPE, Long.TYPE, Long.TYPE);

    public static ForeignCallDescriptor newDescriptor(Class<?> stubClass, String name, Class<?> resultType, Class<?> ... argumentTypes) {
        ForeignCallDescriptor d = new ForeignCallDescriptor(name, resultType, argumentTypes);
        assert (StubUtil.descriptorFor(stubClass, name).equals(d)) : StubUtil.descriptorFor(stubClass, name) + " != " + d;
        return d;
    }

    private static ForeignCallDescriptor descriptorFor(Class<?> stubClass, String name) {
        Method found = null;
        for (Method method : stubClass.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getAnnotation(Node.NodeIntrinsic.class) == null || !method.getName().equals(name) || !method.getAnnotation(Node.NodeIntrinsic.class).value().equals(StubForeignCallNode.class)) continue;
            assert (found == null) : "found more than one foreign call named " + name + " in " + stubClass;
            assert (method.getParameterTypes().length != 0 && method.getParameterTypes()[0] == ForeignCallDescriptor.class) : "first parameter of foreign call '" + name + "' in " + stubClass + " must be of type " + ForeignCallDescriptor.class.getSimpleName();
            found = method;
        }
        assert (found != null) : "could not find foreign call named " + name + " in " + stubClass;
        List<Class<?>> paramList = Arrays.asList(found.getParameterTypes());
        Class[] cCallTypes = paramList.subList(1, paramList.size()).toArray(new Class[paramList.size() - 1]);
        return new ForeignCallDescriptor(name, found.getReturnType(), cCallTypes);
    }

    @Fold
    public static boolean cAssertionsEnabled(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.cAssertions;
    }

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native void vmMessageC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1, Word var2, long var3, long var5, long var7);

    public static void printf(String message) {
        StubUtil.vmMessageC(VM_MESSAGE_C, false, CStringConstant.cstring(message), 0L, 0L, 0L);
    }

    public static void printf(String format, long value) {
        StubUtil.vmMessageC(VM_MESSAGE_C, false, CStringConstant.cstring(format), value, 0L, 0L);
    }

    public static void printf(String format, long v1, long v2) {
        StubUtil.vmMessageC(VM_MESSAGE_C, false, CStringConstant.cstring(format), v1, v2, 0L);
    }

    public static void printf(String format, long v1, long v2, long v3) {
        StubUtil.vmMessageC(VM_MESSAGE_C, false, CStringConstant.cstring(format), v1, v2, v3);
    }

    public static void decipher(long value) {
        StubUtil.vmMessageC(VM_MESSAGE_C, false, (Word)WordFactory.zero(), value, 0L, 0L);
    }

    public static void fatal(String message) {
        StubUtil.vmMessageC(VM_MESSAGE_C, true, CStringConstant.cstring(message), 0L, 0L, 0L);
    }

    public static void fatal(String format, long value) {
        StubUtil.vmMessageC(VM_MESSAGE_C, true, CStringConstant.cstring(format), value, 0L, 0L);
    }

    public static void fatal(String format, long v1, long v2) {
        StubUtil.vmMessageC(VM_MESSAGE_C, true, CStringConstant.cstring(format), v1, v2, 0L);
    }

    public static void fatal(String format, long v1, long v2, long v3) {
        StubUtil.vmMessageC(VM_MESSAGE_C, true, CStringConstant.cstring(format), v1, v2, v3);
    }

    public static Word printNumber(Word buffer, long number) {
        int offset;
        long tmpNumber = number;
        if (tmpNumber <= 0L) {
            tmpNumber = -tmpNumber;
            offset = 1;
        } else {
            offset = 0;
        }
        while (tmpNumber > 0L) {
            tmpNumber /= 10L;
            ++offset;
        }
        tmpNumber = number < 0L ? -number : number;
        Word ptr = buffer.add(offset);
        do {
            long digit = tmpNumber % 10L;
            ptr = ptr.subtract(1);
            ptr.writeByte(0, (byte)(48L + digit));
        } while ((tmpNumber /= 10L) > 0L);
        if (number < 0L) {
            ptr = ptr.subtract(1);
            ptr.writeByte(0, (byte)45);
        }
        return buffer.add(offset);
    }

    public static Word printString(Word buffer, String javaString) {
        byte b;
        Word string = CStringConstant.cstring(javaString);
        int i = 0;
        while ((b = string.readByte(i)) != 0) {
            buffer.writeByte(i, b);
            ++i;
        }
        return buffer.add(i);
    }
}

