/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import jdk.vm.ci.meta.ExceptionHandler;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeLookupSwitch;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.bytecode.BytecodeSwitch;
import org.graalvm.compiler.bytecode.BytecodeTableSwitch;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.java.JsrNotSupportedBailout;
import org.graalvm.compiler.java.JsrScope;
import org.graalvm.compiler.options.OptionValues;

public final class BciBlockMapping {
    private BciBlock[] blocks;
    public final Bytecode code;
    public boolean hasJsrBytecodes;
    private final ExceptionHandler[] exceptionHandlers;
    private BciBlock startBlock;
    private BciBlock[] loopHeaders;
    private static final int LOOP_HEADER_MAX_CAPACITY = 64;
    private static final int LOOP_HEADER_INITIAL_CAPACITY = 4;
    private int blocksNotYetAssignedId;
    private final DebugContext debug;
    private final ArrayList<BciBlock> jsrVisited = new ArrayList();
    private boolean loopChanges;
    private int nextLoop;

    private BciBlockMapping(Bytecode code, DebugContext debug) {
        this.code = code;
        this.debug = debug;
        this.exceptionHandlers = code.getExceptionHandlers();
    }

    public BciBlock[] getBlocks() {
        return this.blocks;
    }

    public void build(BytecodeStream stream, OptionValues options) {
        int codeSize = this.code.getCodeSize();
        BciBlock[] blockMap = new BciBlock[codeSize];
        this.makeExceptionEntries(blockMap);
        this.iterateOverBytecodes(blockMap, stream);
        if (this.hasJsrBytecodes) {
            if (!GraalOptions.SupportJsrBytecodes.getValue(options).booleanValue()) {
                throw new JsrNotSupportedBailout("jsr/ret parsing disabled");
            }
            this.createJsrAlternatives(blockMap, blockMap[0]);
        }
        if (this.debug.isLogEnabled()) {
            this.log(blockMap, "Before BlockOrder");
        }
        this.computeBlockOrder(blockMap);
        this.fixLoopBits(blockMap);
        assert (this.verify());
        this.startBlock = blockMap[0];
        if (this.debug.isLogEnabled()) {
            this.log(blockMap, "Before LivenessAnalysis");
        }
    }

    private boolean verify() {
        for (BciBlock block : this.blocks) {
            assert (this.blocks[block.getId()] == block);
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                BciBlock sux = block.getSuccessor(i);
                if (sux instanceof ExceptionDispatchBlock) assert (i == block.getSuccessorCount() - 1) : "Only one exception handler allowed, and it must be last in successors list";
            }
        }
        return true;
    }

    private void makeExceptionEntries(BciBlock[] blockMap) {
        for (ExceptionHandler h : this.exceptionHandlers) {
            BciBlock xhandler = this.makeBlock(blockMap, h.getHandlerBCI());
            xhandler.isExceptionEntry = true;
        }
    }

    private void iterateOverBytecodes(BciBlock[] blockMap, BytecodeStream stream) {
        BciBlock current = null;
        stream.setBCI(0);
        while (stream.currentBC() != 256) {
            int bci = stream.currentBCI();
            if (current == null || blockMap[bci] != null) {
                BciBlock b = this.makeBlock(blockMap, bci);
                if (current != null) {
                    BciBlockMapping.addSuccessor(blockMap, current.endBci, b);
                }
                current = b;
            }
            blockMap[bci] = current;
            current.endBci = bci;
            switch (stream.currentBC()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    current = null;
                    break;
                }
                case 191: {
                    current = null;
                    ExceptionDispatchBlock handler = this.handleExceptions(blockMap, bci);
                    if (handler == null) break;
                    BciBlockMapping.addSuccessor(blockMap, bci, handler);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.readBranchDest()));
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.nextBCI()));
                    break;
                }
                case 167: 
                case 200: {
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.readBranchDest()));
                    break;
                }
                case 170: {
                    current = null;
                    this.addSwitchSuccessors(blockMap, bci, new BytecodeTableSwitch(stream, bci));
                    break;
                }
                case 171: {
                    current = null;
                    this.addSwitchSuccessors(blockMap, bci, new BytecodeLookupSwitch(stream, bci));
                    break;
                }
                case 168: 
                case 201: {
                    this.hasJsrBytecodes = true;
                    int target = stream.readBranchDest();
                    if (target == 0) {
                        throw new JsrNotSupportedBailout("jsr target bci 0 not allowed");
                    }
                    BciBlock b1 = this.makeBlock(blockMap, target);
                    current.setJsrSuccessor(b1);
                    current.setJsrReturnBci(stream.nextBCI());
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, b1);
                    break;
                }
                case 169: {
                    current.setEndsWithRet();
                    current = null;
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.nextBCI()));
                    ExceptionDispatchBlock handler = this.handleExceptions(blockMap, bci);
                    if (handler == null) break;
                    BciBlockMapping.addSuccessor(blockMap, bci, handler);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 108: 
                case 109: 
                case 112: 
                case 113: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 192: 
                case 193: 
                case 194: 
                case 197: {
                    ExceptionDispatchBlock handler = this.handleExceptions(blockMap, bci);
                    if (handler == null) break;
                    current = null;
                    BciBlockMapping.addSuccessor(blockMap, bci, this.makeBlock(blockMap, stream.nextBCI()));
                    BciBlockMapping.addSuccessor(blockMap, bci, handler);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 195: {
                    break;
                }
                default: {
                    throw new GraalError("Unhandled bytecode");
                }
            }
            stream.next();
        }
    }

    private BciBlock makeBlock(BciBlock[] blockMap, int startBci) {
        BciBlock oldBlock = blockMap[startBci];
        if (oldBlock == null) {
            BciBlock newBlock = new BciBlock(startBci);
            ++this.blocksNotYetAssignedId;
            blockMap[startBci] = newBlock;
            return newBlock;
        }
        if (oldBlock.startBci != startBci) {
            BciBlock newBlock = new BciBlock(startBci);
            ++this.blocksNotYetAssignedId;
            newBlock.endBci = oldBlock.endBci;
            for (BciBlock oldSuccessor : oldBlock.getSuccessors()) {
                newBlock.addSuccessor(oldSuccessor);
            }
            oldBlock.endBci = startBci - 1;
            oldBlock.clearSucccessors();
            oldBlock.addSuccessor(newBlock);
            for (int i = startBci; i <= newBlock.endBci; ++i) {
                blockMap[i] = newBlock;
            }
            return newBlock;
        }
        return oldBlock;
    }

    private void addSwitchSuccessors(BciBlock[] blockMap, int predBci, BytecodeSwitch bswitch) {
        TreeSet<Integer> targets = new TreeSet<Integer>();
        for (int i = 0; i < bswitch.numberOfCases(); ++i) {
            targets.add(bswitch.targetAt(i));
        }
        targets.add(bswitch.defaultTarget());
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            int targetBci = (Integer)iterator.next();
            BciBlockMapping.addSuccessor(blockMap, predBci, this.makeBlock(blockMap, targetBci));
        }
    }

    private static void addSuccessor(BciBlock[] blockMap, int predBci, BciBlock sux) {
        BciBlock predecessor = blockMap[predBci];
        if (sux.isExceptionEntry) {
            throw new PermanentBailoutException("Exception handler can be reached by both normal and exceptional control flow");
        }
        predecessor.addSuccessor(sux);
    }

    private void createJsrAlternatives(BciBlock[] blockMap, BciBlock block) {
        this.jsrVisited.add(block);
        JsrScope scope = block.getJsrScope();
        if (block.endsWithRet()) {
            block.setRetSuccessor(blockMap[scope.nextReturnAddress()]);
            block.addSuccessor(block.getRetSuccessor());
            assert (block.getRetSuccessor() != block.getJsrSuccessor());
        }
        this.debug.log("JSR alternatives block %s  sux %s  jsrSux %s  retSux %s  jsrScope %s", block, block.getSuccessors(), (Object)block.getJsrSuccessor(), (Object)block.getRetSuccessor(), (Object)block.getJsrScope());
        if (block.getJsrSuccessor() != null || !scope.isEmpty()) {
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                BciBlock clone;
                BciBlock successor = block.getSuccessor(i);
                JsrScope nextScope = scope;
                if (successor == block.getJsrSuccessor()) {
                    nextScope = scope.push(block.getJsrReturnBci(), successor);
                }
                if (successor == block.getRetSuccessor()) {
                    nextScope = scope.pop();
                }
                if (!successor.getJsrScope().isPrefixOf(nextScope)) {
                    throw new JsrNotSupportedBailout("unstructured control flow  (" + successor.getJsrScope() + " " + nextScope + ")");
                }
                if (nextScope.isEmpty()) continue;
                if (successor.getJsrAlternatives() != null && successor.getJsrAlternatives().containsKey((Object)nextScope)) {
                    clone = (BciBlock)successor.getJsrAlternatives().get((Object)nextScope);
                } else {
                    successor.initJsrAlternatives();
                    clone = successor.copy();
                    ++this.blocksNotYetAssignedId;
                    clone.setJsrScope(nextScope);
                    successor.getJsrAlternatives().put((Object)nextScope, (Object)clone);
                }
                block.getSuccessors().set(i, clone);
                if (successor == block.getJsrSuccessor()) {
                    block.setJsrSuccessor(clone);
                }
                if (successor != block.getRetSuccessor()) continue;
                block.setRetSuccessor(clone);
            }
        }
        for (BciBlock successor : block.getSuccessors()) {
            if (this.jsrVisited.contains(successor) || !BciBlockMapping.shouldFollowEdge(successor, scope)) continue;
            this.createJsrAlternatives(blockMap, successor);
        }
    }

    private static boolean shouldFollowEdge(BciBlock successor, JsrScope scope) {
        if (successor instanceof ExceptionDispatchBlock && scope.getJsrEntryBlock() != null) {
            ExceptionDispatchBlock exceptionDispatchBlock = (ExceptionDispatchBlock)successor;
            int bci = scope.getJsrEntryBlock().startBci;
            if (exceptionDispatchBlock.handler.getStartBCI() < bci && bci < exceptionDispatchBlock.handler.getEndBCI()) {
                return false;
            }
        }
        return true;
    }

    private ExceptionDispatchBlock handleExceptions(BciBlock[] blockMap, int bci) {
        ExceptionDispatchBlock lastHandler = null;
        int dispatchBlocks = 0;
        for (int i = this.exceptionHandlers.length - 1; i >= 0; --i) {
            ExceptionHandler h = this.exceptionHandlers[i];
            if (h.getStartBCI() > bci || bci >= h.getEndBCI()) continue;
            if (h.isCatchAll()) {
                dispatchBlocks = 0;
                lastHandler = null;
            }
            ExceptionDispatchBlock curHandler = new ExceptionDispatchBlock(h, bci);
            ++dispatchBlocks;
            curHandler.addSuccessor(blockMap[h.getHandlerBCI()]);
            if (lastHandler != null) {
                curHandler.addSuccessor(lastHandler);
            }
            lastHandler = curHandler;
        }
        this.blocksNotYetAssignedId += dispatchBlocks;
        return lastHandler;
    }

    private void fixLoopBits(BciBlock[] blockMap) {
        do {
            this.loopChanges = false;
            for (BciBlock b : this.blocks) {
                b.visited = false;
            }
            long loop = this.fixLoopBits(blockMap[0]);
            if (loop == 0L) continue;
            throw new PermanentBailoutException("Non-reducible loop: %016x", loop);
        } while (this.loopChanges);
    }

    private void computeBlockOrder(BciBlock[] blockMap) {
        int maxBlocks = this.blocksNotYetAssignedId;
        this.blocks = new BciBlock[this.blocksNotYetAssignedId];
        long loop = this.computeBlockOrder(blockMap[0]);
        if (loop != 0L) {
            throw new PermanentBailoutException("Non-reducible loop");
        }
        int blockCount = maxBlocks - this.blocksNotYetAssignedId + 1;
        BciBlock[] newBlocks = new BciBlock[blockCount];
        int next = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            BciBlock b = this.blocks[i];
            if (b == null) continue;
            b.setId(next);
            newBlocks[next++] = b;
            if (!b.isLoopHeader) continue;
            next = this.handleLoopHeader(newBlocks, next, i, b);
        }
        assert (next == newBlocks.length - 1);
        ExceptionDispatchBlock unwindBlock = new ExceptionDispatchBlock(-4);
        unwindBlock.setId(newBlocks.length - 1);
        newBlocks[newBlocks.length - 1] = unwindBlock;
        this.blocks = newBlocks;
    }

    private int handleLoopHeader(BciBlock[] newBlocks, int nextStart, int i, BciBlock loopHeader) {
        int next = nextStart;
        int endOfLoop = nextStart - 1;
        for (int j = i + 1; j < this.blocks.length; ++j) {
            BciBlock other = this.blocks[j];
            if (other == null || (other.loops & 1L << loopHeader.loopId) == 0L) continue;
            other.setId(next);
            endOfLoop = next;
            newBlocks[next++] = other;
            this.blocks[j] = null;
            if (!other.isLoopHeader) continue;
            next = this.handleLoopHeader(newBlocks, next, j, other);
        }
        loopHeader.loopEnd = endOfLoop;
        return next;
    }

    public void log(BciBlock[] blockMap, String name) {
        if (this.debug.isLogEnabled()) {
            this.debug.log("%sBlockMap %s: %n%s", (Object)this.debug.getCurrentScopeName(), (Object)name, (Object)BciBlockMapping.toString(blockMap, this.loopHeaders));
        }
    }

    public static String toString(BciBlock[] blockMap, BciBlock[] loopHeadersMap) {
        StringBuilder sb = new StringBuilder();
        for (BciBlock b : blockMap) {
            if (b == null) continue;
            sb.append("B").append(b.getId()).append("[").append(b.startBci).append("..").append(b.endBci).append("]");
            if (b.isLoopHeader) {
                sb.append(" LoopHeader");
            }
            if (b.isExceptionEntry) {
                sb.append(" ExceptionEntry");
            }
            if (b instanceof ExceptionDispatchBlock) {
                sb.append(" ExceptionDispatch");
            }
            if (!b.successors.isEmpty()) {
                sb.append(" Successors=[");
                for (BciBlock s : b.getSuccessors()) {
                    if (sb.charAt(sb.length() - 1) != '[') {
                        sb.append(", ");
                    }
                    sb.append("B").append(s.getId());
                }
                sb.append("]");
            }
            if (b.loops != 0L) {
                sb.append(" Loops=[");
                Iterator<Object> iterator = b.loopIdIterable().iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    if (sb.charAt(sb.length() - 1) == '[') {
                        sb.append(", ");
                    }
                    sb.append("B").append(loopHeadersMap[pos].getId());
                }
                sb.append("]");
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return BciBlockMapping.toString(this.blocks, this.loopHeaders);
    }

    public BciBlock getLoopHeader(int index) {
        return this.loopHeaders[index];
    }

    private void makeLoopHeader(BciBlock block) {
        if (!block.isLoopHeader) {
            block.isLoopHeader = true;
            if (block.isExceptionEntry) {
                throw new PermanentBailoutException("Loop formed by an exception handler");
            }
            if (this.nextLoop >= 64) {
                throw new PermanentBailoutException("Too many loops in method");
            }
            assert (block.loops == 0L);
            block.loops = 1L << this.nextLoop;
            this.debug.log("makeLoopHeader(%s) -> %x", (Object)block, (Object)block.loops);
            if (this.loopHeaders == null) {
                this.loopHeaders = new BciBlock[4];
            } else if (this.nextLoop >= this.loopHeaders.length) {
                this.loopHeaders = Arrays.copyOf(this.loopHeaders, 64);
            }
            this.loopHeaders[this.nextLoop] = block;
            block.loopId = this.nextLoop++;
        }
        assert (Long.bitCount(block.loops) == 1);
    }

    private long computeBlockOrder(BciBlock initialBlock) {
        TraversalStep step;
        ArrayDeque<TraversalStep> workStack = new ArrayDeque<TraversalStep>();
        workStack.push(new TraversalStep(initialBlock));
        while (true) {
            TraversalStep traversalStep;
            TraversalStep traversalStep2;
            BciBlock successor;
            step = (TraversalStep)workStack.peek();
            BciBlock block = step.block;
            if (step.currentSuccessorIndex == 0) {
                block.visited = true;
                block.active = true;
            } else {
                successor = block.getSuccessor(step.currentSuccessorIndex - 1);
                if (successor.active) {
                    traversalStep2 = step;
                    traversalStep2.loops = traversalStep2.loops | 1L << successor.loopId;
                }
            }
            if (step.currentSuccessorIndex < block.successors.size()) {
                successor = block.getSuccessors().get(step.currentSuccessorIndex);
                if (successor.visited) {
                    if (successor.active) {
                        this.makeLoopHeader(successor);
                        traversalStep2 = step;
                        traversalStep2.loops = traversalStep2.loops | successor.loops;
                    } else if (successor.isLoopHeader) {
                        traversalStep2 = step;
                        traversalStep2.loops = traversalStep2.loops | successor.loops & (1L << successor.loopId ^ 0xFFFFFFFFFFFFFFFFL);
                    } else {
                        traversalStep2 = step;
                        traversalStep2.loops = traversalStep2.loops | successor.loops;
                    }
                } else {
                    workStack.push(new TraversalStep(successor));
                }
                step.currentSuccessorIndex++;
                continue;
            }
            block.loops = step.loops;
            this.debug.log("computeBlockOrder(%s) -> %x", (Object)block, (Object)block.loops);
            if (block.isLoopHeader) {
                traversalStep = step;
                traversalStep.loops = traversalStep.loops & (1L << block.loopId ^ 0xFFFFFFFFFFFFFFFFL);
            }
            block.active = false;
            --this.blocksNotYetAssignedId;
            this.blocks[this.blocksNotYetAssignedId] = block;
            workStack.pop();
            if (workStack.isEmpty()) break;
            traversalStep = (TraversalStep)workStack.peek();
            traversalStep.loops = traversalStep.loops | step.loops;
        }
        return step.loops;
    }

    private long fixLoopBits(BciBlock initialBlock) {
        TraversalStep step;
        ArrayDeque<TraversalStep> workStack = new ArrayDeque<TraversalStep>();
        workStack.push(new TraversalStep(initialBlock));
        while (true) {
            TraversalStep traversalStep;
            step = (TraversalStep)workStack.peek();
            BciBlock block = step.block;
            if (step.currentSuccessorIndex == 0) {
                block.visited = true;
                step.loops = block.loops;
            }
            if (step.currentSuccessorIndex < block.getSuccessors().size()) {
                BciBlock successor = block.getSuccessors().get(step.currentSuccessorIndex);
                if (successor.visited) {
                    TraversalStep traversalStep2;
                    if (successor.isLoopHeader) {
                        traversalStep2 = step;
                        traversalStep2.loops = traversalStep2.loops | successor.loops & (1L << successor.loopId ^ 0xFFFFFFFFFFFFFFFFL);
                    } else {
                        traversalStep2 = step;
                        traversalStep2.loops = traversalStep2.loops | successor.loops;
                    }
                } else {
                    workStack.push(new TraversalStep(successor));
                }
                step.currentSuccessorIndex++;
                continue;
            }
            if (block.loops != step.loops) {
                this.loopChanges = true;
                block.loops = step.loops;
                this.debug.log("fixLoopBits0(%s) -> %x", (Object)block, (Object)block.loops);
            }
            if (block.isLoopHeader) {
                traversalStep = step;
                traversalStep.loops = traversalStep.loops & (1L << block.loopId ^ 0xFFFFFFFFFFFFFFFFL);
            }
            workStack.pop();
            if (workStack.isEmpty()) break;
            traversalStep = (TraversalStep)workStack.peek();
            traversalStep.loops = traversalStep.loops | step.loops;
        }
        return step.loops;
    }

    public static BciBlockMapping create(BytecodeStream stream, Bytecode code, OptionValues options, DebugContext debug) {
        BciBlockMapping map = new BciBlockMapping(code, debug);
        map.build(stream, options);
        if (debug.isDumpEnabled(2)) {
            debug.dump(2, map, code.getMethod().format("After block building %f %R %H.%n(%P)"));
        }
        return map;
    }

    public BciBlock[] getLoopHeaders() {
        return this.loopHeaders;
    }

    public BciBlock getStartBlock() {
        return this.startBlock;
    }

    public ExceptionDispatchBlock getUnwindBlock() {
        return (ExceptionDispatchBlock)this.blocks[this.blocks.length - 1];
    }

    public int getLoopCount() {
        return this.nextLoop;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    private static final class TraversalStep {
        private BciBlock block;
        private int currentSuccessorIndex;
        private long loops;

        private TraversalStep(BciBlock block) {
            this.block = block;
            this.currentSuccessorIndex = 0;
            this.loops = 0L;
        }
    }

    public static class ExceptionDispatchBlock
    extends BciBlock {
        public final ExceptionHandler handler;
        public final int deoptBci;

        ExceptionDispatchBlock(ExceptionHandler handler, int deoptBci) {
            super(handler.getHandlerBCI());
            this.endBci = this.startBci;
            this.deoptBci = deoptBci;
            this.handler = handler;
        }

        ExceptionDispatchBlock(int deoptBci) {
            super(deoptBci);
            this.endBci = deoptBci;
            this.deoptBci = deoptBci;
            this.handler = null;
        }

        @Override
        public boolean isExceptionDispatch() {
            return true;
        }
    }

    public static class BciBlock
    implements Cloneable {
        int id;
        final int startBci;
        int endBci;
        private boolean isExceptionEntry;
        private boolean isLoopHeader;
        int loopId;
        int loopEnd;
        List<BciBlock> successors;
        private int predecessorCount;
        private boolean visited;
        private boolean active;
        long loops;
        JSRData jsrData;

        BciBlock(int startBci) {
            this.startBci = startBci;
            this.successors = new ArrayList<BciBlock>();
        }

        public int getStartBci() {
            return this.startBci;
        }

        public int getEndBci() {
            return this.endBci;
        }

        public long getLoops() {
            return this.loops;
        }

        public BciBlock exceptionDispatchBlock() {
            if (this.successors.size() > 0 && this.successors.get(this.successors.size() - 1) instanceof ExceptionDispatchBlock) {
                return this.successors.get(this.successors.size() - 1);
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public int getPredecessorCount() {
            return this.predecessorCount;
        }

        public int numNormalSuccessors() {
            if (this.exceptionDispatchBlock() != null) {
                return this.successors.size() - 1;
            }
            return this.successors.size();
        }

        public BciBlock copy() {
            try {
                BciBlock block = (BciBlock)super.clone();
                if (block.jsrData != null) {
                    block.jsrData = block.jsrData.copy();
                }
                block.successors = new ArrayList<BciBlock>(this.successors);
                return block;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("B").append(this.getId());
            sb.append('[').append(this.startBci).append("..").append(this.endBci);
            if (this.isLoopHeader || this.isExceptionEntry || this instanceof ExceptionDispatchBlock) {
                sb.append(' ');
                if (this.isLoopHeader) {
                    sb.append('L');
                }
                if (this.isExceptionEntry) {
                    sb.append('!');
                } else if (this instanceof ExceptionDispatchBlock) {
                    sb.append("<!>");
                }
            }
            sb.append(']');
            return sb.toString();
        }

        public int getLoopDepth() {
            return Long.bitCount(this.loops);
        }

        public boolean isLoopHeader() {
            return this.isLoopHeader;
        }

        public boolean isExceptionEntry() {
            return this.isExceptionEntry;
        }

        public BciBlock getSuccessor(int index) {
            return this.successors.get(index);
        }

        public int getLoopId() {
            long l = this.loops;
            if (l == 0L) {
                return -1;
            }
            int pos = 0;
            int lMask = 1;
            while ((l & (long)lMask) == 0L) {
                ++pos;
                lMask <<= 1;
            }
            return pos;
        }

        public Iterable<Integer> loopIdIterable() {
            return new Iterable<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return BciBlock.idIterator(loops);
                }
            };
        }

        private static Iterator<Integer> idIterator(final long field) {
            return new Iterator<Integer>(){
                long l;
                int pos;
                int lMask;
                {
                    this.l = field;
                    this.pos = 0;
                    this.lMask = 1;
                }

                @Override
                public Integer next() {
                    while ((this.l & (long)this.lMask) == 0L) {
                        ++this.pos;
                        this.lMask <<= 1;
                    }
                    this.l &= (long)(~this.lMask);
                    return this.pos;
                }

                @Override
                public boolean hasNext() {
                    return this.l != 0L;
                }
            };
        }

        public double probability() {
            return 1.0;
        }

        public BciBlock getPostdominator() {
            return null;
        }

        private JSRData getOrCreateJSRData() {
            if (this.jsrData == null) {
                this.jsrData = new JSRData();
            }
            return this.jsrData;
        }

        void setEndsWithRet() {
            this.getOrCreateJSRData().endsWithRet = true;
        }

        public JsrScope getJsrScope() {
            if (this.jsrData == null) {
                return JsrScope.EMPTY_SCOPE;
            }
            return this.jsrData.jsrScope;
        }

        public boolean endsWithRet() {
            if (this.jsrData == null) {
                return false;
            }
            return this.jsrData.endsWithRet;
        }

        void setRetSuccessor(BciBlock bciBlock) {
            this.getOrCreateJSRData().retSuccessor = bciBlock;
        }

        public BciBlock getRetSuccessor() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.retSuccessor;
        }

        public BciBlock getJsrSuccessor() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.jsrSuccessor;
        }

        public int getJsrReturnBci() {
            if (this.jsrData == null) {
                return -1;
            }
            return this.jsrData.jsrReturnBci;
        }

        public EconomicMap<JsrScope, BciBlock> getJsrAlternatives() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.jsrAlternatives;
        }

        public void initJsrAlternatives() {
            JSRData data = this.getOrCreateJSRData();
            if (data.jsrAlternatives == null) {
                data.jsrAlternatives = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            }
        }

        void setJsrScope(JsrScope nextScope) {
            this.getOrCreateJSRData().jsrScope = nextScope;
        }

        void setJsrSuccessor(BciBlock clone) {
            this.getOrCreateJSRData().jsrSuccessor = clone;
        }

        void setJsrReturnBci(int bci) {
            this.getOrCreateJSRData().jsrReturnBci = bci;
        }

        public int getSuccessorCount() {
            return this.successors.size();
        }

        public List<BciBlock> getSuccessors() {
            return this.successors;
        }

        void setId(int i) {
            this.id = i;
        }

        public void addSuccessor(BciBlock sux) {
            this.successors.add(sux);
            ++sux.predecessorCount;
        }

        public void clearSucccessors() {
            for (BciBlock sux : this.successors) {
                --sux.predecessorCount;
            }
            this.successors.clear();
        }

        public boolean isExceptionDispatch() {
            return false;
        }

        public static class JSRData
        implements Cloneable {
            public EconomicMap<JsrScope, BciBlock> jsrAlternatives;
            public JsrScope jsrScope = JsrScope.EMPTY_SCOPE;
            public BciBlock jsrSuccessor;
            public int jsrReturnBci;
            public BciBlock retSuccessor;
            public boolean endsWithRet = false;

            public JSRData copy() {
                try {
                    return (JSRData)this.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        }
    }
}

