/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;

public final class ComputeLoopFrequenciesClosure
extends ReentrantNodeIterator.NodeIteratorClosure<Double> {
    private static final ComputeLoopFrequenciesClosure INSTANCE = new ComputeLoopFrequenciesClosure();
    public static final ComputeLoopFrequencyPhase PHASE_INSTANCE = new ComputeLoopFrequencyPhase();

    private ComputeLoopFrequenciesClosure() {
    }

    @Override
    protected Double processNode(FixedNode node, Double currentState) {
        return currentState;
    }

    @Override
    protected Double merge(AbstractMergeNode merge, List<Double> states) {
        double result = 0.0;
        for (double d : states) {
            result += d;
        }
        return result;
    }

    @Override
    protected Double afterSplit(AbstractBeginNode node, Double oldState) {
        ControlSplitNode split = (ControlSplitNode)node.predecessor();
        return oldState * split.probability(node);
    }

    @Override
    protected EconomicMap<LoopExitNode, Double> processLoop(LoopBeginNode loop, Double initialState) {
        EconomicMap exitStates = ReentrantNodeIterator.processLoop(this, (LoopBeginNode)loop, Double.valueOf((double)1.0)).exitStates;
        double exitRelativeFrequency = 0.0;
        Iterator iterator = exitStates.getValues().iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            exitRelativeFrequency += d;
        }
        exitRelativeFrequency = Math.min(1.0, exitRelativeFrequency);
        exitRelativeFrequency = Math.max(3.054936363499605E-151, exitRelativeFrequency);
        double loopFrequency = 1.0 / exitRelativeFrequency;
        loop.setLoopFrequency(loopFrequency);
        double adjustmentFactor = initialState * loopFrequency;
        exitStates.replaceAll((exitNode, frequency) -> ControlFlowGraph.multiplyRelativeFrequencies(frequency, adjustmentFactor));
        return exitStates;
    }

    public static void compute(StructuredGraph graph) {
        if (graph.hasLoops()) {
            ReentrantNodeIterator.apply(INSTANCE, graph.start(), 1.0);
        }
    }

    public static class ComputeLoopFrequencyPhase
    extends Phase {
        @Override
        protected void run(StructuredGraph graph) {
            ComputeLoopFrequenciesClosure.compute(graph);
        }
    }
}

