/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.BitSet;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.LocalLiveness;

public final class LargeLocalLiveness
extends LocalLiveness {
    private BitSet[] localsLiveIn;
    private BitSet[] localsLiveOut;
    private BitSet[] localsLiveGen;
    private BitSet[] localsLiveKill;
    private BitSet[] localsChangedInLoop;

    public LargeLocalLiveness(BciBlockMapping.BciBlock[] blocks, int maxLocals, int loopCount) {
        super(blocks);
        int i;
        int blocksSize = blocks.length;
        this.localsLiveIn = new BitSet[blocksSize];
        this.localsLiveOut = new BitSet[blocksSize];
        this.localsLiveGen = new BitSet[blocksSize];
        this.localsLiveKill = new BitSet[blocksSize];
        for (i = 0; i < blocksSize; ++i) {
            this.localsLiveIn[i] = new BitSet(maxLocals);
            this.localsLiveOut[i] = new BitSet(maxLocals);
            this.localsLiveGen[i] = new BitSet(maxLocals);
            this.localsLiveKill[i] = new BitSet(maxLocals);
        }
        this.localsChangedInLoop = new BitSet[loopCount];
        for (i = 0; i < loopCount; ++i) {
            this.localsChangedInLoop[i] = new BitSet(maxLocals);
        }
    }

    @Override
    protected String debugLiveIn(int blockID) {
        return this.localsLiveIn[blockID].toString();
    }

    @Override
    protected String debugLiveOut(int blockID) {
        return this.localsLiveOut[blockID].toString();
    }

    @Override
    protected String debugLiveGen(int blockID) {
        return this.localsLiveGen[blockID].toString();
    }

    @Override
    protected String debugLiveKill(int blockID) {
        return this.localsLiveKill[blockID].toString();
    }

    @Override
    protected int liveOutCardinality(int blockID) {
        return this.localsLiveOut[blockID].cardinality();
    }

    @Override
    protected void propagateLiveness(int blockID, int successorID) {
        this.localsLiveOut[blockID].or(this.localsLiveIn[successorID]);
    }

    @Override
    protected void updateLiveness(int blockID) {
        BitSet liveIn = this.localsLiveIn[blockID];
        liveIn.clear();
        liveIn.or(this.localsLiveOut[blockID]);
        liveIn.andNot(this.localsLiveKill[blockID]);
        liveIn.or(this.localsLiveGen[blockID]);
    }

    @Override
    protected void loadOne(int blockID, int local) {
        if (!this.localsLiveKill[blockID].get(local)) {
            this.localsLiveGen[blockID].set(local);
        }
    }

    @Override
    protected void storeOne(int blockID, int local) {
        if (!this.localsLiveGen[blockID].get(local)) {
            this.localsLiveKill[blockID].set(local);
        }
        BciBlockMapping.BciBlock block = this.blocks[blockID];
        long tmp = block.loops;
        int pos = 0;
        while (tmp != 0L) {
            if ((tmp & 1L) == 1L) {
                this.localsChangedInLoop[pos].set(local);
            }
            tmp >>>= 1;
            ++pos;
        }
    }

    @Override
    public boolean localIsLiveIn(BciBlockMapping.BciBlock block, int local) {
        return block.getId() >= Integer.MAX_VALUE ? true : this.localsLiveIn[block.getId()].get(local);
    }

    @Override
    public boolean localIsLiveOut(BciBlockMapping.BciBlock block, int local) {
        return block.getId() >= Integer.MAX_VALUE ? true : this.localsLiveOut[block.getId()].get(local);
    }

    @Override
    public boolean localIsChangedInLoop(int loopId, int local) {
        return this.localsChangedInLoop[loopId].get(local);
    }
}

