/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.options.OptionValues;

public final class LIR
extends LIRGenerator.VariableProvider {
    private final AbstractControlFlowGraph<?> cfg;
    private final AbstractBlockBase<?>[] linearScanOrder;
    private final AbstractBlockBase<?>[] codeEmittingOrder;
    private final BlockMap<ArrayList<LIRInstruction>> lirInstructions;
    private boolean hasArgInCallerFrame;
    private final OptionValues options;
    private final DebugContext debug;
    public static final int MAX_EXCEPTION_EDGE_OP_DISTANCE_FROM_END = 3;

    public LIR(AbstractControlFlowGraph<?> cfg, AbstractBlockBase<?>[] linearScanOrder, AbstractBlockBase<?>[] codeEmittingOrder, OptionValues options, DebugContext debug) {
        this.cfg = cfg;
        this.codeEmittingOrder = codeEmittingOrder;
        this.linearScanOrder = linearScanOrder;
        this.lirInstructions = new BlockMap(cfg);
        this.options = options;
        this.debug = debug;
    }

    public AbstractControlFlowGraph<?> getControlFlowGraph() {
        return this.cfg;
    }

    public OptionValues getOptions() {
        return this.options;
    }

    public DebugContext getDebug() {
        return this.debug;
    }

    public boolean hasDebugInfo() {
        for (AbstractBlockBase<?> b : this.linearScanOrder()) {
            for (LIRInstruction op : this.getLIRforBlock(b)) {
                if (!op.hasState()) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<LIRInstruction> getLIRforBlock(AbstractBlockBase<?> block) {
        return this.lirInstructions.get(block);
    }

    public void setLIRforBlock(AbstractBlockBase<?> block, ArrayList<LIRInstruction> list) {
        assert (this.getLIRforBlock(block) == null) : "lir instruction list should only be initialized once";
        this.lirInstructions.put(block, list);
    }

    public AbstractBlockBase<?>[] linearScanOrder() {
        return this.linearScanOrder;
    }

    public AbstractBlockBase<?>[] codeEmittingOrder() {
        return this.codeEmittingOrder;
    }

    public void setHasArgInCallerFrame() {
        this.hasArgInCallerFrame = true;
    }

    public boolean hasArgInCallerFrame() {
        return this.hasArgInCallerFrame;
    }

    public static AbstractBlockBase<?> getNextBlock(AbstractBlockBase<?>[] blocks, int blockIndex) {
        for (int nextIndex = blockIndex + 1; nextIndex > 0 && nextIndex < blocks.length; ++nextIndex) {
            AbstractBlockBase<?> nextBlock = blocks[nextIndex];
            if (nextBlock == null) continue;
            return nextBlock;
        }
        return null;
    }

    public static LabelRef getExceptionEdge(LIRInstruction op) {
        LabelRef[] exceptionEdge = new LabelRef[]{null};
        op.forEachState(state -> {
            if (state.exceptionEdge != null) {
                assert (exceptionEdge[0] == null);
                exceptionEdge[0] = state.exceptionEdge;
            }
        });
        return exceptionEdge[0];
    }

    public static boolean verifyBlock(LIR lir, AbstractBlockBase<?> block) {
        ArrayList<LIRInstruction> ops = lir.getLIRforBlock(block);
        if (ops.size() == 0) {
            return false;
        }
        assert (ops.get(0) instanceof StandardOp.LabelOp) : String.format("Not a Label %s (Block %s)", ops.get(0).getClass(), block);
        LIRInstruction opWithExceptionEdge = null;
        int index = 0;
        int lastIndex = ops.size() - 1;
        for (LIRInstruction op : ops.subList(0, lastIndex)) {
            assert (!(op instanceof StandardOp.BlockEndOp)) : String.format("BlockEndOp %s (Block %s)", op.getClass(), block);
            LabelRef exceptionEdge = LIR.getExceptionEdge(op);
            if (exceptionEdge != null) {
                assert (opWithExceptionEdge == null) : "multiple ops with an exception edge not allowed";
                opWithExceptionEdge = op;
                int distanceFromEnd = lastIndex - index;
                assert (distanceFromEnd <= 3);
            }
            ++index;
        }
        LIRInstruction end = ops.get(lastIndex);
        assert (end instanceof StandardOp.BlockEndOp) : String.format("Not a BlockEndOp %s (Block %s)", end.getClass(), block);
        return true;
    }

    public static boolean verifyBlocks(LIR lir, AbstractBlockBase<?>[] blocks) {
        for (AbstractBlockBase<?> block : blocks) {
            if (block == null) continue;
            for (AbstractBlockBase sux : block.getSuccessors()) {
                assert (Arrays.asList(blocks).contains(sux)) : "missing successor from: " + block + "to: " + sux;
            }
            for (AbstractBlockBase pred : block.getPredecessors()) {
                assert (Arrays.asList(blocks).contains(pred)) : "missing predecessor from: " + block + "to: " + pred;
            }
            if (LIR.verifyBlock(lir, block)) continue;
            return false;
        }
        return true;
    }

    public void resetLabels() {
        for (AbstractBlockBase<?> block : this.codeEmittingOrder()) {
            if (block == null) continue;
            for (LIRInstruction inst : this.lirInstructions.get(block)) {
                Label label;
                if (!(inst instanceof StandardOp.LabelHoldingOp) || (label = ((StandardOp.LabelHoldingOp)((Object)inst)).getLabel()) == null) continue;
                label.reset();
            }
        }
    }
}

