/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.InstructionStateProcedure;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StateProcedure;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.ValueProcedure;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;

public abstract class LIRInstruction {
    protected static final EnumMap<OperandMode, EnumSet<OperandFlag>> ALLOWED_FLAGS = new EnumMap(OperandMode.class);
    protected static final EnumSet<OperandFlag> ADDRESS_FLAGS;
    private final LIRInstructionClass<?> instructionClass;
    private int id;
    private NodeSourcePosition position;

    public LIRInstruction(LIRInstructionClass<? extends LIRInstruction> c) {
        this.instructionClass = c;
        assert (c.getClazz() == this.getClass());
        this.id = -1;
    }

    public abstract void emitCode(CompilationResultBuilder var1);

    public final int id() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final NodeSourcePosition getPosition() {
        return this.position;
    }

    public final void setPosition(NodeSourcePosition position) {
        this.position = position;
    }

    public final String name() {
        return this.instructionClass.getOpcode(this);
    }

    public final boolean hasOperands() {
        return this.instructionClass.hasOperands() || this.hasState() || this.destroysCallerSavedRegisters();
    }

    public final boolean hasState() {
        return this.instructionClass.hasState(this);
    }

    public boolean destroysCallerSavedRegisters() {
        return false;
    }

    public final void forEachInput(InstructionValueProcedure proc) {
        this.instructionClass.forEachUse(this, proc);
    }

    public final void forEachAlive(InstructionValueProcedure proc) {
        this.instructionClass.forEachAlive(this, proc);
    }

    public final void forEachTemp(InstructionValueProcedure proc) {
        this.instructionClass.forEachTemp(this, proc);
    }

    public final void forEachOutput(InstructionValueProcedure proc) {
        this.instructionClass.forEachDef(this, proc);
    }

    public final void forEachState(InstructionValueProcedure proc) {
        this.instructionClass.forEachState(this, proc);
    }

    public final void forEachInput(ValueProcedure proc) {
        this.instructionClass.forEachUse(this, proc);
    }

    public final void forEachAlive(ValueProcedure proc) {
        this.instructionClass.forEachAlive(this, proc);
    }

    public final void forEachTemp(ValueProcedure proc) {
        this.instructionClass.forEachTemp(this, proc);
    }

    public final void forEachOutput(ValueProcedure proc) {
        this.instructionClass.forEachDef(this, proc);
    }

    public final void forEachState(ValueProcedure proc) {
        this.instructionClass.forEachState(this, proc);
    }

    public final void forEachState(InstructionStateProcedure proc) {
        this.instructionClass.forEachState(this, proc);
    }

    public final void forEachState(StateProcedure proc) {
        this.instructionClass.forEachState(this, proc);
    }

    public final void visitEachInput(InstructionValueConsumer proc) {
        this.instructionClass.visitEachUse(this, proc);
    }

    public final void visitEachAlive(InstructionValueConsumer proc) {
        this.instructionClass.visitEachAlive(this, proc);
    }

    public final void visitEachTemp(InstructionValueConsumer proc) {
        this.instructionClass.visitEachTemp(this, proc);
    }

    public final void visitEachOutput(InstructionValueConsumer proc) {
        this.instructionClass.visitEachDef(this, proc);
    }

    public final void visitEachState(InstructionValueConsumer proc) {
        this.instructionClass.visitEachState(this, proc);
    }

    public final void visitEachInput(ValueConsumer proc) {
        this.instructionClass.visitEachUse(this, proc);
    }

    public final void visitEachAlive(ValueConsumer proc) {
        this.instructionClass.visitEachAlive(this, proc);
    }

    public final void visitEachTemp(ValueConsumer proc) {
        this.instructionClass.visitEachTemp(this, proc);
    }

    public final void visitEachOutput(ValueConsumer proc) {
        this.instructionClass.visitEachDef(this, proc);
    }

    public final void visitEachState(ValueConsumer proc) {
        this.instructionClass.visitEachState(this, proc);
    }

    public final Value forEachRegisterHint(Value value, OperandMode mode, InstructionValueProcedure proc) {
        return this.instructionClass.forEachRegisterHint(this, mode, proc);
    }

    public final Value forEachRegisterHint(Value value, OperandMode mode, ValueProcedure proc) {
        return this.instructionClass.forEachRegisterHint(this, mode, proc);
    }

    public final boolean isMoveOp() {
        return this.instructionClass.isMoveOp();
    }

    public final boolean isValueMoveOp() {
        return this.instructionClass.isValueMoveOp();
    }

    public final boolean isLoadConstantOp() {
        return this.instructionClass.isLoadConstantOp();
    }

    protected static Value[] addStackSlotsToTemporaries(Value[] parameters, Value[] temporaries) {
        int extraTemps = 0;
        for (Value p : parameters) {
            if (ValueUtil.isStackSlot((Value)p)) {
                ++extraTemps;
            }
            assert (!LIRValueUtil.isVirtualStackSlot(p)) : "only real stack slots in calling convention";
        }
        if (extraTemps != 0) {
            int index = temporaries.length;
            Value[] newTemporaries = Arrays.copyOf(temporaries, temporaries.length + extraTemps);
            for (Value p : parameters) {
                if (!ValueUtil.isStackSlot((Value)p)) continue;
                newTemporaries[index++] = p;
            }
            return newTemporaries;
        }
        return temporaries;
    }

    public void verify() {
    }

    public final void setComment(LIRGenerationResult res, String comment) {
        res.setComment(this, comment);
    }

    public final String getComment(LIRGenerationResult res) {
        return res.getComment(this);
    }

    public final String toStringWithIdPrefix() {
        if (this.id != -1) {
            return String.format("%4d %s", this.id, this.toString());
        }
        return "     " + this.toString();
    }

    public String toString() {
        return this.instructionClass.toString(this);
    }

    public String toString(LIRGenerationResult res) {
        String toString = this.toString();
        if (res == null) {
            return toString;
        }
        String comment = this.getComment(res);
        if (comment == null) {
            return toString;
        }
        return String.format("%s // %s", toString, comment);
    }

    public LIRInstructionClass<?> getLIRInstructionClass() {
        return this.instructionClass;
    }

    public int hashCode() {
        return this.id;
    }

    static {
        ALLOWED_FLAGS.put(OperandMode.USE, EnumSet.of(OperandFlag.REG, new OperandFlag[]{OperandFlag.STACK, OperandFlag.COMPOSITE, OperandFlag.CONST, OperandFlag.ILLEGAL, OperandFlag.HINT, OperandFlag.UNINITIALIZED}));
        ALLOWED_FLAGS.put(OperandMode.ALIVE, EnumSet.of(OperandFlag.REG, new OperandFlag[]{OperandFlag.STACK, OperandFlag.COMPOSITE, OperandFlag.CONST, OperandFlag.ILLEGAL, OperandFlag.HINT, OperandFlag.UNINITIALIZED, OperandFlag.OUTGOING}));
        ALLOWED_FLAGS.put(OperandMode.TEMP, EnumSet.of(OperandFlag.REG, OperandFlag.STACK, OperandFlag.COMPOSITE, OperandFlag.ILLEGAL, OperandFlag.HINT));
        ALLOWED_FLAGS.put(OperandMode.DEF, EnumSet.of(OperandFlag.REG, OperandFlag.STACK, OperandFlag.COMPOSITE, OperandFlag.ILLEGAL, OperandFlag.HINT));
        ADDRESS_FLAGS = EnumSet.of(OperandFlag.REG, OperandFlag.ILLEGAL);
    }

    public static enum OperandFlag {
        REG,
        STACK,
        COMPOSITE,
        CONST,
        ILLEGAL,
        HINT,
        UNINITIALIZED,
        OUTGOING;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface State {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Def {
        public OperandFlag[] value() default {OperandFlag.REG};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Temp {
        public OperandFlag[] value() default {OperandFlag.REG};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Alive {
        public OperandFlag[] value() default {OperandFlag.REG};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Use {
        public OperandFlag[] value() default {OperandFlag.REG};
    }

    public static enum OperandMode {
        USE,
        ALIVE,
        TEMP,
        DEF;

    }
}

