/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public final class NullCheckOptimizer
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR ir = lirGenRes.getLIR();
        AbstractBlockBase<?>[] blocks = ir.codeEmittingOrder();
        NullCheckOptimizer.foldNullChecks(ir, blocks, target.implicitNullCheckLimit);
    }

    private static void foldNullChecks(LIR ir, AbstractBlockBase<?>[] blocks, int implicitNullCheckLimit) {
        for (AbstractBlockBase<?> block : blocks) {
            ArrayList<LIRInstruction> list;
            if (block == null || (list = ir.getLIRforBlock(block)).isEmpty()) continue;
            LIRInstruction lastInstruction = list.get(0);
            for (int i = 0; i < list.size(); ++i) {
                StandardOp.NullCheck nullCheck;
                StandardOp.ImplicitNullCheck implicitNullCheck;
                LIRInstruction instruction = list.get(i);
                if (instruction instanceof StandardOp.ImplicitNullCheck && lastInstruction instanceof StandardOp.NullCheck && (implicitNullCheck = (StandardOp.ImplicitNullCheck)((Object)instruction)).makeNullCheckFor((nullCheck = (StandardOp.NullCheck)((Object)lastInstruction)).getCheckedValue(), nullCheck.getState(), implicitNullCheckLimit)) {
                    list.remove(i - 1);
                    if (i < list.size()) {
                        instruction = list.get(i);
                    }
                }
                lastInstruction = instruction;
            }
        }
    }
}

