/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="BSWAP")
public final class AArch64ByteSwapOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ByteSwapOp> TYPE = LIRInstructionClass.create(AArch64ByteSwapOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected Value result;
    @LIRInstruction.Use
    protected Value input;

    public AArch64ByteSwapOp(Value result, Value input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        switch ((AArch64Kind)this.input.getPlatformKind()) {
            case DWORD: {
                masm.rev(32, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
                break;
            }
            case QWORD: {
                masm.rev(64, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }
}

