/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="SIGNEXTEND")
public class AArch64SignExtendOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64SignExtendOp> TYPE = LIRInstructionClass.create(AArch64SignExtendOp.class);
    @LIRInstruction.Def
    protected AllocatableValue resultValue;
    @LIRInstruction.Use
    protected AllocatableValue inputValue;
    private final int fromBits;
    private final int toBits;

    public AArch64SignExtendOp(AllocatableValue resultValue, AllocatableValue inputValue, int fromBits, int toBits) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.resultValue = resultValue;
        this.inputValue = inputValue;
        this.fromBits = fromBits;
        this.toBits = toBits;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register input = ValueUtil.asRegister((Value)this.inputValue);
        masm.sxt(this.toBits <= 32 ? 32 : 64, this.fromBits, result, input);
    }
}

