/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.Objects;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="ARRAY_EQUALS")
public final class AMD64ArrayEqualsOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ArrayEqualsOp> TYPE = LIRInstructionClass.create(AMD64ArrayEqualsOp.class);
    private final JavaKind kind1;
    private final JavaKind kind2;
    private final int arrayBaseOffset1;
    private final int arrayBaseOffset2;
    private final AMD64Address.Scale arrayIndexScale1;
    private final AMD64Address.Scale arrayIndexScale2;
    private final AVXKind.AVXSize vectorSize;
    private final boolean signExtend;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value array2Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
    private Value lengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value temp5;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value tempXMM;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value vectorTemp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value vectorTemp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value vectorTemp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value vectorTemp4;
    private static final int VECTOR_SIZE = 8;

    public AMD64ArrayEqualsOp(LIRGeneratorTool tool, JavaKind kind1, JavaKind kind2, Value result, Value array1, Value array2, Value length, boolean directPointers, int maxVectorSize) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.kind1 = kind1;
        this.kind2 = kind2;
        boolean bl = this.signExtend = kind1 != JavaKind.Char && kind2 != JavaKind.Char;
        assert (kind1.isNumericInteger() && kind2.isNumericInteger() || kind1 == kind2);
        this.arrayBaseOffset1 = directPointers ? 0 : tool.getProviders().getMetaAccess().getArrayBaseOffset(kind1);
        this.arrayBaseOffset2 = directPointers ? 0 : tool.getProviders().getMetaAccess().getArrayBaseOffset(kind2);
        this.arrayIndexScale1 = Objects.requireNonNull(AMD64Address.Scale.fromInt(tool.getProviders().getMetaAccess().getArrayIndexScale(kind1)));
        this.arrayIndexScale2 = Objects.requireNonNull(AMD64Address.Scale.fromInt(tool.getProviders().getMetaAccess().getArrayIndexScale(kind2)));
        this.vectorSize = ((AMD64)tool.target().arch).getFeatures().contains(AMD64.CPUFeature.AVX2) && (maxVectorSize < 0 || maxVectorSize >= 32) ? AVXKind.AVXSize.YMM : AVXKind.AVXSize.XMM;
        this.resultValue = result;
        this.array1Value = array1;
        this.array2Value = array2;
        this.lengthValue = length;
        if (AMD64ArrayEqualsOp.supportsSSE41(tool.target()) && this.canGenerateConstantLengthCompare(tool.target()) && !this.constantLengthCompareNeedsTmpArrayPointers()) {
            this.temp1 = Value.ILLEGAL;
            this.temp2 = Value.ILLEGAL;
        } else {
            this.temp1 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
            this.temp2 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        }
        this.temp3 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
        if (AMD64ArrayEqualsOp.supportsSSE41(tool.target()) && this.canGenerateConstantLengthCompare(tool.target())) {
            this.temp4 = Value.ILLEGAL;
            this.temp5 = Value.ILLEGAL;
        } else {
            this.temp4 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
            AllocatableValue allocatableValue = this.temp5 = kind1.isNumericFloat() || kind1 != kind2 ? tool.newVariable(LIRKind.value(tool.target().arch.getWordKind())) : Value.ILLEGAL;
        }
        this.tempXMM = kind1 == JavaKind.Float ? tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.SINGLE)) : (kind1 == JavaKind.Double ? tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DOUBLE)) : Value.ILLEGAL);
        if (AMD64ArrayEqualsOp.supportsSSE41(tool.target())) {
            if (this.canGenerateConstantLengthCompare(tool.target())) {
                LIRKind lirKind = LIRKind.value((PlatformKind)(this.vectorSize == AVXKind.AVXSize.YMM ? AMD64Kind.V256_BYTE : AMD64Kind.V128_BYTE));
                this.vectorTemp1 = tool.newVariable(lirKind);
                this.vectorTemp2 = tool.newVariable(lirKind);
                this.vectorTemp3 = tool.newVariable(lirKind);
                this.vectorTemp4 = tool.newVariable(lirKind);
            } else {
                this.vectorTemp1 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DOUBLE));
                this.vectorTemp2 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DOUBLE));
                this.vectorTemp3 = Value.ILLEGAL;
                this.vectorTemp4 = Value.ILLEGAL;
            }
        } else {
            this.vectorTemp1 = Value.ILLEGAL;
            this.vectorTemp2 = Value.ILLEGAL;
            this.vectorTemp3 = Value.ILLEGAL;
            this.vectorTemp4 = Value.ILLEGAL;
        }
    }

    private boolean canGenerateConstantLengthCompare(TargetDescription target) {
        return LIRValueUtil.isJavaConstant(this.lengthValue) && this.kind1.isNumericInteger() && (this.kind1 == this.kind2 || this.getElementsPerVector(AVXKind.AVXSize.XMM) <= this.constantLength()) && AMD64ArrayEqualsOp.supportsSSE41(target);
    }

    private int constantLength() {
        return LIRValueUtil.asJavaConstant(this.lengthValue).asInt();
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Label trueLabel = new Label();
        Label falseLabel = new Label();
        Label done = new Label();
        if (this.canGenerateConstantLengthCompare(crb.target)) {
            this.emitConstantLengthArrayCompareBytes(crb, masm, new Register[]{ValueUtil.asRegister((Value)this.vectorTemp1), ValueUtil.asRegister((Value)this.vectorTemp2), ValueUtil.asRegister((Value)this.vectorTemp3), ValueUtil.asRegister((Value)this.vectorTemp4)}, falseLabel);
        } else {
            Register array1 = ValueUtil.asRegister((Value)this.temp1);
            Register array2 = ValueUtil.asRegister((Value)this.temp2);
            masm.leaq(array1, new AMD64Address(ValueUtil.asRegister((Value)this.array1Value), this.arrayBaseOffset1));
            masm.leaq(array2, new AMD64Address(ValueUtil.asRegister((Value)this.array2Value), this.arrayBaseOffset2));
            Register length = ValueUtil.asRegister((Value)this.temp3);
            if (LIRValueUtil.isJavaConstant(this.lengthValue)) {
                masm.movl(length, this.constantLength());
            } else {
                masm.movl(length, ValueUtil.asRegister((Value)this.lengthValue));
            }
            masm.movl(result, length);
            this.emitArrayCompare(crb, masm, result, array1, array2, length, trueLabel, falseLabel);
        }
        masm.bind(trueLabel);
        masm.movl(result, 1);
        masm.jmpb(done);
        masm.bind(falseLabel);
        masm.xorl(result, result);
        masm.bind(done);
    }

    private void emitArrayCompare(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label trueLabel, Label falseLabel) {
        if (AMD64ArrayEqualsOp.supportsSSE41(crb.target)) {
            this.emitVectorCompare(crb, masm, result, array1, array2, length, trueLabel, falseLabel);
        }
        if (this.kind1 == this.kind2) {
            this.emit8ByteCompare(crb, masm, result, array1, array2, length, trueLabel, falseLabel);
            this.emitTailCompares(masm, result, array1, array2, length, trueLabel, falseLabel);
        } else {
            this.emitDifferentKindsElementWiseCompare(crb, masm, result, array1, array2, length, trueLabel, falseLabel);
        }
    }

    private static boolean supportsSSE41(TargetDescription target) {
        AMD64 arch = (AMD64)target.arch;
        return arch.getFeatures().contains(AMD64.CPUFeature.SSE4_1);
    }

    private void emitVectorCompare(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label trueLabel, Label falseLabel) {
        assert (AMD64ArrayEqualsOp.supportsSSE41(crb.target));
        Register vector1 = ValueUtil.asRegister((Value)this.vectorTemp1);
        Register vector2 = ValueUtil.asRegister((Value)this.vectorTemp2);
        int elementsPerVector = this.getElementsPerVector(this.vectorSize);
        Label loop = new Label();
        Label compareTail = new Label();
        boolean requiresNaNCheck = this.kind1.isNumericFloat();
        Label loopCheck = new Label();
        Label nanCheck = new Label();
        masm.andl(result, elementsPerVector - 1);
        masm.andl(length, ~(elementsPerVector - 1));
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, compareTail);
        masm.leaq(array1, new AMD64Address(array1, length, this.arrayIndexScale1, 0));
        masm.leaq(array2, new AMD64Address(array2, length, this.arrayIndexScale2, 0));
        masm.negq(length);
        masm.align(crb.target.wordSize * 2);
        masm.bind(loop);
        this.emitVectorLoad1(masm, vector1, array1, length, 0, this.vectorSize);
        this.emitVectorLoad2(masm, vector2, array2, length, 0, this.vectorSize);
        AMD64ArrayEqualsOp.emitVectorCmp(masm, vector1, vector2, this.vectorSize);
        masm.jcc(AMD64Assembler.ConditionFlag.NotZero, requiresNaNCheck ? nanCheck : falseLabel);
        masm.bind(loopCheck);
        masm.addq(length, elementsPerVector);
        masm.jcc(AMD64Assembler.ConditionFlag.NotZero, loop);
        masm.testl(result, result);
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, trueLabel);
        if (requiresNaNCheck) {
            Label unalignedCheck = new Label();
            masm.jmpb(unalignedCheck);
            masm.bind(nanCheck);
            this.emitFloatCompareWithinRange(crb, masm, array1, array2, length, 0, falseLabel, elementsPerVector);
            masm.jmpb(loopCheck);
            masm.bind(unalignedCheck);
        }
        this.emitVectorLoad1(masm, vector1, array1, result, this.scaleDisplacement1(-this.vectorSize.getBytes()), this.vectorSize);
        this.emitVectorLoad2(masm, vector2, array2, result, this.scaleDisplacement2(-this.vectorSize.getBytes()), this.vectorSize);
        AMD64ArrayEqualsOp.emitVectorCmp(masm, vector1, vector2, this.vectorSize);
        if (requiresNaNCheck) {
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, trueLabel);
            this.emitFloatCompareWithinRange(crb, masm, array1, array2, result, -this.vectorSize.getBytes(), falseLabel, elementsPerVector);
        } else {
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, falseLabel);
        }
        masm.jmp(trueLabel);
        masm.bind(compareTail);
        masm.movl(length, result);
    }

    private int getElementsPerVector(AVXKind.AVXSize vSize) {
        return vSize.getBytes() >> Math.max(this.arrayIndexScale1.log2, this.arrayIndexScale2.log2);
    }

    private void emitVectorLoad1(AMD64MacroAssembler asm, Register dst, Register src, int displacement, AVXKind.AVXSize size) {
        this.emitVectorLoad1(asm, dst, src, Register.None, displacement, size);
    }

    private void emitVectorLoad2(AMD64MacroAssembler asm, Register dst, Register src, int displacement, AVXKind.AVXSize size) {
        this.emitVectorLoad2(asm, dst, src, Register.None, displacement, size);
    }

    private void emitVectorLoad1(AMD64MacroAssembler asm, Register dst, Register src, Register index, int displacement, AVXKind.AVXSize size) {
        this.emitVectorLoad(asm, dst, src, index, displacement, this.arrayIndexScale1, this.arrayIndexScale2, size);
    }

    private void emitVectorLoad2(AMD64MacroAssembler asm, Register dst, Register src, Register index, int displacement, AVXKind.AVXSize size) {
        this.emitVectorLoad(asm, dst, src, index, displacement, this.arrayIndexScale2, this.arrayIndexScale1, size);
    }

    private void emitVectorLoad(AMD64MacroAssembler asm, Register dst, Register src, Register index, int displacement, AMD64Address.Scale ownScale, AMD64Address.Scale otherScale, AVXKind.AVXSize size) {
        AMD64Address address = new AMD64Address(src, index, ownScale, displacement);
        if (ownScale.value < otherScale.value) {
            if (size == AVXKind.AVXSize.YMM) {
                AMD64ArrayEqualsOp.getAVX2LoadAndExtendOp(ownScale, otherScale, this.signExtend).emit((AMD64Assembler)asm, size, dst, address);
            } else {
                AMD64ArrayEqualsOp.loadAndExtendSSE(asm, dst, address, ownScale, otherScale, this.signExtend);
            }
        } else if (size == AVXKind.AVXSize.YMM) {
            asm.vmovdqu(dst, address);
        } else {
            asm.movdqu(dst, address);
        }
    }

    private int scaleDisplacement1(int displacement) {
        return AMD64ArrayEqualsOp.scaleDisplacement(displacement, this.arrayIndexScale1, this.arrayIndexScale2);
    }

    private int scaleDisplacement2(int displacement) {
        return AMD64ArrayEqualsOp.scaleDisplacement(displacement, this.arrayIndexScale2, this.arrayIndexScale1);
    }

    private static int scaleDisplacement(int displacement, AMD64Address.Scale ownScale, AMD64Address.Scale otherScale) {
        if (ownScale.value < otherScale.value) {
            return displacement >> otherScale.log2 - ownScale.log2;
        }
        return displacement;
    }

    private static AMD64Assembler.VexRMOp getAVX2LoadAndExtendOp(AMD64Address.Scale ownScale, AMD64Address.Scale otherScale, boolean signExtend) {
        switch (ownScale) {
            case Times1: {
                switch (otherScale) {
                    case Times2: {
                        return signExtend ? AMD64Assembler.VexRMOp.VPMOVSXBW : AMD64Assembler.VexRMOp.VPMOVZXBW;
                    }
                    case Times4: {
                        return signExtend ? AMD64Assembler.VexRMOp.VPMOVSXBD : AMD64Assembler.VexRMOp.VPMOVZXBD;
                    }
                    case Times8: {
                        return signExtend ? AMD64Assembler.VexRMOp.VPMOVSXBQ : AMD64Assembler.VexRMOp.VPMOVZXBQ;
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            case Times2: {
                switch (otherScale) {
                    case Times4: {
                        return signExtend ? AMD64Assembler.VexRMOp.VPMOVSXWD : AMD64Assembler.VexRMOp.VPMOVZXWD;
                    }
                    case Times8: {
                        return signExtend ? AMD64Assembler.VexRMOp.VPMOVSXWQ : AMD64Assembler.VexRMOp.VPMOVZXWQ;
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            case Times4: {
                return signExtend ? AMD64Assembler.VexRMOp.VPMOVSXDQ : AMD64Assembler.VexRMOp.VPMOVZXDQ;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private static void loadAndExtendSSE(AMD64MacroAssembler asm, Register dst, AMD64Address src, AMD64Address.Scale ownScale, AMD64Address.Scale otherScale, boolean signExtend) {
        switch (ownScale) {
            case Times1: {
                switch (otherScale) {
                    case Times2: {
                        if (signExtend) {
                            asm.pmovsxbw(dst, src);
                        } else {
                            asm.pmovzxbw(dst, src);
                        }
                        return;
                    }
                    case Times4: {
                        if (signExtend) {
                            asm.pmovsxbd(dst, src);
                        } else {
                            asm.pmovzxbd(dst, src);
                        }
                        return;
                    }
                    case Times8: {
                        if (signExtend) {
                            asm.pmovsxbq(dst, src);
                        } else {
                            asm.pmovzxbq(dst, src);
                        }
                        return;
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            case Times2: {
                switch (otherScale) {
                    case Times4: {
                        if (signExtend) {
                            asm.pmovsxwd(dst, src);
                        } else {
                            asm.pmovzxwd(dst, src);
                        }
                        return;
                    }
                    case Times8: {
                        if (signExtend) {
                            asm.pmovsxwq(dst, src);
                        } else {
                            asm.pmovzxwq(dst, src);
                        }
                        return;
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            case Times4: {
                if (signExtend) {
                    asm.pmovsxdq(dst, src);
                } else {
                    asm.pmovzxdq(dst, src);
                }
                return;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private static void emitVectorCmp(AMD64MacroAssembler masm, Register vector1, Register vector2, AVXKind.AVXSize size) {
        AMD64ArrayEqualsOp.emitVectorXor(masm, vector1, vector2, size);
        AMD64ArrayEqualsOp.emitVectorTest(masm, vector1, size);
    }

    private static void emitVectorXor(AMD64MacroAssembler masm, Register vector1, Register vector2, AVXKind.AVXSize size) {
        if (size == AVXKind.AVXSize.YMM) {
            masm.vpxor(vector1, vector1, vector2);
        } else {
            masm.pxor(vector1, vector2);
        }
    }

    private static void emitVectorTest(AMD64MacroAssembler masm, Register vector1, AVXKind.AVXSize size) {
        if (size == AVXKind.AVXSize.YMM) {
            masm.vptest(vector1, vector1);
        } else {
            masm.ptest(vector1, vector1);
        }
    }

    private void emit8ByteCompare(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label trueLabel, Label falseLabel) {
        assert (this.kind1 == this.kind2);
        Label loop = new Label();
        Label compareTail = new Label();
        int elementsPerVector = 8 >> this.arrayIndexScale1.log2;
        boolean requiresNaNCheck = this.kind1.isNumericFloat();
        Label loopCheck = new Label();
        Label nanCheck = new Label();
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        masm.andl(result, elementsPerVector - 1);
        masm.andl(length, ~(elementsPerVector - 1));
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, compareTail);
        masm.leaq(array1, new AMD64Address(array1, length, this.arrayIndexScale1, 0));
        masm.leaq(array2, new AMD64Address(array2, length, this.arrayIndexScale2, 0));
        masm.negq(length);
        masm.align(crb.target.wordSize * 2);
        masm.bind(loop);
        masm.movq(temp, new AMD64Address(array1, length, this.arrayIndexScale1, 0));
        masm.cmpq(temp, new AMD64Address(array2, length, this.arrayIndexScale2, 0));
        masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, requiresNaNCheck ? nanCheck : falseLabel);
        masm.bind(loopCheck);
        masm.addq(length, elementsPerVector);
        masm.jccb(AMD64Assembler.ConditionFlag.NotZero, loop);
        masm.testl(result, result);
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, trueLabel);
        if (requiresNaNCheck) {
            Label unalignedCheck = new Label();
            masm.jmpb(unalignedCheck);
            masm.bind(nanCheck);
            for (int offset = 0; offset < 8; offset += this.kind1.getByteCount()) {
                this.emitFloatCompare(masm, array1, array2, length, offset, falseLabel, this.kind1.getByteCount() == 8);
            }
            masm.jmpb(loopCheck);
            masm.bind(unalignedCheck);
        }
        masm.movq(temp, new AMD64Address(array1, result, this.arrayIndexScale1, -8));
        masm.cmpq(temp, new AMD64Address(array2, result, this.arrayIndexScale2, -8));
        if (requiresNaNCheck) {
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, trueLabel);
            for (int offset = 0; offset < 8; offset += this.kind1.getByteCount()) {
                this.emitFloatCompare(masm, array1, array2, result, -8 + offset, falseLabel, this.kind1.getByteCount() == 8);
            }
        } else {
            masm.jccb(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
        }
        masm.jmpb(trueLabel);
        masm.bind(compareTail);
        masm.movl(length, result);
    }

    private void emitTailCompares(AMD64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label trueLabel, Label falseLabel) {
        assert (this.kind1 == this.kind2);
        Label compare2Bytes = new Label();
        Label compare1Byte = new Label();
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        if (this.kind1.getByteCount() <= 4) {
            masm.testl(result, this.arrayIndexScale1.log2 == 0 ? 4 : 4 >> this.arrayIndexScale1.log2);
            masm.jccb(AMD64Assembler.ConditionFlag.Zero, compare2Bytes);
            masm.movl(temp, new AMD64Address(array1, 0));
            masm.cmpl(temp, new AMD64Address(array2, 0));
            if (this.kind1 == JavaKind.Float) {
                masm.jccb(AMD64Assembler.ConditionFlag.Equal, trueLabel);
                this.emitFloatCompare(masm, array1, array2, Register.None, 0, falseLabel, true);
                masm.jmpb(trueLabel);
            } else {
                masm.jccb(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
            }
            if (this.kind1.getByteCount() <= 2) {
                masm.leaq(array1, new AMD64Address(array1, 4));
                masm.leaq(array2, new AMD64Address(array2, 4));
                masm.bind(compare2Bytes);
                masm.testl(result, this.arrayIndexScale1.log2 == 0 ? 2 : 2 >> this.arrayIndexScale1.log2);
                masm.jccb(AMD64Assembler.ConditionFlag.Zero, compare1Byte);
                masm.movzwl(temp, new AMD64Address(array1, 0));
                masm.movzwl(length, new AMD64Address(array2, 0));
                masm.cmpl(temp, length);
                masm.jccb(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
                if (this.kind1.getByteCount() <= 1) {
                    masm.leaq(array1, new AMD64Address(array1, 2));
                    masm.leaq(array2, new AMD64Address(array2, 2));
                    masm.bind(compare1Byte);
                    masm.testl(result, 1);
                    masm.jccb(AMD64Assembler.ConditionFlag.Zero, trueLabel);
                    masm.movzbl(temp, new AMD64Address(array1, 0));
                    masm.movzbl(length, new AMD64Address(array2, 0));
                    masm.cmpl(temp, length);
                    masm.jccb(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
                } else {
                    masm.bind(compare1Byte);
                }
            } else {
                masm.bind(compare2Bytes);
            }
        }
    }

    private void emitDifferentKindsElementWiseCompare(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label trueLabel, Label falseLabel) {
        int i;
        assert (this.kind1 != this.kind2);
        assert (this.kind1.isNumericInteger() && this.kind2.isNumericInteger());
        Label loop = new Label();
        Label compareTail = new Label();
        int elementsPerLoopIteration = 4;
        Register tmp1 = ValueUtil.asRegister((Value)this.temp4);
        Register tmp2 = ValueUtil.asRegister((Value)this.temp5);
        masm.andl(result, elementsPerLoopIteration - 1);
        masm.andl(length, ~(elementsPerLoopIteration - 1));
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, compareTail);
        masm.leaq(array1, new AMD64Address(array1, length, this.arrayIndexScale1, 0));
        masm.leaq(array2, new AMD64Address(array2, length, this.arrayIndexScale2, 0));
        masm.negq(length);
        masm.xorq(tmp1, tmp1);
        masm.xorq(tmp2, tmp2);
        masm.align(crb.target.wordSize * 2);
        masm.bind(loop);
        for (i = 0; i < elementsPerLoopIteration; ++i) {
            this.emitMovBytes(masm, tmp1, new AMD64Address(array1, length, this.arrayIndexScale1, i << this.arrayIndexScale1.log2), this.kind1.getByteCount());
            this.emitMovBytes(masm, tmp2, new AMD64Address(array2, length, this.arrayIndexScale2, i << this.arrayIndexScale2.log2), this.kind2.getByteCount());
            masm.cmpq(tmp1, tmp2);
            masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
        }
        masm.addq(length, elementsPerLoopIteration);
        masm.jccb(AMD64Assembler.ConditionFlag.NotZero, loop);
        masm.bind(compareTail);
        masm.testl(result, result);
        masm.jcc(AMD64Assembler.ConditionFlag.Zero, trueLabel);
        for (i = 0; i < elementsPerLoopIteration - 1; ++i) {
            this.emitMovBytes(masm, tmp1, new AMD64Address(array1, length, this.arrayIndexScale1, 0), this.kind1.getByteCount());
            this.emitMovBytes(masm, tmp2, new AMD64Address(array2, length, this.arrayIndexScale2, 0), this.kind2.getByteCount());
            masm.cmpq(tmp1, tmp2);
            masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, falseLabel);
            if (i < elementsPerLoopIteration - 2) {
                masm.incrementq(length, 1);
                masm.decrementq(result, 1);
                masm.jcc(AMD64Assembler.ConditionFlag.Zero, trueLabel);
                continue;
            }
            masm.jmpb(trueLabel);
        }
    }

    private void emitNaNCheck(AMD64MacroAssembler masm, AMD64Address src, Label branchIfNonNaN) {
        assert (this.kind1.isNumericFloat());
        Register tempXMMReg = ValueUtil.asRegister((Value)this.tempXMM);
        if (this.kind1 == JavaKind.Float) {
            masm.movflt(tempXMMReg, src);
        } else {
            masm.movdbl(tempXMMReg, src);
        }
        AMD64Assembler.SSEOp.UCOMIS.emit((AMD64Assembler)masm, this.kind1 == JavaKind.Float ? AMD64BaseAssembler.OperandSize.PS : AMD64BaseAssembler.OperandSize.PD, tempXMMReg, tempXMMReg);
        masm.jcc(AMD64Assembler.ConditionFlag.NoParity, branchIfNonNaN);
    }

    private void emitFloatCompare(AMD64MacroAssembler masm, Register base1, Register base2, Register index, int offset, Label falseLabel, boolean skipBitwiseCompare) {
        AMD64Address address1 = new AMD64Address(base1, index, this.arrayIndexScale1, offset);
        AMD64Address address2 = new AMD64Address(base2, index, this.arrayIndexScale2, offset);
        Label bitwiseEqual = new Label();
        if (!skipBitwiseCompare) {
            Register temp = ValueUtil.asRegister((Value)this.temp4);
            if (this.kind1 == JavaKind.Float) {
                masm.movl(temp, address1);
                masm.cmpl(temp, address2);
            } else {
                masm.movq(temp, address1);
                masm.cmpq(temp, address2);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.Equal, bitwiseEqual);
        }
        this.emitNaNCheck(masm, address1, falseLabel);
        this.emitNaNCheck(masm, address2, falseLabel);
        masm.bind(bitwiseEqual);
    }

    private void emitFloatCompareWithinRange(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register base1, Register base2, Register index, int offset, Label falseLabel, int range) {
        assert (this.kind1.isNumericFloat());
        Label loop = new Label();
        Register i = ValueUtil.asRegister((Value)this.temp5);
        masm.movq(i, range);
        masm.negq(i);
        masm.align(crb.target.wordSize * 2);
        masm.bind(loop);
        this.emitFloatCompare(masm, base1, base2, index, offset, falseLabel, range == 1);
        masm.incrementq(index, 1);
        masm.incrementq(i, 1);
        masm.jccb(AMD64Assembler.ConditionFlag.NotZero, loop);
        masm.subq(index, range);
    }

    private boolean constantLengthCompareNeedsTmpArrayPointers() {
        int vectorCount;
        AVXKind.AVXSize vSize = this.vectorSize;
        if (this.constantLength() < this.getElementsPerVector(this.vectorSize)) {
            vSize = AVXKind.AVXSize.XMM;
        }
        return (vectorCount = this.constantLength() & ~(2 * this.getElementsPerVector(vSize) - 1)) > 0;
    }

    private void emitConstantLengthArrayCompareBytes(CompilationResultBuilder crb, AMD64MacroAssembler asm, Register[] tmpVectors, Label noMatch) {
        int elementsPerVector;
        if (this.constantLength() == 0) {
            return;
        }
        Register arrayPtr1 = ValueUtil.asRegister((Value)this.array1Value);
        Register arrayPtr2 = ValueUtil.asRegister((Value)this.array2Value);
        Register tmp = ValueUtil.asRegister((Value)this.temp3);
        AVXKind.AVXSize vSize = this.vectorSize;
        if (this.constantLength() < this.getElementsPerVector(this.vectorSize)) {
            vSize = AVXKind.AVXSize.XMM;
        }
        if ((elementsPerVector = this.getElementsPerVector(vSize)) > this.constantLength()) {
            assert (this.kind1 == this.kind2);
            int byteLength = this.constantLength() << this.arrayIndexScale1.log2;
            int movSize = byteLength < 2 ? 1 : (byteLength < 4 ? 2 : (byteLength < 8 ? 4 : 8));
            this.emitMovBytes(asm, tmp, new AMD64Address(arrayPtr1, this.arrayBaseOffset1), movSize);
            AMD64ArrayEqualsOp.emitXorBytes(asm, tmp, new AMD64Address(arrayPtr2, this.arrayBaseOffset2), movSize);
            asm.jccb(AMD64Assembler.ConditionFlag.NotZero, noMatch);
            if (byteLength > movSize) {
                this.emitMovBytes(asm, tmp, new AMD64Address(arrayPtr1, this.arrayBaseOffset1 + byteLength - movSize), movSize);
                AMD64ArrayEqualsOp.emitXorBytes(asm, tmp, new AMD64Address(arrayPtr2, this.arrayBaseOffset2 + byteLength - movSize), movSize);
                asm.jccb(AMD64Assembler.ConditionFlag.NotZero, noMatch);
            }
        } else {
            int elementsPerVectorLoop = 2 * elementsPerVector;
            int tailCount = this.constantLength() & elementsPerVectorLoop - 1;
            int vectorCount = this.constantLength() & ~(elementsPerVectorLoop - 1);
            int bytesPerVector = vSize.getBytes();
            if (vectorCount > 0) {
                Label loopBegin = new Label();
                Register tmpArrayPtr1 = ValueUtil.asRegister((Value)this.temp1);
                Register tmpArrayPtr2 = ValueUtil.asRegister((Value)this.temp2);
                asm.leaq(tmpArrayPtr1, new AMD64Address(arrayPtr1, vectorCount << this.arrayIndexScale1.log2));
                asm.leaq(tmpArrayPtr2, new AMD64Address(arrayPtr2, vectorCount << this.arrayIndexScale2.log2));
                arrayPtr1 = tmpArrayPtr1;
                arrayPtr2 = tmpArrayPtr2;
                asm.movq(tmp, -vectorCount);
                asm.align(crb.target.wordSize * 2);
                asm.bind(loopBegin);
                this.emitVectorLoad1(asm, tmpVectors[0], arrayPtr1, tmp, this.arrayBaseOffset1, vSize);
                this.emitVectorLoad2(asm, tmpVectors[1], arrayPtr2, tmp, this.arrayBaseOffset2, vSize);
                this.emitVectorLoad1(asm, tmpVectors[2], arrayPtr1, tmp, this.arrayBaseOffset1 + this.scaleDisplacement1(bytesPerVector), vSize);
                this.emitVectorLoad2(asm, tmpVectors[3], arrayPtr2, tmp, this.arrayBaseOffset2 + this.scaleDisplacement2(bytesPerVector), vSize);
                AMD64ArrayEqualsOp.emitVectorXor(asm, tmpVectors[0], tmpVectors[1], vSize);
                AMD64ArrayEqualsOp.emitVectorXor(asm, tmpVectors[2], tmpVectors[3], vSize);
                AMD64ArrayEqualsOp.emitVectorTest(asm, tmpVectors[0], vSize);
                asm.jccb(AMD64Assembler.ConditionFlag.NotZero, noMatch);
                AMD64ArrayEqualsOp.emitVectorTest(asm, tmpVectors[2], vSize);
                asm.jccb(AMD64Assembler.ConditionFlag.NotZero, noMatch);
                asm.addq(tmp, elementsPerVectorLoop);
                asm.jccb(AMD64Assembler.ConditionFlag.NotZero, loopBegin);
            }
            if (tailCount > 0) {
                this.emitVectorLoad1(asm, tmpVectors[0], arrayPtr1, this.arrayBaseOffset1 + (tailCount << this.arrayIndexScale1.log2) - this.scaleDisplacement1(bytesPerVector), vSize);
                this.emitVectorLoad2(asm, tmpVectors[1], arrayPtr2, this.arrayBaseOffset2 + (tailCount << this.arrayIndexScale2.log2) - this.scaleDisplacement2(bytesPerVector), vSize);
                AMD64ArrayEqualsOp.emitVectorXor(asm, tmpVectors[0], tmpVectors[1], vSize);
                if (tailCount > elementsPerVector) {
                    this.emitVectorLoad1(asm, tmpVectors[2], arrayPtr1, this.arrayBaseOffset1, vSize);
                    this.emitVectorLoad2(asm, tmpVectors[3], arrayPtr2, this.arrayBaseOffset2, vSize);
                    AMD64ArrayEqualsOp.emitVectorXor(asm, tmpVectors[2], tmpVectors[3], vSize);
                    AMD64ArrayEqualsOp.emitVectorTest(asm, tmpVectors[2], vSize);
                    asm.jccb(AMD64Assembler.ConditionFlag.NotZero, noMatch);
                }
                AMD64ArrayEqualsOp.emitVectorTest(asm, tmpVectors[0], vSize);
                asm.jccb(AMD64Assembler.ConditionFlag.NotZero, noMatch);
            }
        }
    }

    private void emitMovBytes(AMD64MacroAssembler asm, Register dst, AMD64Address src, int size) {
        switch (size) {
            case 1: {
                if (this.signExtend) {
                    asm.movsbq(dst, src);
                    break;
                }
                asm.movzbq(dst, src);
                break;
            }
            case 2: {
                if (this.signExtend) {
                    asm.movswq(dst, src);
                    break;
                }
                asm.movzwq(dst, src);
                break;
            }
            case 4: {
                if (this.signExtend) {
                    asm.movslq(dst, src);
                    break;
                }
                asm.movl(dst, src);
                break;
            }
            case 8: {
                asm.movq(dst, src);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void emitXorBytes(AMD64MacroAssembler asm, Register dst, AMD64Address src, int size) {
        AMD64BaseAssembler.OperandSize opSize = AMD64ArrayEqualsOp.getOperandSize(size);
        AMD64Assembler.AMD64BinaryArithmetic.XOR.getRMOpcode(opSize).emit((AMD64Assembler)asm, opSize, dst, src);
    }

    private static AMD64BaseAssembler.OperandSize getOperandSize(int size) {
        switch (size) {
            case 1: {
                return AMD64BaseAssembler.OperandSize.BYTE;
            }
            case 2: {
                return AMD64BaseAssembler.OperandSize.WORD;
            }
            case 4: {
                return AMD64BaseAssembler.OperandSize.DWORD;
            }
            case 8: {
                return AMD64BaseAssembler.OperandSize.QWORD;
            }
        }
        throw new IllegalStateException();
    }
}

