/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;

public class AMD64Call {
    public static int directCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, InvokeTarget callTarget, Register scratch, boolean align, LIRFrameState info) {
        int callPCOffset;
        if (align) {
            AMD64Call.emitAlignmentForDirectCall(crb, masm);
        }
        int before = masm.position();
        if (scratch != null && !GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
            masm.movq(scratch, 0L);
            callPCOffset = masm.position();
            masm.call(scratch);
        } else {
            callPCOffset = masm.position();
            masm.call();
        }
        int after = masm.position();
        crb.recordDirectCall(before, after, callTarget, info);
        crb.recordExceptionHandlers(after, info);
        masm.ensureUniquePC();
        return callPCOffset;
    }

    protected static void emitAlignmentForDirectCall(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int modulus;
        int offset = masm.position();
        if ((offset += crb.target.arch.getMachineCodeCallDisplacementOffset()) % (modulus = crb.target.wordSize) != 0) {
            masm.nop(modulus - offset % modulus);
        }
    }

    public static int directJmp(CompilationResultBuilder crb, AMD64MacroAssembler masm, InvokeTarget target) {
        return AMD64Call.directJmp(crb, masm, target, null);
    }

    public static int directJmp(CompilationResultBuilder crb, AMD64MacroAssembler masm, InvokeTarget target, Register scratch) {
        int callPCOffset;
        int before = masm.position();
        if (scratch != null && !GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
            masm.movq(scratch, 0L);
            callPCOffset = masm.position();
            masm.jmp(scratch);
        } else {
            callPCOffset = masm.position();
            masm.jmp(0, true);
        }
        int after = masm.position();
        crb.recordDirectCall(before, after, target, null);
        masm.ensureUniquePC();
        return callPCOffset;
    }

    public static void directConditionalJmp(CompilationResultBuilder crb, AMD64MacroAssembler masm, InvokeTarget target, AMD64Assembler.ConditionFlag cond) {
        int before = masm.position();
        masm.jcc(cond, 0, true);
        int after = masm.position();
        crb.recordDirectCall(before, after, target, null);
        masm.ensureUniquePC();
    }

    public static int indirectCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info) {
        int before = masm.position();
        masm.call(dst);
        int after = masm.position();
        crb.recordIndirectCall(before, after, callTarget, info);
        crb.recordExceptionHandlers(after, info);
        masm.ensureUniquePC();
        return before;
    }

    @Opcode(value="FAR_FOREIGN_CALL")
    public static final class DirectFarForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectFarForeignCallOp> TYPE = LIRInstructionClass.create(DirectFarForeignCallOp.class);
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue callTemp = AMD64.rax.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));

        public DirectFarForeignCallOp(ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, callTarget, result, parameters, temps, state);
            assert (LIRValueUtil.differentRegisters(parameters, this.callTemp));
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.directCall(crb, masm, this.callTarget, ((RegisterValue)this.callTemp).getRegister(), false, this.state);
        }
    }

    @Opcode(value="NEAR_FOREIGN_CALL")
    public static final class DirectNearForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectNearForeignCallOp> TYPE = LIRInstructionClass.create(DirectNearForeignCallOp.class);

        public DirectNearForeignCallOp(ForeignCallLinkage linkage, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, linkage, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.directCall(crb, masm, this.callTarget, null, false, this.state);
        }
    }

    public static abstract class ForeignCallOp
    extends CallOp
    implements DiagnosticLIRGeneratorTool.ZapRegistersAfterInstruction {
        public static final LIRInstructionClass<ForeignCallOp> TYPE = LIRInstructionClass.create(ForeignCallOp.class);
        protected final ForeignCallLinkage callTarget;

        public ForeignCallOp(LIRInstructionClass<? extends ForeignCallOp> c, ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, result, parameters, temps, state);
            this.callTarget = callTarget;
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return this.callTarget.destroysRegisters();
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class IndirectCallOp
    extends MethodCallOp {
        public static final LIRInstructionClass<IndirectCallOp> TYPE = LIRInstructionClass.create(IndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected Value targetAddress;

        public IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            this(TYPE, callTarget, result, parameters, temps, targetAddress, state);
        }

        protected IndirectCallOp(LIRInstructionClass<? extends IndirectCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            super(c, callTarget, result, parameters, temps, state);
            this.targetAddress = targetAddress;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.indirectCall(crb, masm, ValueUtil.asRegister((Value)this.targetAddress), (InvokeTarget)this.callTarget, this.state);
        }

        @Override
        public void verify() {
            super.verify();
            assert (ValueUtil.isRegister((Value)this.targetAddress)) : "The current register allocator cannot handle variables to be used at call sites, it must be in a fixed register for now";
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class DirectCallOp
    extends MethodCallOp {
        public static final LIRInstructionClass<DirectCallOp> TYPE = LIRInstructionClass.create(DirectCallOp.class);

        public DirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            this((LIRInstructionClass<? extends DirectCallOp>)TYPE, callTarget, result, parameters, temps, state);
        }

        protected DirectCallOp(LIRInstructionClass<? extends DirectCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, callTarget, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.directCall(crb, masm, (InvokeTarget)this.callTarget, null, true, this.state);
        }

        public int emitCall(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            return AMD64Call.directCall(crb, masm, (InvokeTarget)this.callTarget, null, true, this.state);
        }
    }

    public static abstract class MethodCallOp
    extends CallOp {
        public static final LIRInstructionClass<MethodCallOp> TYPE = LIRInstructionClass.create(MethodCallOp.class);
        protected final ResolvedJavaMethod callTarget;

        protected MethodCallOp(LIRInstructionClass<? extends MethodCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, result, parameters, temps, state);
            this.callTarget = callTarget;
        }
    }

    public static abstract class CallOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CallOp> TYPE = LIRInstructionClass.create(CallOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] parameters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] temps;
        @LIRInstruction.State
        protected LIRFrameState state;

        protected CallOp(LIRInstructionClass<? extends CallOp> c, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.result = result;
            this.parameters = parameters;
            this.state = state;
            this.temps = CallOp.addStackSlotsToTemporaries(parameters, temps);
            assert (temps != null);
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return true;
        }
    }
}

