/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64MathIntrinsicUnaryOp;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AMD64MathExpOp
extends AMD64MathIntrinsicUnaryOp {
    public static final LIRInstructionClass<AMD64MathExpOp> TYPE = LIRInstructionClass.create(AMD64MathExpOp.class);
    private ArrayDataPointerConstant cv = AMD64HotSpotHelper.pointerConstant(16, new int[]{1697350398, 1079448903, 1697350398, 1079448903});
    private ArrayDataPointerConstant cv16 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-17170432, 1065758274, -17170432, 1065758274});
    private ArrayDataPointerConstant cv32 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1130480838, 1025308570, -1130480838, 1025308570});
    private ArrayDataPointerConstant cv48 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-2, 0x3FDFFFFF, -2, 0x3FDFFFFF});
    private ArrayDataPointerConstant cv64 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-483878816, 1062650204, 1432067621, 1067799893});
    private ArrayDataPointerConstant cv80 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1064251633, 1065423125, 1431604129, 1069897045});
    private ArrayDataPointerConstant shifter = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 1127743488, 0, 1127743488});
    private ArrayDataPointerConstant mmask = AMD64HotSpotHelper.pointerConstant(16, new int[]{-64, 0, -64, 0});
    private ArrayDataPointerConstant bias = AMD64HotSpotHelper.pointerConstant(16, new int[]{65472, 0, 65472, 0});
    private ArrayDataPointerConstant tblAddr = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0, 0, 0, 235107661, 1018002367, 1048019040, 11418, 896005651, 1015861842, -753564300, 22960, 1642514529, 1012987726, 410360776, 34629, 1568897900, 1016568486, 1828292879, 46424, 1882168529, 1010744893, 852742562, 58348, 509852888, 1017336174, -804103344, 70401, 653277307, 1017431380, -1364644385, 82586, 1649557430, 1017729363, 1014845818, 94904, 1058231231, 1015777676, -344994955, 107355, 1044000607, 1016786167, 828946858, 119943, 1151779725, 1015705409, -2006807338, 132667, -475486060, 1016499965, 1853186616, 145530, -1742739470, 1015039787, 1709341917, 158533, 1829350193, 1015216097, -182460703, 171677, 1913391795, 1015756674, -1495006453, 184965, 1303423926, 1015238005, 171030293, 198398, 1574172746, 1016061241, -1302063361, 211976, -870810327, 1017196428, 926591434, 225703, 1938513547, 1017631273, 887463926, 239579, -1490400147, 1015390024, 1276261410, 253606, 631083525, 1017690182, 569847337, 267786, 1623370770, 1011049453, 1617004845, 282120, -626982023, 1013894369, -1245627184, 296610, -1149587536, 1014403278, -717870553, 311258, -1691866615, 1017152460, 1990012070, 326066, -1045764345, 1017448880, 1453150081, 341035, 419288974, 1016280325, 917841882, 356167, -501459959, 1016095713, -582462423, 371463, 728023093, 1016345318, 363667784, 386927, -1712288758, 1017123460, -1338354300, 402558, 7592966, 1016721543, -2108349916, 418360, 228611441, 1016696141, 1719614412, 434334, -2033301626, 1017457593, 1013258798, 450482, 544148907, 1017323666, -387162253, 466805, -1911052378, 1017143586, 1447192520, 483307, 1176412038, 1017267372, 1944781190, 499988, -1412010923, 1013312481, 919555682, 516851, -1140889648, 1016528543, -1723019758, 533897, 348651999, 1016405780, -1690004756, 551129, -1041175884, 1015920431, 1110089947, 568549, 1509121860, 1014756995, -1726646474, 586158, -1677318084, 1017340090, -1328691740, 603959, 553214634, 1016457425, -1612820913, 621954, 730975783, 1014083580, -2103185264, 640145, 1486499517, 1016818996, 2069751140, 658534, -1699178368, 1016407932, -1304550052, 677123, 1853053619, 1015310724, 1434058175, 695915, -1832176761, 1015814775, -1722100819, 714911, -601023082, 1017259110, -1202776582, 734114, -1315633746, 1017188654, -218407354, 753526, 174054861, 1014300631, -1874083374, 773150, 816778419, 1014197934, -578465124, 792987, -787916372, 1015341199, 777507147, 813041, 1821514088, 1013410604, -588279703, 833312, 920623539, 1016295433, 1242007931, 853805, -1505949785, 1014276997, -587488121, 874520, -708734292, 1015962192, 64696965, 895462, 474650514, 1016642419, 863738718, 916631, 1614448851, 1014281732, -410304522, 938030, -1844885210, 1016164135, -1566273319, 959663, 1101668360, 1015989180, -295609817, 981531, 835814894, 1015702697, 1533953344, 1003638, 1301400989, 1014466875, -2120314664, 1025985});
    private ArrayDataPointerConstant allones = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1, -1, -1, -1});
    private ArrayDataPointerConstant ebias = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0x3FF00000, 0, 0x3FF00000});
    private ArrayDataPointerConstant xmax = AMD64HotSpotHelper.pointerConstant(4, new int[]{-1, 0x7FEFFFFF});
    private ArrayDataPointerConstant xmin = AMD64HotSpotHelper.pointerConstant(4, new int[]{0, 0x100000});
    private ArrayDataPointerConstant inf = AMD64HotSpotHelper.pointerConstant(4, new int[]{0, 0x7FF00000});
    private ArrayDataPointerConstant zero = AMD64HotSpotHelper.pointerConstant(4, new int[]{0, 0});
    private ArrayDataPointerConstant oneVal = AMD64HotSpotHelper.pointerConstant(4, new int[]{0, 0x3FF00000});

    public AMD64MathExpOp() {
        super(TYPE, AMD64.rax, AMD64.rcx, AMD64.rdx, AMD64.r11, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label block0 = new Label();
        Label block1 = new Label();
        Label block2 = new Label();
        Label block3 = new Label();
        Label block4 = new Label();
        Label block5 = new Label();
        Label block6 = new Label();
        Label block7 = new Label();
        Label block8 = new Label();
        Label block9 = new Label();
        Label block10 = new Label();
        Label block11 = new Label();
        Label block12 = new Label();
        Label block13 = new Label();
        masm.subq(AMD64.rsp, 24);
        masm.movsd(new AMD64Address(AMD64.rsp, 8), AMD64.xmm0);
        masm.unpcklpd(AMD64.xmm0, AMD64.xmm0);
        masm.movdqu(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.cv));
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.shifter));
        masm.movdqu(AMD64.xmm2, AMD64HotSpotHelper.recordExternalAddress(crb, this.cv16));
        masm.movdqu(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, this.cv32));
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.andl(AMD64.rax, Short.MAX_VALUE);
        masm.movl(AMD64.rdx, 16527);
        masm.subl(AMD64.rdx, AMD64.rax);
        masm.subl(AMD64.rax, 15504);
        masm.orl(AMD64.rdx, AMD64.rax);
        masm.cmpl(AMD64.rdx, Integer.MIN_VALUE);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, block0);
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.addpd(AMD64.xmm1, AMD64.xmm6);
        masm.movapd(AMD64.xmm7, AMD64.xmm1);
        masm.subpd(AMD64.xmm1, AMD64.xmm6);
        masm.mulpd(AMD64.xmm2, AMD64.xmm1);
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, this.cv64));
        masm.mulpd(AMD64.xmm3, AMD64.xmm1);
        masm.movdqu(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.cv80));
        masm.subpd(AMD64.xmm0, AMD64.xmm2);
        masm.movdl(AMD64.rax, AMD64.xmm7);
        masm.movl(AMD64.rcx, AMD64.rax);
        masm.andl(AMD64.rcx, 63);
        masm.shll(AMD64.rcx, 4);
        masm.sarl(AMD64.rax, 6);
        masm.movl(AMD64.rdx, AMD64.rax);
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.mmask));
        masm.pand(AMD64.xmm7, AMD64.xmm6);
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.bias));
        masm.paddq(AMD64.xmm7, AMD64.xmm6);
        masm.psllq(AMD64.xmm7, 46);
        masm.subpd(AMD64.xmm0, AMD64.xmm3);
        masm.leaq(AMD64.r11, AMD64HotSpotHelper.recordExternalAddress(crb, this.tblAddr));
        masm.movdqu(AMD64.xmm2, new AMD64Address(AMD64.rcx, AMD64.r11, AMD64Address.Scale.Times1));
        masm.mulpd(AMD64.xmm4, AMD64.xmm0);
        masm.movapd(AMD64.xmm6, AMD64.xmm0);
        masm.movapd(AMD64.xmm1, AMD64.xmm0);
        masm.mulpd(AMD64.xmm6, AMD64.xmm6);
        masm.mulpd(AMD64.xmm0, AMD64.xmm6);
        masm.addpd(AMD64.xmm5, AMD64.xmm4);
        masm.mulsd(AMD64.xmm0, AMD64.xmm6);
        masm.mulpd(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.cv48));
        masm.addsd(AMD64.xmm1, AMD64.xmm2);
        masm.unpckhpd(AMD64.xmm2, AMD64.xmm2);
        masm.mulpd(AMD64.xmm0, AMD64.xmm5);
        masm.addsd(AMD64.xmm1, AMD64.xmm0);
        masm.por(AMD64.xmm2, AMD64.xmm7);
        masm.unpckhpd(AMD64.xmm0, AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.addsd(AMD64.xmm0, AMD64.xmm6);
        masm.addl(AMD64.rdx, 894);
        masm.cmpl(AMD64.rdx, 1916);
        masm.jcc(AMD64Assembler.ConditionFlag.Above, block1);
        masm.mulsd(AMD64.xmm0, AMD64.xmm2);
        masm.addsd(AMD64.xmm0, AMD64.xmm2);
        masm.jmp(block13);
        masm.bind(block1);
        masm.xorpd(AMD64.xmm3, AMD64.xmm3);
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, this.allones));
        masm.movl(AMD64.rdx, -1022);
        masm.subl(AMD64.rdx, AMD64.rax);
        masm.movdl(AMD64.xmm5, AMD64.rdx);
        masm.psllq(AMD64.xmm4, AMD64.xmm5);
        masm.movl(AMD64.rcx, AMD64.rax);
        masm.sarl(AMD64.rax, 1);
        masm.pinsrw(AMD64.xmm3, AMD64.rax, 3);
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.ebias));
        masm.psllq(AMD64.xmm3, 4);
        masm.psubd(AMD64.xmm2, AMD64.xmm3);
        masm.mulsd(AMD64.xmm0, AMD64.xmm2);
        masm.cmpl(AMD64.rdx, 52);
        masm.jcc(AMD64Assembler.ConditionFlag.Greater, block2);
        masm.pand(AMD64.xmm4, AMD64.xmm2);
        masm.paddd(AMD64.xmm3, AMD64.xmm6);
        masm.subsd(AMD64.xmm2, AMD64.xmm4);
        masm.addsd(AMD64.xmm0, AMD64.xmm2);
        masm.cmpl(AMD64.rcx, 1023);
        masm.jcc(AMD64Assembler.ConditionFlag.GreaterEqual, block3);
        masm.pextrw(AMD64.rcx, AMD64.xmm0, 3);
        masm.andl(AMD64.rcx, 32768);
        masm.orl(AMD64.rdx, AMD64.rcx);
        masm.cmpl(AMD64.rdx, 0);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, block4);
        masm.movapd(AMD64.xmm6, AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64.xmm4);
        masm.mulsd(AMD64.xmm0, AMD64.xmm3);
        masm.pextrw(AMD64.rcx, AMD64.xmm0, 3);
        masm.andl(AMD64.rcx, 32752);
        masm.cmpl(AMD64.rcx, 0);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, block5);
        masm.jmp(block13);
        masm.bind(block5);
        masm.mulsd(AMD64.xmm6, AMD64.xmm3);
        masm.mulsd(AMD64.xmm4, AMD64.xmm3);
        masm.movdqu(AMD64.xmm0, AMD64.xmm6);
        masm.pxor(AMD64.xmm6, AMD64.xmm4);
        masm.psrad(AMD64.xmm6, 31);
        masm.pshufd(AMD64.xmm6, AMD64.xmm6, 85);
        masm.psllq(AMD64.xmm0, 1);
        masm.psrlq(AMD64.xmm0, 1);
        masm.pxor(AMD64.xmm0, AMD64.xmm6);
        masm.psrlq(AMD64.xmm6, 63);
        masm.paddq(AMD64.xmm0, AMD64.xmm6);
        masm.paddq(AMD64.xmm0, AMD64.xmm4);
        masm.movl(new AMD64Address(AMD64.rsp, 0), 15);
        masm.jmp(block6);
        masm.bind(block4);
        masm.addsd(AMD64.xmm0, AMD64.xmm4);
        masm.mulsd(AMD64.xmm0, AMD64.xmm3);
        masm.jmp(block13);
        masm.bind(block3);
        masm.addsd(AMD64.xmm0, AMD64.xmm4);
        masm.mulsd(AMD64.xmm0, AMD64.xmm3);
        masm.pextrw(AMD64.rcx, AMD64.xmm0, 3);
        masm.andl(AMD64.rcx, 32752);
        masm.cmpl(AMD64.rcx, 32752);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, block7);
        masm.jmp(block13);
        masm.bind(block2);
        masm.paddd(AMD64.xmm3, AMD64.xmm6);
        masm.addpd(AMD64.xmm0, AMD64.xmm2);
        masm.mulsd(AMD64.xmm0, AMD64.xmm3);
        masm.movl(new AMD64Address(AMD64.rsp, 0), 15);
        masm.jmp(block6);
        masm.bind(block8);
        masm.cmpl(AMD64.rax, 0x7FF00000);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, block9);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rsp, 12));
        masm.cmpl(AMD64.rax, Integer.MIN_VALUE);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, block10);
        masm.movsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.xmax));
        masm.mulsd(AMD64.xmm0, AMD64.xmm0);
        masm.bind(block7);
        masm.movl(new AMD64Address(AMD64.rsp, 0), 14);
        masm.jmp(block6);
        masm.bind(block10);
        masm.movsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.xmin));
        masm.mulsd(AMD64.xmm0, AMD64.xmm0);
        masm.movl(new AMD64Address(AMD64.rsp, 0), 15);
        masm.jmp(block6);
        masm.bind(block9);
        masm.movl(AMD64.rdx, new AMD64Address(AMD64.rsp, 8));
        masm.cmpl(AMD64.rax, 0x7FF00000);
        masm.jcc(AMD64Assembler.ConditionFlag.Above, block11);
        masm.cmpl(AMD64.rdx, 0);
        masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, block11);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rsp, 12));
        masm.cmpl(AMD64.rax, 0x7FF00000);
        masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, block12);
        masm.movsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.inf));
        masm.jmp(block13);
        masm.bind(block12);
        masm.movsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.zero));
        masm.jmp(block13);
        masm.bind(block11);
        masm.movsd(AMD64.xmm0, new AMD64Address(AMD64.rsp, 8));
        masm.addsd(AMD64.xmm0, AMD64.xmm0);
        masm.jmp(block13);
        masm.bind(block0);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rsp, 12));
        masm.andl(AMD64.rax, Integer.MAX_VALUE);
        masm.cmpl(AMD64.rax, 0x40900000);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, block8);
        masm.movsd(new AMD64Address(AMD64.rsp, 8), AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.oneVal));
        masm.jmp(block13);
        masm.bind(block6);
        masm.movq(new AMD64Address(AMD64.rsp, 16), AMD64.xmm0);
        masm.movq(AMD64.xmm0, new AMD64Address(AMD64.rsp, 16));
        masm.bind(block13);
        masm.addq(AMD64.rsp, 24);
    }
}

