/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AMD64_STRING_INFLATE")
public final class AMD64StringLatin1InflateOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64StringLatin1InflateOp> TYPE = LIRInstructionClass.create(AMD64StringLatin1InflateOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value rsrc;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value rdst;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value rlen;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value rsrcTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value rdstTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value rlenTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vtmp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value rtmp2;

    public AMD64StringLatin1InflateOp(LIRGeneratorTool tool, Value src, Value dst, Value len) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        assert (ValueUtil.asRegister((Value)src).equals((Object)AMD64.rsi));
        assert (ValueUtil.asRegister((Value)dst).equals((Object)AMD64.rdi));
        assert (ValueUtil.asRegister((Value)len).equals((Object)AMD64.rdx));
        this.rsrcTemp = this.rsrc = src;
        this.rdstTemp = this.rdst = dst;
        this.rlenTemp = this.rlen = len;
        this.vtmp1 = AMD64StringLatin1InflateOp.useAVX512ForStringInflateCompress(tool.target()) ? tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.V512_BYTE)) : tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.V128_BYTE));
        this.rtmp2 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register src = ValueUtil.asRegister((Value)this.rsrc);
        Register dst = ValueUtil.asRegister((Value)this.rdst);
        Register len = ValueUtil.asRegister((Value)this.rlen);
        Register tmp1 = ValueUtil.asRegister((Value)this.vtmp1);
        Register tmp2 = ValueUtil.asRegister((Value)this.rtmp2);
        AMD64StringLatin1InflateOp.byteArrayInflate(masm, src, dst, len, tmp1, tmp2);
    }

    public static boolean useAVX512ForStringInflateCompress(TargetDescription target) {
        EnumSet features = ((AMD64)target.arch).getFeatures();
        return features.contains(AMD64.CPUFeature.AVX512BW) && features.contains(AMD64.CPUFeature.AVX512VL) && features.contains(AMD64.CPUFeature.BMI2);
    }

    private static void byteArrayInflate(AMD64MacroAssembler masm, Register src, Register dst, Register len, Register vtmp, Register tmp) {
        assert (vtmp.getRegisterCategory().equals((Object)AMD64.XMM));
        Label labelDone = new Label();
        Label labelBelowThreshold = new Label();
        assert (src.number != dst.number && src.number != len.number && src.number != tmp.number);
        assert (dst.number != len.number && dst.number != tmp.number);
        assert (len.number != tmp.number);
        if (AMD64StringLatin1InflateOp.useAVX512ForStringInflateCompress(masm.target)) {
            masm.testl(len, -16);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, labelBelowThreshold);
            Label labelAvx512Tail = new Label();
            masm.movl(tmp, len);
            masm.andl(tmp, -32);
            masm.jccb(AMD64Assembler.ConditionFlag.Zero, labelAvx512Tail);
            masm.andl(len, 31);
            masm.leaq(src, new AMD64Address(src, tmp, AMD64Address.Scale.Times1));
            masm.leaq(dst, new AMD64Address(dst, tmp, AMD64Address.Scale.Times2));
            masm.negq(tmp);
            Label labelAvx512Loop = new Label();
            masm.bind(labelAvx512Loop);
            masm.evpmovzxbw(vtmp, new AMD64Address(src, tmp, AMD64Address.Scale.Times1));
            masm.evmovdqu16(new AMD64Address(dst, tmp, AMD64Address.Scale.Times2), vtmp);
            masm.addq(tmp, 32);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelAvx512Loop);
            masm.bind(labelAvx512Tail);
            masm.testl(len, len);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, labelDone);
            masm.kmovq(AMD64.k2, AMD64.k1);
            masm.movl(tmp, -1);
            masm.shlxl(tmp, tmp, len);
            masm.notl(tmp);
            masm.kmovd(AMD64.k1, tmp);
            masm.evpmovzxbw(vtmp, AMD64.k1, new AMD64Address(src));
            masm.evmovdqu16(new AMD64Address(dst), AMD64.k1, vtmp);
            masm.kmovq(AMD64.k1, AMD64.k2);
            masm.jmp(labelDone);
        }
        if (masm.supports(AMD64.CPUFeature.SSE4_1)) {
            Label labelSSETail = new Label();
            if (masm.supports(AMD64.CPUFeature.AVX2)) {
                Label labelAvx2Tail = new Label();
                masm.movl(tmp, len);
                masm.andl(tmp, -16);
                masm.jccb(AMD64Assembler.ConditionFlag.Zero, labelAvx2Tail);
                masm.andl(len, 15);
                masm.leaq(src, new AMD64Address(src, tmp, AMD64Address.Scale.Times1));
                masm.leaq(dst, new AMD64Address(dst, tmp, AMD64Address.Scale.Times2));
                masm.negq(tmp);
                Label labelAvx2Loop = new Label();
                masm.bind(labelAvx2Loop);
                masm.vpmovzxbw(vtmp, new AMD64Address(src, tmp, AMD64Address.Scale.Times1));
                masm.vmovdqu(new AMD64Address(dst, tmp, AMD64Address.Scale.Times2), vtmp);
                masm.addq(tmp, 16);
                masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelAvx2Loop);
                masm.bind(labelBelowThreshold);
                masm.bind(labelAvx2Tail);
                masm.movl(tmp, len);
                masm.andl(tmp, -8);
                masm.jccb(AMD64Assembler.ConditionFlag.Zero, labelSSETail);
                masm.andl(len, 7);
                masm.pmovzxbw(vtmp, new AMD64Address(src));
                masm.movdqu(new AMD64Address(dst), vtmp);
                masm.addq(src, 8);
                masm.addq(dst, 16);
            } else {
                masm.movl(tmp, len);
                masm.andl(tmp, -8);
                masm.jccb(AMD64Assembler.ConditionFlag.Zero, labelSSETail);
                masm.andl(len, 7);
                masm.leaq(src, new AMD64Address(src, tmp, AMD64Address.Scale.Times1));
                masm.leaq(dst, new AMD64Address(dst, tmp, AMD64Address.Scale.Times2));
                masm.negq(tmp);
                Label labelSSECopy8Loop = new Label();
                masm.bind(labelSSECopy8Loop);
                masm.pmovzxbw(vtmp, new AMD64Address(src, tmp, AMD64Address.Scale.Times1));
                masm.movdqu(new AMD64Address(dst, tmp, AMD64Address.Scale.Times2), vtmp);
                masm.addq(tmp, 8);
                masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelSSECopy8Loop);
            }
            Label labelCopyChars = new Label();
            masm.bind(labelSSETail);
            masm.cmpl(len, 4);
            masm.jccb(AMD64Assembler.ConditionFlag.Less, labelCopyChars);
            masm.movdl(vtmp, new AMD64Address(src));
            masm.pmovzxbw(vtmp, vtmp);
            masm.movq(new AMD64Address(dst), vtmp);
            masm.subq(len, 4);
            masm.addq(src, 4);
            masm.addq(dst, 8);
            masm.bind(labelCopyChars);
        }
        masm.testl(len, len);
        masm.jccb(AMD64Assembler.ConditionFlag.Zero, labelDone);
        masm.leaq(src, new AMD64Address(src, len, AMD64Address.Scale.Times1));
        masm.leaq(dst, new AMD64Address(dst, len, AMD64Address.Scale.Times2));
        masm.negq(len);
        Label labelCopyCharsLoop = new Label();
        masm.bind(labelCopyCharsLoop);
        masm.movzbl(tmp, new AMD64Address(src, len, AMD64Address.Scale.Times1));
        masm.movw(new AMD64Address(dst, len, AMD64Address.Scale.Times2), tmp);
        masm.incrementq(len, 1);
        masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelCopyCharsLoop);
        masm.bind(labelDone);
    }
}

